/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.review;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;

public class ReviewRejectValidator
extends HRDataBaseValidator {
    private static final ReviewBillApplicationService SERVICE = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);

    public void validate() {
        super.validate();
        if (!HRArrayUtils.isEmpty((Object[])this.dataEntities)) {
            List billPkIds = Arrays.stream(this.dataEntities).map(reviewBill -> Long.valueOf(reviewBill.getBillPkId().toString())).collect(Collectors.toList());
            DynamicObject[] bills = SERVICE.getOriginalReviewBillById("id,reviewstatus", billPkIds);
            Map<Long, DynamicObject> billMap = Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String status = billMap.get(dataEntity.getDataEntity().getLong("id")).getString("reviewstatus");
                if (ReviewStatusEnum.canBeRejected((String)status)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u9a73\u56de\u8bc4\u8bae\u72b6\u6001\u4e3a\u201c\u5f85\u8bc4\u8bae\u201d\u7684\u6570\u636e\u3002", (String)"ReviewRejectValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

