/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.appoint;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.opplugin.validator.appoint.AppointTerminateCommonValidator;
import kd.tdc.cadm.opplugin.validator.appoint.BillStatusCheckValidator;

public class AppointTerminateCommonOp
extends HRDataBaseOp {
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"nominateper", "terminationidea", "person", "employee", "appointstatus", "nominatestatus", "billstatus", "auditstatus", "terminater", "terminatedate", "acompany", "aposition", "aadminorg", "ajob", "astandardposition", "dposition", "djob", "dstandardposition", "dadminorg", "dcompany", "bpositionhis", "bjobhis", "badminorghis", "bcompanyhis", "appointfinishedtime", "departpersonid", "applykind"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillStatusCheckValidator("appointstatus", "nominatestatus"));
        e.addValidator((AbstractValidator)new AppointTerminateCommonValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            e.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String terminationReason = this.getOption().getVariableValue("terminationidea", null);
        String terminatorIdStr = this.getOption().getVariableValue("terminatorId", null);
        long terminatorId = terminatorIdStr == null ? UserServiceHelper.getCurrentUserId() : Long.parseLong(terminatorIdStr);
        nominateApplicationService.terminateAppoint(dataEntities, terminationReason, terminatorId);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] appointBills = e.getDataEntities();
        nominateApplicationService.batchTerminateAppointBill(appointBills);
    }
}

