/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.appoint;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.opplugin.validator.appoint.AppointUnSubmitCommonValidator;
import kd.tdc.cadm.opplugin.validator.appoint.BillStatusCheckValidator;

public class AppointUnSubmitCommonOp
extends HRDataBaseOp {
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"actvplanhis", "appointstatus", "nominatestatus", "billstatus", "auditstatus"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillStatusCheckValidator("appointstatus", "nominatestatus"));
        e.addValidator((AbstractValidator)new AppointUnSubmitCommonValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            e.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("appointstatus", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
            dataEntity.set("nominatestatus", (Object)NominateStatusEnum.WAIT_NOMINATE.getVal());
            dataEntity.set("billstatus", (Object)"G");
            dataEntity.set("auditstatus", (Object)"A");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        nominateApplicationService.batchUnSubmitAppointBill(dataEntities);
    }
}

