/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.brew;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.opplugin.validator.brew.BrewSubmitValidator;

public class BrewSubmitOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(BrewSubmitOp.class);
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"id", "billno", "brewstatus", "brewcandidate", "brewconclusion", "brewcomment", "nomhandler", "entryentity", "entryentity.candidate", "positiontype", "brewposition", "brewjob", "brewstandardposition", "handletime", "handler"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BrewSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("brewstatus", (Object)BrewStatusEnum.BREWOVER.getNumber());
            dataEntity.set("handletime", (Object)new Date());
            dataEntity.set("handler", (Object)RequestContext.get().getCurrUserId());
        }
        logger.info(MessageFormat.format("BrewSubmitOp bill[{0}] is update success", Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray()));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        brewBillApplicationService.sendAddNominateMessage(dataEntities);
    }
}

