/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.brew;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.MsgMaintainApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.opplugin.validator.brew.BrewUnSubmitValidator;

public class BrewUnSubmitOp
extends HRDataBaseOp {
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final MsgMaintainApplicationService msgMaintainApplicationService = (MsgMaintainApplicationService)ServiceFactory.getService(MsgMaintainApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"id", "billno", "brewstatus", "entryentity"}));
        evt.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BrewUnSubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isOpCancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            e.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("brewstatus", (Object)BrewStatusEnum.BREWING.getNumber());
            dataEntity.set("billstatus", (Object)"A");
        }
        List ids = Arrays.stream(dataEntities).map(entity -> entity.getLong("id")).collect(Collectors.toList());
        String revokeReason = this.getOption().getVariableValue("withdrawreason");
        brewBillApplicationService.revokeUpdateBrewBill(ids, revokeReason);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            entryEntity.forEach(entryRow -> {
                Long rowPkId = (Long)entryRow.getPkValue();
                msgMaintainApplicationService.dismissingMsg(rowPkId, "cadm_brewcandidateentry", "cadm_addNominate");
            });
        }
    }
}

