/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.dismiss;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.opplugin.validator.appoint.BillStatusCheckValidator;
import kd.tdc.cadm.opplugin.validator.dismiss.DismissSubmitValidator;
import kd.tdc.cadm.opplugin.web.nominate.NominateSubmitOp;

public class DismissBillSubmitOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(NominateSubmitOp.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"person", "employee", "appointstatus", "nominatestatus", "billstatus", "auditstatus", "nominateper", "nominatedate", "actvplanhis", "applytype", "aadminorg", "billno", "org.id", "person.id", "planenddate", "applykind", "prepositivedate", "appointdate", "employee", "dposition", "dismisstenure", "djob", "dstandardposition", "aposition", "ajob", "astandardposition", "acompany", "bcompanyhis", "badminorghis", "bpositionhis", "bjobhis", "bstandardpositionhis", "dadminorg", "dcompany"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillStatusCheckValidator("appointstatus", "nominatestatus"));
        e.addValidator((AbstractValidator)new DismissSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"number");
        Date nowDate = new Date();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("appointstatus", (Object)AppointStatusEnum.ING_APPOINT.getVal());
            dataEntity.set("nominatestatus", (Object)NominateStatusEnum.SUCCESS_NOMINATE.getVal());
            dataEntity.set("billstatus", (Object)"B");
            dataEntity.set("auditstatus", (Object)"B");
            dataEntity.set("nominatedate", (Object)nowDate);
            dataEntity.set("nominateper", (Object)currentUser);
            String billNo = dataEntity.getString("billno");
            nominateApplicationService.setOpBoId(dataEntity);
            try {
                DynamicObject actvScheme = ACTV_SERVICE.getActivitySchemeFromWorkflow(dataEntity);
                if (actvScheme == null) {
                    logger.error("getActivitySchemeFromWorkflow error, scheme is empty, billno: {}", (Object)billNo);
                    continue;
                }
                dataEntity.set("actvplanhis", (Object)actvScheme.getLong("id"));
            }
            catch (Exception exception) {
                String message = MessageFormat.format("nominate submit, call hrcs error:{0}", billNo);
                logger.error(message, (Throwable)exception);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        nominateApplicationService.initActivityBillsByActivityService(dataEntities);
    }
}

