/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.examine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.common.constants.AppointCommonConstants;
import kd.tdc.cadm.opplugin.validator.examine.ExamCoopSaveValidator;

public class ExamCoopSubmitOp
extends HRDataBaseOp {
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ExamCoopSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        Date now = new Date();
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("handler", (Object)RequestContext.get().getCurrUserId());
            dataEntity.set("handletime", (Object)now);
            Date createTime = dataEntity.getDate("createtime");
            long takeTimeMillis = now.getTime() - createTime.getTime();
            BigDecimal coopTakeTime = BigDecimal.valueOf(takeTimeMillis).divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
            dataEntity.set("cooptaketime", (Object)coopTakeTime);
            dataEntity.set("coopstatus", (Object)ExamCoopStatusEnum.COMPLETED.getNumber());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            long examineBillId = dataEntity.getLong("examinebillid");
            examineBillApplicationService.updateExamCoopRatio(Long.valueOf(examineBillId));
        }
    }
}

