/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.examine;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.opplugin.validator.appoint.ActBillStatusCheckValidator;
import kd.tdc.cadm.opplugin.validator.examine.ExamineBillRejectValidator;

public class ExamineBillRejectOp
extends HRDataBaseOp {
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("examinestatus");
        fieldKeys.add("instanceid");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ActBillStatusCheckValidator());
        e.addValidator((AbstractValidator)new ExamineBillRejectValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            e.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            dataEntity.set("modifytime", (Object)currDate);
            dataEntity.set("modifier", (Object)currUserId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            String opinion = this.getOption().getVariableValue("textedittitle");
            examineBillApplicationService.rejectToPreviousBill((DynamicObject[])dataEntities, opinion);
        }
    }
}

