/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.examine;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.service.ActivityBillCommonDomainService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.cadm.opplugin.validator.examine.ExamineBillStartValidator;

public class ExamineBillStartCoopOp
extends HRDataBaseOp {
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final ActivityBillCommonDomainService billCommonDomainService = (ActivityBillCommonDomainService)ServiceFactory.getService(ActivityBillCommonDomainService.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExamineBillStartValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(args);
        String coopOperate = this.getOption().getVariableValue("coop_type");
        long coopId = Long.parseLong(this.getOption().getVariableValue("coopId"));
        DynamicObject examCoop = examCoopBillApplicationService.startCoop(coopOperate, Long.valueOf(coopId));
        this.getOption().setVariableValue("examCoop", SerializationUtils.serializeToBase64((Object)examCoop));
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            long examineBillId = dataEntity.getLong("id");
            examineBillApplicationService.updateExamCoopRatio(Long.valueOf(examineBillId));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String examCoopStr = this.getOption().getVariableValue("examCoop");
        DynamicObject examCoop = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)examCoopStr);
        List userIds = billCommonDomainService.getActivityHandlerIds(examCoop, "coophandler");
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            Long billId = examCoop.getLong("id");
            Long nominateId = examCoop.getLong("nominatebill.id");
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_examinecooperate").setParameter("formPkId", String.valueOf(billId)).builder();
            BosMessageService.sendTemplateMessage((String)contentUrl, (List)userIds, (Long)nominateId, (String)"cadm_examinecooperate", (String)"cadm_startexam", (Long)billId);
        }
    }
}

