/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.examine;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.opplugin.validator.examine.ExamineBillStartValidator;

public class ExamineBillStartOp
extends HRDataBaseOp {
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("examplan");
        fieldKeys.add("examinestatus");
        fieldKeys.add("examcoopratio");
        fieldKeys.add("nominatebill");
        fieldKeys.add("person");
        fieldKeys.add("billno");
        fieldKeys.add("latestarrangerecord");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExamineBillStartValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        OperateOption option = this.getOption();
        Long examPlanSourceVid = Long.valueOf(option.getVariableValue("examplan"));
        DynamicObject examPlanS = examineBillApplicationService.queryExamPlanByExamPlanId(examPlanSourceVid);
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("examinestatus", (Object)ExamineStatusEnum.IN_EXAMINE.getNumber());
            dataEntity.set("examcoopratio", (Object)" ");
            dataEntity.set("examplan", (Object)examPlanS);
        }
        examineBillApplicationService.updateData(dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        OperateOption option = this.getOption();
        String interviewee = option.getVariableValue("interviewee");
        Map intervieweeMap = (Map)SerializationUtils.deSerializeFromBase64((String)interviewee);
        for (DynamicObject dataEntity : dataEntities) {
            examineBillApplicationService.startExam(dataEntity, intervieweeMap);
        }
    }
}

