/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.examine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.opplugin.validator.examine.ExamineBillSaveValidator;

public class ExamineBillSubmitOp
extends HRDataBaseOp {
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExamineBillSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("examinestatus", (Object)ExamineStatusEnum.COMPLETE.getNumber());
            dataEntity.set("examinetime", (Object)new Date());
            DynamicObject handler = UserServiceHelper.getCurrentUser((String)"number");
            dataEntity.set("subhandler", (Object)handler);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList examineIds = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long examineId = (Long)dataEntity.getPkValue();
            examineIds.add(examineId);
            examineBillApplicationService.updateExamCoopRatio(examineId);
        }
        examCoopBillApplicationService.terminationUnHandledExamCoop((List)examineIds, ExamCoopStatusEnum.TERMINATED, "cadm_finishexam");
        List insIds = Stream.of(dataEntities).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchConsentTask(insIds, " ");
    }
}

