/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.exped;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExpedCoopBillApplicationService;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.cadm.opplugin.validator.exped.ExpedBillStartValidator;

public class ExpedBillStartCoopOp
extends HRDataBaseOp {
    private static final ExpedCoopBillApplicationService expedCoopBillApplicationService = (ExpedCoopBillApplicationService)ServiceFactory.getService(ExpedCoopBillApplicationService.class);
    private static final ExpedBillApplicationService expedBillApplicationService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ExpedBillStartValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(args);
        String coopOperate = this.getOption().getVariableValue("coop_type");
        long coopId = Long.parseLong(this.getOption().getVariableValue("coopId"));
        DynamicObject expedCoop = expedCoopBillApplicationService.startCoop(coopOperate, Long.valueOf(coopId));
        this.getOption().setVariableValue("expedCoop", SerializationUtils.serializeToBase64((Object)expedCoop));
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            long examineBillId = dataEntity.getLong("id");
            expedBillApplicationService.updateExamCoopRatio(Long.valueOf(examineBillId));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String expedCoopStr = this.getOption().getVariableValue("expedCoop");
        DynamicObject expedCoop = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)expedCoopStr);
        List userIds = expedCoop.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(userIds)) {
            long rltCoopId = expedCoop.getLong("id");
            String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_expedcooperate").setParameter("formPkId", String.valueOf(rltCoopId)).builder();
            BosMessageService.sendTemplateMessage((String)contentUrl, userIds, (Long)rltCoopId, (String)"cadm_expedcooperate", (String)"cadm_startexplore", (Long)rltCoopId);
        }
    }
}

