/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.exped;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.common.constants.AppointCommonConstants;

public class ExpedCoopSubmitOp
extends HRDataBaseOp {
    private static final ExpedBillApplicationService expedService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        Date now = new Date();
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("handler", (Object)RequestContext.get().getCurrUserId());
            dataEntity.set("handletime", (Object)now);
            Date createTime = dataEntity.getDate("createtime");
            long takeTimeMillis = now.getTime() - createTime.getTime();
            BigDecimal coopTakeTime = BigDecimal.valueOf(takeTimeMillis).divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
            dataEntity.set("cooptaketime", (Object)coopTakeTime);
            dataEntity.set("coopstatus", (Object)ExpedCoopStatusEnum.COMPLETED.getNumber());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            long expedBillId = dataEntity.getDynamicObject("expedbill").getLong("id");
            expedService.updateExamCoopRatio(Long.valueOf(expedBillId));
        }
    }
}

