/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.issue;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.opplugin.validator.issue.IssueBillStatusValidator;

public class IssueBillSubmitOp
extends HRDataBaseOp {
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);
    private static final ReleaseBillApplicationService releaseService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ArrayList<String> issueStatus = new ArrayList<String>(10);
        issueStatus.add(IssueStatusEnum.TOBE_ISSUE.getNumber());
        e.addValidator((AbstractValidator)new IssueBillStatusValidator(issueStatus));
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("issuetype");
        fieldKeys.add("issuehandler");
        fieldKeys.add("issueresult");
        fieldKeys.add("issuetime");
        fieldKeys.add("appnoticedoc");
        fieldKeys.add("issueoptions");
        fieldKeys.add("subhandler");
        fieldKeys.add("submitdate");
        fieldKeys.add("instanceid");
        fieldKeys.add("nominatebill");
        fieldKeys.add("issuebatchnum");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String paramsStr = this.getOption().containsVariable("batchIssueParams") ? this.getOption().getVariableValue("batchIssueParams") : "";
        Map params = HRStringUtils.isEmpty((String)paramsStr) ? null : (Map)SerializationUtils.deSerializeFromBase64((String)paramsStr);
        DynamicObject[] dataEntities = e.getDataEntities();
        Date now = new Date();
        String batchNum = CodeRuleServiceHelper.getNumber((String)"cadm_appointissue", (DynamicObject)dataEntities[0], (String)String.valueOf(RequestContext.get().getOrgId()));
        for (DynamicObject dataEntity : dataEntities) {
            if (params != null) {
                dataEntity.set("issuetype", params.get("issuetype"));
                dataEntity.set("issuehandler", params.get("issuehandler"));
                dataEntity.set("issueresult", params.get("issueresult"));
                dataEntity.set("issuetime", params.get("issuetime"));
                dataEntity.set("appnoticedoc", params.get("appnoticedoc"));
                dataEntity.set("issueoptions", params.get("issueoptions"));
                dataEntity.set("issuebatchnum", (Object)batchNum);
            }
            dataEntity.set("issuestatus", (Object)IssueStatusEnum.HAS_ISSUED.getNumber());
            DynamicObject handler = UserServiceHelper.getCurrentUser((String)"number");
            dataEntity.set("subhandler", (Object)handler);
            dataEntity.set("submitdate", (Object)now);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        releaseService.initIssueFile(dataEntities);
        List insIds = Stream.of(dataEntities).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchConsentTask(insIds, " ");
    }
}

