/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.nominate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateAttachmentApplicationService;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;

public class NominateCompleteOp
extends HRDataBaseOp {
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final NominateAttachmentApplicationService nominateAttachmentApplicationService = (NominateAttachmentApplicationService)ServiceFactory.getService(NominateAttachmentApplicationService.class);
    private static final ReleaseBillApplicationService releaseBillApplicationService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private static final String RELEASE_TEMPLATE_NUMBER = "relsprinttpl.number";
    private static final String PUBLICITY_TEMPLATE_NUMBER = "pubfile.number";
    private static final String ISSUE_TEMPLATE_NUMBER = "appnoticedoc.number";
    private static final String PUBLIC_START_TIME = "pubstartdate";
    private static final String PUBLIC_END_TIME = "pubenddate";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("appointstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String appointStatus = dataEntity.getString("appointstatus");
            if (AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(appointStatus)) continue;
            long nominateId = dataEntity.getLong("id");
            nominateApplicationService.completeAppoint(Long.valueOf(nominateId));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.batchDealAttach(dataEntities);
        this.maintainAppointRemoveRel(dataEntities);
    }

    private void maintainAppointRemoveRel(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String appointStatus = dataEntity.getString("appointstatus");
            if (AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(appointStatus)) continue;
            long nominateId = dataEntity.getLong("id");
            nominateApplicationService.maintainAppointRemoveRel(nominateId);
        }
    }

    private void batchDealAttach(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            long nominateId = dataEntity.getLong("id");
            nominateApplicationService.sendMessageByEndAppoint(Long.valueOf(nominateId));
            DynamicObject releaseDynamicObject = releaseBillApplicationService.getEffectiveReleaseBillByNominateId(Long.valueOf(nominateId));
            DynamicObject publicityDynamic = publicityBillApplicationService.getEffectivePublicityBillByNominateId(Long.valueOf(nominateId));
            DynamicObject issueDynamic = issueBillApplicationService.getEffectiveIssueBillByNominateId(Long.valueOf(nominateId));
            if (null != releaseDynamicObject) {
                String releaseBatchNum = this.getBatchNum(releaseDynamicObject, "relsbatchnum");
                this.createAttach(releaseBatchNum, "cadm_appointrelease", releaseDynamicObject);
            }
            if (null != publicityDynamic) {
                String publicityBatchNum = this.getBatchNum(publicityDynamic, "pubbatchnum");
                this.createAttach(publicityBatchNum, "cadm_publicity", publicityDynamic);
            }
            if (null == issueDynamic) continue;
            String issueBatchNum = this.getBatchNum(issueDynamic, "issuebatchnum");
            this.createAttach(issueBatchNum, "cadm_appointissue", issueDynamic);
        }
    }

    private void createAttach(String batchNum, String entityName, DynamicObject dynamicObject) {
        if (HRStringUtils.isEmpty((String)batchNum)) {
            return;
        }
        List<Object> pkIdList = new ArrayList();
        String templateNumber = "";
        switch (entityName) {
            case "cadm_appointrelease": {
                String releaseSelectProperties = "id,relsprinttpl.number,releasetime";
                DynamicObject[] releaseByPubBatchNum = releaseBillApplicationService.getByPubBatchNum(releaseSelectProperties, batchNum);
                pkIdList = Arrays.stream(releaseByPubBatchNum).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                templateNumber = dynamicObject.getString(RELEASE_TEMPLATE_NUMBER);
                break;
            }
            case "cadm_publicity": {
                String publicitySelectProperties = "id,pubfile.number,pubstartdate,pubenddate";
                DynamicObject[] publicityByPubBatchNum = publicityBillApplicationService.getByPubBatchNum(publicitySelectProperties, batchNum);
                pkIdList = Arrays.stream(publicityByPubBatchNum).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                templateNumber = dynamicObject.getString(PUBLICITY_TEMPLATE_NUMBER);
                break;
            }
            case "cadm_appointissue": {
                String issueSelectProperties = "id,appnoticedoc.number,issuetime";
                DynamicObject[] issueByPubBatchNum = issueBillApplicationService.getByIssueBatchNum(issueSelectProperties, batchNum);
                pkIdList = Arrays.stream(issueByPubBatchNum).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                templateNumber = dynamicObject.getString(ISSUE_TEMPLATE_NUMBER);
                break;
            }
        }
        if (HRStringUtils.isNotEmpty((String)templateNumber) && pkIdList.size() > 0) {
            nominateAttachmentApplicationService.createAttachmentCommon(dynamicObject, pkIdList, entityName, templateNumber);
        }
    }

    private String getBatchNum(DynamicObject targetDynamic, String fieldBatchNum) {
        if (null != targetDynamic) {
            return targetDynamic.getString(fieldBatchNum);
        }
        return "";
    }
}

