/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.nominate;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.opplugin.validator.appoint.BillStatusCheckValidator;
import kd.tdc.cadm.opplugin.validator.nominate.NominateSubmitValidator;

public class NominateSubmitOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(NominateSubmitOp.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"appointstatus", "nominatestatus", "nominateper", "nominatedate", "actvplanhis", "applytype", "aadminorg", "billno", "org.id", "person.id", "planenddate", "prepositivedate", "appointdate", "employee", "dposition", "dismisstenure", "aposition", "ajob", "astandardposition", "djob", "dstandardposition", "mulitreferrer", "recommendsource", "muiltrecdept", "acompany", "dadminorg", "dcompany", "bcompanyhis", "badminorghis", "bpositionhis", "bjobhis", "bstandardpositionhis", "appointenddate", "perrecommendentry", "perrecommendentry.seq", "positiontype", "atenure", "dismisstenure"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillStatusCheckValidator("appointstatus", "nominatestatus"));
        e.addValidator((AbstractValidator)new NominateSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"number");
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("appointstatus", (Object)AppointStatusEnum.ING_APPOINT.getVal());
            dataEntity.set("nominatestatus", (Object)NominateStatusEnum.SUCCESS_NOMINATE.getVal());
            dataEntity.set("nominatedate", (Object)new Date());
            dataEntity.set("nominateper", (Object)currentUser);
            nominateApplicationService.setOpBoId(dataEntity);
            String billNo = dataEntity.getString("billno");
            try {
                DynamicObject actvScheme = ACTV_SERVICE.getActivitySchemeFromWorkflow(dataEntity);
                if (actvScheme == null) {
                    logger.error("getSchemeFromWorkflow error, scheme is empty, billno: {}", (Object)billNo);
                    continue;
                }
                dataEntity.set("actvplanhis", (Object)actvScheme.getLong("id"));
            }
            catch (Exception exception) {
                String message = MessageFormat.format("nominate submit, call hrcs error:{0}", billNo);
                logger.error(message, (Throwable)exception);
            }
        }
        logger.info(MessageFormat.format("NominateSubmitOp bill[{0}] is update success", Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray()));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        nominateApplicationService.initActivityBillsByActivityService(dataEntities);
    }
}

