/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.publicity;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.opplugin.validator.publicity.PublicitySubmitValidator;

public class PublicitySubmitOp
extends HRDataBaseOp {
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PublicitySubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("pubstatus", (Object)PublicityStatusEnum.COMPLETED.getPubStatus());
            dataEntity.set("pubhandletime", (Object)new Date());
            dataEntity.set("subhandler", (Object)UserServiceHelper.getCurrentUser((String)"number"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        List insIds = Stream.of(dataEntities).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchConsentTask(insIds, " ");
    }
}

