/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.publicity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.opplugin.validator.appoint.ActBillStatusCheckValidator;
import kd.tdc.cadm.opplugin.validator.publicity.PublicityWithdrawValidator;

public class PublicityWithdrawOp
extends HRDataBaseOp {
    private static final PublicityBillApplicationService SERVICE = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("pubstatus");
        fieldKeys.add("withdrawreason");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("pubbatchnum");
        fieldKeys.add("pubfilenum");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ActBillStatusCheckValidator());
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            args.addValidator((AbstractValidator)new PublicityWithdrawValidator());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            e.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] allPublicity;
        super.beginOperationTransaction(e);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        String withdrawReason = this.getOption().getVariableValue("textedittitle");
        String batchNumListStr = this.getOption().getVariableValue("batchNumList");
        List batchNumList = SerializationUtils.fromJsonStringToList((String)batchNumListStr, String.class);
        ArrayList batchNumListNew = Lists.newArrayList();
        batchNumList.forEach(object -> {
            if (object instanceof String) {
                batchNumListNew.add((String)object);
            }
        });
        String selectProperties = "modifytime,modifier,pubstatus,withdrawreason,pubbatchnum,pubfilenum";
        for (DynamicObject dataEntity : allPublicity = SERVICE.getByPubBatchNumList(selectProperties, (List)batchNumListNew)) {
            dataEntity.set("modifytime", (Object)currDate);
            dataEntity.set("modifier", (Object)currUserId);
            dataEntity.set("pubstatus", (Object)PublicityStatusEnum.RE_PUBLICIZED.getPubStatus());
            dataEntity.set("pubbatchnum", null);
            dataEntity.set("pubfilenum", null);
            dataEntity.set("withdrawreason", (Object)withdrawReason);
        }
        SERVICE.update(allPublicity);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }
}

