/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.release;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.opplugin.validator.appoint.ActBillStatusCheckValidator;
import kd.tdc.cadm.opplugin.validator.release.ReleaseWithdrawValidator;

public class ReleaseWithdrawOp
extends HRDataBaseOp {
    private static final ReleaseBillApplicationService releaseApplicationService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("releasestatus");
        fieldKeys.add("withdrawreason");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ActBillStatusCheckValidator());
        args.addValidator((AbstractValidator)new ReleaseWithdrawValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            e.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Date currDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        String withdrawReason = this.getOption().getVariableValue("textedittitle");
        for (DynamicObject dataEntity : e.getDataEntities()) {
            dataEntity.set("modifytime", (Object)currDate);
            dataEntity.set("modifier", (Object)currUserId);
            dataEntity.set("releasestatus", (Object)ReleaseStatusEnum.RE_PUBLICIZED.getNum());
            dataEntity.set("billstatus", (Object)"A");
            dataEntity.set("auditstatus", (Object)"A");
            dataEntity.set("withdrawreason", (Object)withdrawReason);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            releaseApplicationService.withdrawReleaseBill((DynamicObject[])dataEntities);
        }
    }
}

