/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.review;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.common.constants.AppointCommonConstants;
import kd.tdc.cadm.opplugin.validator.review.ReviewHelpSubmitValidator;

public class ReviewHelpSubmitOp
extends HRDataBaseOp {
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final String COOP_STATUS = "coopstatus";

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new ReviewHelpSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String coopstatus = dataEntity.getString(COOP_STATUS);
            if (HRStringUtils.equals((String)coopstatus, (String)CoopStatusEnum.WAIT.getVal())) {
                dataEntity.set(COOP_STATUS, (Object)CoopStatusEnum.PROCESSED.getVal());
            }
            Date date = new Date();
            dataEntity.set("coopdealtime", (Object)date);
            Date coopcreatetime = dataEntity.getDate("coopcreatetime");
            if (coopcreatetime != null) {
                long num = date.getTime() - coopcreatetime.getTime();
                BigDecimal bigDecimal = BigDecimal.valueOf(num);
                BigDecimal cooptaketime = bigDecimal.divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
                dataEntity.set("cooptaketime", (Object)cooptaketime.toString());
            }
            long currUserId = RequestContext.get().getCurrUserId();
            dataEntity.set("cooperater", (Object)currUserId);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            reviewBillApplicationService.updateReviewStatusAndRate(Long.valueOf(dataEntity.getLong("review")));
        }
    }
}

