/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.web.review;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;

public class ReviewSubmitOp
extends HRDataBaseOp {
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("reviewstatus", (Object)ReviewStatusEnum.RESULT_SUBMITTED.getReviewStatus());
            dataEntity.set("revdealtime", (Object)new Date());
            dataEntity.set("subhandler", (Object)UserServiceHelper.getCurrentUser((String)"number"));
            reviewBillApplicationService.terminateUnHandledReviewCoop((List)Lists.newArrayList((Object[])new Long[]{dataEntity.getLong("id")}), CoopStatusEnum.TERMINATE, "cadm_pytj");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        List insIds = Stream.of(dataEntities).map(item -> item.getLong("instanceid")).collect(Collectors.toList());
        ACTV_SERVICE.batchConsentTask(insIds, " ");
    }
}

