/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.appointaudit;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.AuditBillApplicationService;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;

public class AppointAuditEdit
extends HRCoreBaseBillEdit {
    private static final AuditBillApplicationService auditBillApplicationService = (AuditBillApplicationService)ServiceFactory.getService(AuditBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        cadmFormService.showBillHead(this.getView(), "headbillinfo");
        cadmFormService.showPersonInfoCard(this.getView(), "personcardflex");
        cadmFormService.showAppointInfoFlex(this.getView(), "appointinfo");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        long currUserId;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String pkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            billShowParameter.setPkId((Object)Long.valueOf(pkId));
        }
        DynamicObject auditBill = auditBillApplicationService.queryOne("appoauditstatus,handler,person.name", billShowParameter.getPkId());
        String appointAuditStatus = auditBill.getString("appoauditstatus");
        if (AppointAuditStatusEnum.NOT_TRIGGER.getNumber().equals(appointAuditStatus) || AppointAuditStatusEnum.DEL.getNumber().equals(appointAuditStatus)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u60a8\u7684\u8bbf\u95ee\u94fe\u63a5\u5df2\u5931\u6548\u3002", (String)"AppointAuditEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List handlerIds = auditBill.getDynamicObjectCollection("handler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (!handlerIds.contains(currUserId = RequestContext.get().getCurrUserId())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AppointAuditEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String personName = auditBill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u8d44\u683c\u5ba1\u67e5-{0}", (String)"AppointAuditEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        billShowParameter.setCaption(caption);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

