/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.appointaudit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.AuditBillApplicationService;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchRejectFormService;
import kd.tdc.cadm.formplugin.web.formservice.DismissPositionCommonService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class AppointAuditList
extends HRCoreBaseList {
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final AuditBillApplicationService auditApplicationService = (AuditBillApplicationService)ServiceFactory.getService(AuditBillApplicationService.class);
    private static final AppointBatchRejectFormService rejectFormService = (AppointBatchRejectFormService)ServiceFactory.getService(AppointBatchRejectFormService.class);
    private static final List<String> STATUS_LIST = Arrays.asList(AppointAuditStatusEnum.NOT_TRIGGER.getNumber(), AppointAuditStatusEnum.DEL.getNumber());
    private static final FormCommonService formCommonService = FormServiceFactory.getService(FormCommonService.class);
    private static final DismissPositionCommonService dismissPositionCommonService = (DismissPositionCommonService)ServiceFactory.getService(DismissPositionCommonService.class);
    private static final String WILL_DISMISS_POSITION = "nominatebill.dposition.name";

    public void setFilter(SetFilterEvent e) {
        QFilter idLikeFilter = new QFilter("handler.fbasedataid", "in", (Object)RequestContext.get().getCurrUserId());
        QFilter statusFilter = new QFilter("appoauditstatus", "not in", STATUS_LIST);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        e.getQFilters().add(appointStatusQFilter);
        e.getQFilters().add(idLikeFilter);
        e.getQFilters().add(statusFilter);
        e.setOrderBy("appoauditstatus asc,createtime desc");
    }

    public void packageData(PackageDataEvent eve) {
        ColumnDesc source = (ColumnDesc)eve.getSource();
        String fieldKey = source.getFieldKey();
        if ("handler.number".equals(fieldKey)) {
            cadmFormService.billListShowHandler(eve);
        }
        if (WILL_DISMISS_POSITION.equals(fieldKey)) {
            dismissPositionCommonService.packageDismissPositionData(eve, WILL_DISMISS_POSITION, "nominatebill.djob.name", "nominatebill.dstandardposition.name");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("reject".equals(operateKey)) {
            rejectFormService.setExportBills(this.getAuditBills());
            rejectFormService.callValidatorBeforeDoOperation(args, "reject", (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("reject")) {
            rejectFormService.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Map returnMap = CastUtils.castMap((Object)evt.getReturnData(), String.class);
        if ("reject_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            rejectFormService.rejectAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_part".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            rejectFormService.rejectPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        formCommonService.beforeCreateListColumns(args, "person.number");
    }

    private DynamicObject[] getAuditBills() {
        List pkIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        return auditApplicationService.queryAuditBillById("id,person.name,person.number,billno,nominatebill.aposition.name,,nominatebill.dposition.name,nominatebill.appointstatus,appoauditstatus,nominatebill.positiontype,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name", pkIds);
    }
}

