/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.baseorder;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class AppointBaseInfoPlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(AppointBaseInfoPlugin.class);
    private static final String POSITION = "position";
    private static final String ADMIN_ORG = "adminorg";
    private static final String JOBGRADE_NAME = "jobgrade.name";
    private static final String COMPANY = "company";
    private static final String GENDER = "gender";
    private static final String HEAD_SCULPTURE = "headsculpture";
    private static final String JOB_LEVEL = "joblevel";
    private static final String EMP_NUMBER = "empnumber";
    private static final String IMAGE_AP = "imageap";
    private static final String IMAGE_AP_1 = "imageap1";
    private static final String SUPERIOR_NAME = "superior.name";
    private static final String SUPERIOR_HEADSCULPTURE = "superior.headsculpture";
    private static final String JOB_LEVEL_NAME = "joblevel.name";
    private static final String FIELD_SUPERIOR_NAME = "superiorname";
    public static final String ICON = "_icon";
    private static final String VIEW_PERSON_RESUME = "personresume";
    private static final String VIEW = "47150e89000000ac";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String personId = (String)formShowParameter.getCustomParam("personId");
        String depEmpId = (String)formShowParameter.getCustomParam("depEmpId");
        String employeeId = (String)formShowParameter.getCustomParam("employee");
        DynamicObject empJobRel = this.getEmpJobRel(depEmpId);
        this.setJobLevel(empJobRel);
        Map personBaseInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfo", (Object[])new Object[]{Long.valueOf(personId)});
        String name = (String)personBaseInfoMap.get("name");
        String number = (String)personBaseInfoMap.get("number");
        String headSculpture = (String)personBaseInfoMap.get(HEAD_SCULPTURE);
        String gender = (String)personBaseInfoMap.get(GENDER);
        String company = (String)personBaseInfoMap.get(COMPANY);
        String adminOrg = (String)personBaseInfoMap.get(ADMIN_ORG);
        String position = (String)personBaseInfoMap.get(POSITION);
        if (StringUtils.isBlank((CharSequence)company) && StringUtils.isBlank((CharSequence)adminOrg) && StringUtils.isBlank((CharSequence)position)) {
            Map primaryEmpposorgrel = ExternalDataService.queryPrimaryEmpposorgrelUnlimited((Long)Long.valueOf(employeeId));
            company = (String)primaryEmpposorgrel.get("companyname");
            adminOrg = (String)primaryEmpposorgrel.get("adminorgname");
            String positionType = (String)primaryEmpposorgrel.get("apositiontype");
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                position = (String)primaryEmpposorgrel.get("stdpositionname");
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                position = (String)primaryEmpposorgrel.get("positionname");
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                position = (String)primaryEmpposorgrel.get("jobname");
            }
        }
        this.setLabelVal("name", name, "");
        this.setLabelVal(EMP_NUMBER, number, "");
        Image image = (Image)this.getControl(IMAGE_AP);
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)headSculpture));
        this.setLabelVal(GENDER, gender, "gender_icon");
        this.setLabelVal(COMPANY, company, "company_icon");
        this.setLabelVal(ADMIN_ORG, adminOrg, "adminorg_icon");
        this.setLabelVal(POSITION, position, "position_icon");
        long depEmpLongId = HRStringUtils.isBlank((CharSequence)depEmpId) ? 0L : Long.parseLong(depEmpId);
        Map directSuperiorList = ExternalDataService.getDirectSuperiorByDepEmpId((List)Lists.newArrayList((Object[])new Long[]{depEmpLongId}));
        if (directSuperiorList.size() > 0) {
            String superiorName = (String)((Map)((List)directSuperiorList.get(depEmpLongId)).get(0)).get(SUPERIOR_NAME);
            String supHeadSculpture = (String)((Map)((List)directSuperiorList.get(depEmpLongId)).get(0)).get(SUPERIOR_HEADSCULPTURE);
            this.setLabelVal(FIELD_SUPERIOR_NAME, superiorName, "superiorflex");
            Image image1 = (Image)this.getControl(IMAGE_AP_1);
            image1.setUrl(HRImageUrlUtil.getImageFullUrl((String)supHeadSculpture));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"superiorflex"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label label = (Label)this.getControl(VIEW_PERSON_RESUME);
        label.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        long currUserId = RequestContext.get().getCurrUserId();
        String entityId = this.getView().getParentView().getEntityId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)entityId, (String)VIEW);
        IFormView currentView = this.getView();
        String grandEntityId = "";
        if (null != currentView.getParentView() && null != currentView.getParentView().getParentView()) {
            grandEntityId = this.getView().getParentView().getParentView().getEntityId();
        }
        String systemType = "tdc-cadm-formplugin";
        logger.info("hasPerm:{}, grandEntityId:{}", (Object)hasPerm, (Object)grandEntityId);
        if (!hasPerm && !"wf_msg_center".equals(grandEntityId)) {
            String message = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u67e5\u8be2\u4e2a\u4eba\u5c65\u5386\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AppointBaseInfoPlugin_0", (String)systemType, (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return;
        }
        if (VIEW_PERSON_RESUME.equals(source.getKey())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String personId = (String)showParameter.getCustomParam("personId");
            String employeeId = (String)showParameter.getCustomParam("employee");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cadm_personresume");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("personId", (Object)personId);
            formShowParameter.setCustomParam("employee", (Object)employeeId);
            this.getView().showForm(formShowParameter);
        }
    }

    private DynamicObject getEmpJobRel(String depEmpId) {
        if (HRStringUtils.isEmpty((String)depEmpId)) {
            logger.info("AppointBaseInfoPlugin getAndUpdateEmpJobRel is fail, depEmpId is empty");
            return null;
        }
        DynamicObject depemp = ExternalDataService.getDepempByPkVal((Long)Long.valueOf(depEmpId));
        if (HRObjectUtils.isEmpty((Object)depemp)) {
            logger.info("AppointBaseInfoPlugin getAndUpdatePernontsprop is fail, empJobRel not find (is empty)");
            return null;
        }
        DynamicObject employee = depemp.getDynamicObject("employee");
        if (HRObjectUtils.isEmpty((Object)employee)) {
            logger.info("AppointBaseInfoPlugin getAndUpdatePernontsprop is fail, employee not find (is empty)");
            return null;
        }
        return ExternalDataService.getEmpJobRelByEmployee((Long)employee.getLong("id"), (String)"joblevel, jobgrade, job, company, adminorg, position");
    }

    private void setJobLevel(DynamicObject empJobRel) {
        String jobLevel = "";
        if (empJobRel != null && empJobRel.getLong("id") != 0L) {
            String string = jobLevel = empJobRel.getString(JOB_LEVEL_NAME) == null ? "" : empJobRel.getString(JOB_LEVEL_NAME);
            if (HRStringUtils.isNotEmpty((String)empJobRel.getString(JOBGRADE_NAME))) {
                jobLevel = jobLevel + empJobRel.getString(JOBGRADE_NAME);
            }
        }
        this.setLabelVal(JOB_LEVEL, jobLevel, "joblevel_icon");
    }

    private void setLabelVal(String label, String val, String iconKey) {
        Label control = (Label)this.getView().getControl(label);
        if (HRStringUtils.isNotEmpty((String)val)) {
            control.setText(val);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{label, iconKey});
        }
    }
}

