/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.baseorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;

public class PersonResumePlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(PersonResumePlugin.class);
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final String PERSON_ID = "personId";
    private static final String PERSON = "person";
    private static final String EMP_POS_ORG_REL_ENTRY = "empposorgrelentry";
    private static final String PER_OCP_QUAL_ENTRY = "perocpqualentry";
    private static final String PER_RP_RECORD_ENTRY = "perrprecordentry";
    private static final String FAMILY_MEMB_ENTRY = "familymembentry";
    private static final String PER_EDU_EXP_ENTRY = "pereduexpentry";
    private static final String[] EMP_POS_ORG_REL_FIELDS = new String[]{"startdate", "sysenddate", "adminorgname", "positionname", "isprimary", "postypename"};
    private static final String[] PER_OCP_QUAL_FIELDS = new String[]{"qualificationname", "qualevelname", "gettime", "expirationdate", "registratedate", "grantunit", "registrationunit", "perocpqualname"};
    private static final String[] PER_RP_RECORD_FIELDS = new String[]{"typename", "levelname", "flag", "rewarddate", "content", "unit"};
    private static final String[] FAMILY_MEMB_FIELDS = new String[]{"name", "familymembshipname", "workunit", "mobilephone"};
    private static final String[] PER_EDU_EXP_FIELDS = new String[]{"admissiondate", "gradutiondate", "graduateschoolname", "major", "educationname", "degreename", "ishighestdegree", "isfulltime"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String personIdStr = (String)formShowParameter.getCustomParam(PERSON_ID);
        String employeeIdStr = (String)formShowParameter.getCustomParam("employee");
        if (HRStringUtils.isEmpty((String)personIdStr)) {
            logger.info(MessageFormat.format("PersonResumePlugin bind data is fail, personId is {0}", personIdStr));
            return;
        }
        Long personId = Long.valueOf(personIdStr);
        this.getPersonBaseInfo(personId);
        QFilter[] qFilters = new QFilter[]{new QFilter(PERSON, "=", (Object)personId)};
        if (HRStringUtils.isNotEmpty((String)employeeIdStr)) {
            Long employeeId = Long.valueOf(employeeIdStr);
            this.setDataForEntry(EMP_POS_ORG_REL_ENTRY, EMP_POS_ORG_REL_FIELDS, ExternalDataService.getEmpPosOrgRel((Long)employeeId));
            Map baseLocation = ExternalDataService.getBaseLocation((Long)employeeId);
            if (baseLocation.isEmpty()) {
                logger.info(MessageFormat.format("PersonResumePlugin getBaseLocation is fail, baseLocation is empty, employee is {0}", employeeId));
            } else {
                this.getModel().setValue("location", baseLocation.get("baselocation"));
            }
            Map empentrel = ExternalDataService.getEmpentrel((Long)employeeId);
            if (empentrel.isEmpty()) {
                logger.info(MessageFormat.format("PersonResumePlugin getEmpEntrel is fail, empentrel is empty, employee is {0}", employeeId));
            } else {
                Date firststartdate = (Date)empentrel.get("startdate");
                this.getModel().setValue("firststartdate", (Object)firststartdate);
            }
        }
        this.setDataForEntry("cadm_tenure", qFilters, "tenureentry", "tenuredata", "realstartdate DESC");
        this.setDataForEntry(PER_OCP_QUAL_ENTRY, PER_OCP_QUAL_FIELDS, ExternalDataService.getPerocpqual((Long)personId));
        this.setDataForEntry(PER_RP_RECORD_ENTRY, PER_RP_RECORD_FIELDS, ExternalDataService.getPerrprecord((Long)personId));
        this.setDataForEntry(FAMILY_MEMB_ENTRY, FAMILY_MEMB_FIELDS, ExternalDataService.getFamilyMemb((Long)personId));
        this.setDataForEntry(PER_EDU_EXP_ENTRY, PER_EDU_EXP_FIELDS, ExternalDataService.getPerEduExp((Long)personId));
    }

    private void setDataForEntry(String entryName, String[] fields, List<Map<String, Object>> mapList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryName);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(fields);
        for (Map<String, Object> map : mapList) {
            Object mobilephone = map.get("mobilephone");
            if (mobilephone != null) {
                String mobilePhone = (String)mobilephone;
                if (HRStringUtils.isNotEmpty((String)mobilePhone) && mobilePhone.length() > 3) {
                    mobilePhone = new StringBuffer(mobilePhone).replace(3, 7, "****").toString();
                }
                map.put("mobilephone", mobilePhone);
            }
            Object[] row = Stream.of(fields).map(map::get).toArray();
            vs.addRow(row);
        }
        model.batchCreateNewEntryRow(entryName, vs);
        model.endInit();
        this.getView().updateView(entryName);
    }

    private void setDataForEntry(String pageCode, QFilter[] qFilters, String entryName, String field, String orderBy) {
        DynamicObject[] dynamicObjects = tenureApplicationService.queryTenureData(qFilters, orderBy);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryName);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(field, new Object[0]);
        for (DynamicObject dynamicObject : dynamicObjects) {
            vs.addRow(new Object[]{dynamicObject.getPkValue()});
        }
        model.batchCreateNewEntryRow(entryName, vs);
        model.endInit();
        this.getView().updateView(entryName);
    }

    private void getPersonBaseInfo(Long personId) {
        Map perMap = ExternalDataService.getPersonInfo((Long)personId);
        if (perMap.isEmpty()) {
            logger.info(MessageFormat.format("PersonResumePlugin getPersonBaseInfo is fail, pernontsprop is empty, person is {0}", personId));
        } else {
            Object entServiceLen = perMap.get("entservicelen");
            this.getModel().setValue("entservicelen", (Object)(entServiceLen == null ? "0" : ((BigDecimal)entServiceLen).setScale(1, RoundingMode.HALF_UP).toString()));
            this.getModel().setValue("beginservicedate", perMap.get("beginservicedate"));
            this.getModel().setValue("location", perMap.get("workplace"));
            this.getModel().setValue("nationality", perMap.get("nationality"));
            this.getModel().setValue("folk", perMap.get("folk"));
            this.getModel().setValue("birthday", perMap.get("birthday"));
            this.getModel().setValue("age", perMap.get("age"));
        }
        Map perregion = ExternalDataService.getPerRegion((Long)personId);
        if (perregion.isEmpty()) {
            logger.info(MessageFormat.format("PersonResumePlugin getPersonBaseInfo is fail, perregion is empty, person is {0}", personId));
        } else {
            this.getModel().setValue("nativeplace", perregion.get("nativeplace"));
            this.getModel().setValue("birthplace", perregion.get("birthplace"));
            this.getModel().setValue("politicalstatus", perregion.get("politicalstatus"));
            this.getModel().setValue("party", perregion.get("party"));
            this.getModel().setValue("joinpartydate", perregion.get("joinpartydate"));
        }
    }
}

