/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.brew;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewPersonPositionMatchEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.BrewBillCandidateFormService;
import kd.tdc.cadm.formplugin.web.formservice.BrewBillPositionPersonFormService;

public class BrewBillEdit
extends HRCoreBaseBillEdit
implements HyperLinkClickListener,
BeforeF7SelectListener,
ClickListener {
    private static final String FLEX_BILL_CONTENT = "flexbillcontent";
    private static final String FLEX_BILL_BLANK = "flexbillblank";
    private static final String FLEX_CANDIDATE_INFO = "flexcandidateinfo";
    private static final String FLEX_CANDIDATE_BLANK = "flexcandidateblank";
    private static final String BTN_ADDCANDIDATE = "btnaddcandidate";
    private static final String BTN_ADDTALENT = "btnaddtalent";
    private static final String BTN_QUICKINPUTBREW = "quickinputbrew";
    private static final String BTN_CANDIDATE_COMP = "candidatecomp";
    private static final String OP_BREWPASS = "brewpass";
    private static final String OP_BREWNOPASS = "brewnopass";
    private static final String OP_DELETEENTRY = "deleteentry";
    private static final String OP_MATCHDETAIL = "matchdetail";
    private static final String FIELD_ADDCANDF7 = "addcandf7";
    private static final String OPPARAM_ISOK = "isok";
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String OP_REFRESH = "refresh";
    private static final String BTN_EXPAND = "btnexpand";
    private static final String BTN_COLLAPSE = "btncollapse";
    private static final String FLEX_BILLINFO = "flexbillinfo";
    private static final String CARDFLEX_AGE = "cardflexage";
    private static final String CARDFLEX_SERVICELEN = "cardflexservicelen";
    private static final String CARDFLEX_ENTSERVICELEN = "cardflexentservicelen";
    private static final String CARDFLEX_JOBLEVEL = "cardflexjoblevel";
    private static final String CARDFLEX_CARDPOS = "cardpos";
    private static final String CARDFLEX_CARDMANAGEPOS = "cardmanagepos";
    private static final String CACHE_ISCHECKBREWDATE = "ischeckbrewdate";
    private static final String CACHE_BREWMATCHDETAIL = "brewmatchdetail";
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final BrewBillPositionPersonFormService positionPersonFormService = (BrewBillPositionPersonFormService)ServiceFactory.getService(BrewBillPositionPersonFormService.class);
    private static final BrewBillCandidateFormService candidateFormService = (BrewBillCandidateFormService)ServiceFactory.getService(BrewBillCandidateFormService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_ADDCANDIDATE, BTN_ADDTALENT, BTN_QUICKINPUTBREW, BTN_CANDIDATE_COMP, BTN_EXPAND, BTN_COLLAPSE});
        CardEntry candidateEntry = (CardEntry)this.getControl("candidateentry");
        if (candidateEntry != null) {
            candidateEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        BasedataEdit brewPosition = (BasedataEdit)this.getControl("brewposition");
        BasedataEdit brewStandardPosition = (BasedataEdit)this.getControl("brewstandardposition");
        BasedataEdit brewJob = (BasedataEdit)this.getControl("brewjob");
        brewPosition.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        brewStandardPosition.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        brewJob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Vector nextPage = (Vector)this.getControl("nextpage");
        nextPage.addClickListener((ClickListener)this);
        Vector prePage = (Vector)this.getControl("prepage");
        prePage.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        OperationStatus operationStatus = billShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            String caption = ResManager.loadKDString((String)"\u65b0\u589e\u915d\u917f\u52a8\u8bae", (String)"BrewBillEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            billShowParameter.setCaption(caption);
            return;
        }
        if (OperationStatus.VIEW.equals((Object)operationStatus) || OperationStatus.EDIT.equals((Object)operationStatus)) {
            long pkId = Long.parseLong(billShowParameter.getPkId().toString());
            String brewName = "";
            DynamicObject brewBill = brewBillApplicationService.getBrewBillById("positiontype,brewposition,brewstandardposition,brewjob", pkId);
            String positionType = brewBill.getString("positiontype");
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                brewName = brewBill.getString("brewstandardposition.name");
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                brewName = brewBill.getString("brewposition.name");
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                brewName = brewBill.getString("brewjob.name");
            }
            String caption = ResManager.loadKDString((String)"\u915d\u917f\u52a8\u8bae-{0}", (String)"BrewBillEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[]{brewName});
            billShowParameter.setCaption(caption);
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initBrewDate();
        this.loadInfoByType();
        positionPersonFormService.loadPositionPersonCardEntry((AbstractFormPlugin)this, 1);
        candidateFormService.loadCandidateCardEntry((AbstractFormPlugin)this);
        candidateFormService.calculateCandidateEntryData((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewVisible(true);
        this.expandBillInfoFlex();
        CardEntry cardEntry = (CardEntry)this.getControl("candidateentry");
        cardEntry.setMustInput("nominatehandler", true);
        cardEntry.setMustInput("candbrewcomment", true);
        cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"isbrewpass", "candbrewcomment", "nominatehandler"});
    }

    private void expandBillInfoFlex() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_BILLINFO, BTN_COLLAPSE});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EXPAND});
    }

    private void collapseBillInfoFlex() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EXPAND});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_BILLINFO, BTN_COLLAPSE});
    }

    private void initBrewDate() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Date brewDate = (Date)this.getModel().getValue("brewdate");
        if (brewDate == null && status.equals((Object)OperationStatus.EDIT)) {
            this.getModel().setValue("brewdate", (Object)new Date());
        }
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "btnaddcandidate": 
            case "btnaddtalent": {
                candidateFormService.showSelectCandidateF7((AbstractFormPlugin)this);
                break;
            }
            case "quickinputbrew": {
                this.showQuickInputConclusion();
                break;
            }
            case "candidatecomp": {
                this.showCandidateComp();
                break;
            }
            case "btncollapse": {
                this.collapseBillInfoFlex();
                break;
            }
            case "btnexpand": {
                this.expandBillInfoFlex();
                break;
            }
            case "nextpage": {
                this.loadNextPage();
                break;
            }
            case "prepage": {
                this.loadPrePage();
                break;
            }
        }
    }

    private void loadPrePage() {
        boolean isFirstPage;
        int currentPage = (Integer)this.getModel().getValue("currentpage");
        boolean bl = isFirstPage = currentPage == 1;
        if (!isFirstPage) {
            int prePage = currentPage - 1;
            positionPersonFormService.loadPositionPersonCardEntry((AbstractFormPlugin)this, prePage);
        }
    }

    private void loadNextPage() {
        boolean isLastPage;
        int totalPage = (Integer)this.getModel().getValue("totalpage");
        int currentPage = (Integer)this.getModel().getValue("currentpage");
        boolean bl = isLastPage = currentPage >= totalPage;
        if (!isLastPage) {
            int nextPage = currentPage + 1;
            positionPersonFormService.loadPositionPersonCardEntry((AbstractFormPlugin)this, nextPage);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals(OP_DELETEENTRY) && !this.isConfirmDelete(formOperate)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5df2\u9009\u4e2d\u7684\u5019\u9009\u4eba\u53ca\u5176\u76f8\u5173\u915d\u917f\u7ed3\u8bba\u4fe1\u606f\u5c06\u88ab\u5220\u9664\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"BrewBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(OP_DELETEENTRY, (IFormPlugin)this));
            args.setCancel(true);
            return;
        }
        if (operateKey.equals(OP_SAVE)) {
            if (this.checkBrewPositionIsEmpty()) {
                return;
            }
            this.updateCandidateDBEntry();
            this.cacheCandidateCardEntry();
        }
        if (operateKey.equals(OP_SUBMIT)) {
            String isCheckBrewDate = this.getPageCache().get(CACHE_ISCHECKBREWDATE);
            if (HRStringUtils.equals((String)isCheckBrewDate, (String)"1")) {
                this.getPageCache().put(CACHE_ISCHECKBREWDATE, "0");
                return;
            }
            if (!this.checkBrewDate()) {
                args.setCancel(true);
            }
            this.updateCandidateDBEntry();
            this.cacheCandidateCardEntry();
        }
    }

    private boolean checkBrewDate() {
        Date nowDate;
        Date brewDate = this.getModel().getDataEntity().getDate("brewdate");
        if (HRDateTimeUtils.dayAfter((Date)brewDate, (Date)(nowDate = new Date()))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u915d\u917f\u52a8\u8bae\u65e5\u671f\u201d\u5927\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\u3002", (String)"BrewBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OP_SUBMIT, (IFormPlugin)this));
            this.getPageCache().put(CACHE_ISCHECKBREWDATE, "1");
            return false;
        }
        return true;
    }

    private void cacheCandidateCardEntry() {
        DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
        this.getPageCache().put("candidateentry", SerializationUtils.serializeToBase64((Object)candidateEntry));
    }

    private void updateCandidateDBEntry() {
        DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
        this.getModel().deleteEntryData("entryentity");
        if (candidateEntry.isEmpty()) {
            this.getModel().setValue("brewcandidate", null);
            this.getModel().updateCache();
            return;
        }
        int[] entryRow = this.getModel().batchCreateNewEntryRow("entryentity", candidateEntry.size());
        Long[] candidateIds = new Long[candidateEntry.size()];
        for (int i = 0; i < candidateEntry.size(); ++i) {
            DynamicObject candidateObj = (DynamicObject)candidateEntry.get(i);
            long personId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("candcardperson"));
            long candidateId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("candcardemployee"));
            candidateIds[i] = candidateId;
            long cmpEmpId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("candcardcmpemp"));
            long depEmpId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("candcarddepemp"));
            long companyId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("candcardcompany"));
            long adminorgId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("candcardadminorg"));
            String isBrewPass = candidateObj.getString("isbrewpass");
            String brewComment = candidateObj.getString("candbrewcomment");
            long nominateHandlerId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("nominatehandler"));
            this.getModel().setValue("person", (Object)personId, entryRow[i]);
            this.getModel().setValue("candidate", (Object)candidateId, entryRow[i]);
            this.getModel().setValue("cmpemp", (Object)cmpEmpId, entryRow[i]);
            this.getModel().setValue("depemp", (Object)depEmpId, entryRow[i]);
            this.getModel().setValue("candcompany", (Object)companyId, entryRow[i]);
            this.getModel().setValue("candadminorg", (Object)adminorgId, entryRow[i]);
            this.getModel().setValue("brewconclusion", (Object)isBrewPass, entryRow[i]);
            this.getModel().setValue("brewcomment", (Object)brewComment, entryRow[i]);
            if (HRStringUtils.equals((String)isBrewPass, (String)"1")) {
                this.getModel().setValue("nomhandler", (Object)nominateHandlerId, entryRow[i]);
                continue;
            }
            this.getModel().setValue("nomhandler", null, entryRow[i]);
        }
        this.getModel().setValue("brewcandidate", (Object)candidateIds);
        this.getModel().updateCache();
    }

    private boolean checkBrewPositionIsEmpty() {
        DynamicObject brewObject = this.getBrewObject();
        return brewObject == null;
    }

    private boolean isConfirmDelete(FormOperate formOperate) {
        if (formOperate.getOption() == null) {
            return false;
        }
        return HRStringUtils.equals((String)formOperate.getOption().getVariableValue(OPPARAM_ISOK, "0"), (String)"1");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (callBackId.equals(OP_DELETEENTRY) && resultValue.equals((Object)MessageBoxResult.Yes)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_ISOK, "1");
            this.getView().invokeOperation(OP_DELETEENTRY, operateOption);
            this.setCandidateViewVisible();
        }
        if (callBackId.equals(OP_SUBMIT)) {
            if (resultValue.equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation(OP_SUBMIT);
                return;
            }
            this.getPageCache().put(CACHE_ISCHECKBREWDATE, "0");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals(OP_BREWPASS) || operateKey.equals(OP_BREWNOPASS)) {
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
                return;
            }
            this.setEntryBrewConclusion(operateKey);
            candidateFormService.calculateCandidateEntryData((AbstractFormPlugin)this);
            return;
        }
        if (operateKey.equals(OP_DELETEENTRY)) {
            candidateFormService.calculateCandidateEntryData((AbstractFormPlugin)this);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"hasrevocationperm") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            long pkValue = this.getModel().getDataEntity().getLong("id");
            Tuple judgeResult = brewBillApplicationService.judgeEnableRevocation(Long.valueOf(pkValue), "revocation");
            if (!((Boolean)judgeResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)((Tuple)judgeResult.item2).item2);
                return;
            }
            this.showRevocationForm();
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)OP_MATCHDETAIL) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.showMatchDetailForm();
            return;
        }
        if ((HRStringUtils.equals((String)operateKey, (String)OP_SUBMIT) || HRStringUtils.equals((String)operateKey, (String)OP_SAVE)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            long billId = this.getModel().getDataEntity().getLong("id");
            DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
            HashMap<Long, List<BrewMatchBo>> brewMatchResult = new HashMap<Long, List<BrewMatchBo>>(16);
            for (int i = 0; i < candidateEntry.size(); ++i) {
                long employeeId = HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)candidateEntry.get(i)).getDynamicObject("candcardemployee"));
                List<BrewMatchBo> matchDetailData = this.getMatchDetailData(i);
                brewMatchResult.put(employeeId, matchDetailData);
            }
            brewBillApplicationService.saveBrewMatchData(Long.valueOf(billId), brewMatchResult);
        }
        if ((HRStringUtils.equals((String)operateKey, (String)OP_SAVE) || HRStringUtils.equals((String)operateKey, (String)OP_SUBMIT) || HRStringUtils.equals((String)operateKey, (String)"revocation")) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation(OP_REFRESH);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("positiontype") || propertyName.equals("brewposition") || propertyName.equals("brewstandardposition") || propertyName.equals("brewjob")) {
            this.loadInfoByType();
            this.setAdminorgAndCompany();
            positionPersonFormService.loadPositionPersonCardEntry((AbstractFormPlugin)this, 1);
            this.setViewVisible(false);
            return;
        }
        if (propertyName.equals(FIELD_ADDCANDF7)) {
            candidateFormService.candidateF7Changed((AbstractFormPlugin)this);
            this.setCandidateViewVisible();
        }
        if ("currentpage".equals(propertyName)) {
            this.currentPageChanged();
        }
    }

    private void currentPageChanged() {
        int currentPage = (Integer)this.getModel().getValue("currentpage");
        if (currentPage < 1) {
            this.getModel().setValue("currentpage", (Object)1);
            return;
        }
        int totalPage = (Integer)this.getModel().getValue("totalpage");
        if (currentPage > totalPage) {
            this.getModel().setValue("currentpage", (Object)totalPage);
            return;
        }
        positionPersonFormService.loadPositionPersonCardEntry((AbstractFormPlugin)this, currentPage);
    }

    private void loadInfoByType() {
        DynamicObject brewObject = this.getBrewObject();
        String positionType = this.getModel().getValue("positiontype") == null ? "" : this.getModel().getValue("positiontype").toString();
        this.setMust(positionType);
        if (brewObject == null) {
            this.clearBrewObject(positionType);
            return;
        }
        this.loadLabelName(positionType);
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            this.loadStanderPosition(brewObject);
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            this.loadPosition(brewObject);
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            this.loadJob(brewObject);
        }
    }

    private void clearBrewObject(String positionType) {
        this.loadLabelName(positionType);
        this.getModel().setValue("brewstandardposition", null);
        this.getModel().setValue("brewposition", null);
        this.getModel().setValue("brewjob", null);
        this.getModel().setValue("adminorgname", null);
        this.getModel().setValue("positionname", null);
        this.getModel().setValue("orientation", null);
        this.getModel().setValue("duty", null);
        this.getModel().setValue("standard", null);
        this.getModel().setValue("diplomareqname", null);
        this.getModel().setValue("agereq", null);
        this.getModel().setValue("knowledgereq", null);
        this.getModel().setValue("skillreq", null);
        this.getModel().setValue("abilityreq", null);
        this.getModel().setValue("experiencereq", null);
        this.getModel().deleteEntryData("pospersonentry");
        this.getView().updateView("pospersonentry");
    }

    private void loadStanderPosition(DynamicObject brewObj) {
        if (brewObj == null) {
            return;
        }
        String createorgname = brewObj.getString("createorg.name");
        this.getModel().setValue("adminorgname", (Object)createorgname);
        String name = brewObj.getString("name");
        this.getModel().setValue("positionname", (Object)name);
    }

    private void loadPosition(DynamicObject brewObj) {
        if (brewObj == null) {
            return;
        }
        String adminorgname = brewObj.getString("adminorg.name");
        this.getModel().setValue("adminorgname", (Object)adminorgname);
        String name = brewObj.getString("name");
        this.getModel().setValue("positionname", (Object)name);
        String posorientation = brewObj.getString("posorientation");
        this.getModel().setValue("orientation", (Object)posorientation);
        String posduty = brewObj.getString("posduty");
        this.getModel().setValue("duty", (Object)posduty);
        String posstandard = brewObj.getString("posstandard");
        this.getModel().setValue("standard", (Object)posstandard);
        this.setRequireValue(brewObj);
    }

    private void loadJob(DynamicObject brewObj) {
        if (brewObj == null) {
            return;
        }
        String createorgname = brewObj.getString("createorg.name");
        this.getModel().setValue("adminorgname", (Object)createorgname);
        String name = brewObj.getString("name");
        this.getModel().setValue("positionname", (Object)name);
        String joborientation = brewObj.getString("joborientation");
        this.getModel().setValue("orientation", (Object)joborientation);
        String jobduty = brewObj.getString("jobduty");
        this.getModel().setValue("duty", (Object)jobduty);
        String jobstandard = brewObj.getString("jobstandard");
        this.getModel().setValue("standard", (Object)jobstandard);
        this.setRequireValue(brewObj);
    }

    private void loadLabelName(String positionType) {
        String name = "";
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            name = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"BrewBillEdit_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            name = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"BrewBillEdit_11", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            name = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"BrewBillEdit_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        }
        this.setControlVal("positiontitlelab", ResManager.loadKDString((String)"{0}\u4fe1\u606f", (String)"BrewBillEdit_13", (String)"tdc-cadm-formplugin", (Object[])new Object[]{name}));
        this.setControlVal("dutytab", ResManager.loadKDString((String)"{0}\u804c\u8d23", (String)"BrewBillEdit_14", (String)"tdc-cadm-formplugin", (Object[])new Object[]{name}));
        this.setControlVal("reqtab", ResManager.loadKDString((String)"{0}\u8981\u6c42", (String)"BrewBillEdit_17", (String)"tdc-cadm-formplugin", (Object[])new Object[]{name}));
        this.setControlVal("orientationlab", ResManager.loadKDString((String)"{0}\u5b9a\u4f4d", (String)"BrewBillEdit_15", (String)"tdc-cadm-formplugin", (Object[])new Object[]{name}));
        this.setControlVal("posdutylab", ResManager.loadKDString((String)"{0}\u804c\u8d23", (String)"BrewBillEdit_16", (String)"tdc-cadm-formplugin", (Object[])new Object[]{name}));
        this.setControlVal("standardlab", ResManager.loadKDString((String)"{0}\u8861\u91cf\u6807\u51c6", (String)"BrewBillEdit_18", (String)"tdc-cadm-formplugin", (Object[])new Object[]{name}));
    }

    private void setMust(String positionType) {
        BasedataEdit brewstandardposition = (BasedataEdit)this.getControl("brewstandardposition");
        brewstandardposition.setMustInput(PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType));
        BasedataEdit brewposition = (BasedataEdit)this.getControl("brewposition");
        brewposition.setMustInput(PositionTypeEnum.POSITION.getNumber().equals(positionType));
        BasedataEdit brewjob = (BasedataEdit)this.getControl("brewjob");
        brewjob.setMustInput(PositionTypeEnum.JOB.getNumber().equals(positionType));
    }

    private void setControlVal(String key, String val) {
        Control control = this.getView().getControl(key);
        if (!HRObjectUtils.isEmpty((Object)control)) {
            if (HRStringUtils.isNotEmpty((String)val)) {
                if (control instanceof Label) {
                    Label label = (Label)control;
                    label.setText(val);
                }
                if (control instanceof TabPage) {
                    TabPage tabPage = (TabPage)control;
                    tabPage.setText(new LocaleString(val));
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
            }
        }
    }

    private void setRequireValue(DynamicObject brewObject) {
        String diplomareqname = brewObject.getString("diplomareq.name");
        this.getModel().setValue("diplomareqname", (Object)diplomareqname);
        String agereq = brewObject.getString("agereq");
        this.getModel().setValue("agereq", (Object)agereq);
        String knowledgereq = brewObject.getString("knowledgereq");
        this.getModel().setValue("knowledgereq", (Object)knowledgereq);
        String skillreq = brewObject.getString("skillreq");
        this.getModel().setValue("skillreq", (Object)skillreq);
        String abilityreq = brewObject.getString("abilityreq");
        this.getModel().setValue("abilityreq", (Object)abilityreq);
        String experiencereq = brewObject.getString("experiencereq");
        this.getModel().setValue("experiencereq", (Object)experiencereq);
    }

    private void setAdminorgAndCompany() {
        DynamicObject brewObject = this.getBrewObject();
        if (brewObject == null) {
            return;
        }
        String positionType = this.getModel().getValue("positiontype").toString();
        DynamicObject orgValue = null;
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) || PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            orgValue = brewObject.getDynamicObject("createorg");
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            orgValue = brewObject.getDynamicObject("adminorg");
        }
        this.getModel().setValue("adminorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)orgValue));
        DynamicObject adminorg = (DynamicObject)this.getModel().getValue("adminorg");
        if (adminorg != null) {
            DynamicObject company = adminorg.getDynamicObject("company");
            this.getModel().setValue("company", (Object)HRDyObjectPropUtil.getId((DynamicObject)company));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("candidateentry");
        int posNumber = Integer.parseInt((String)this.getModel().getValue("candcardposnum", currentRowIndex));
        if (posNumber == 0) {
            return;
        }
        DynamicObject candidatePerson = (DynamicObject)this.getModel().getValue("candcardperson", currentRowIndex);
        Long personId = HRDyObjectPropUtil.getId((DynamicObject)candidatePerson);
        this.showCandidatePositionInfoView(personId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.equals("brewposition") || name.equals("brewstandardposition") || name.equals("brewjob")) {
            if (this.checkOrgIsEmpty()) {
                beforeF7SelectEvent.setCancel(true);
            }
            String positionType = this.getModel().getValue("positiontype").toString();
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("jobseq.standardjobseq.id", "=", (Object)1010L));
            } else {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("positiontype.ismanagetype", "=", (Object)"1"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("cadm_inputconclusion") && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.updateCandidateEntryByInput(returnData);
        }
        if (HRStringUtils.equals((String)actionId, (String)"revocation") && closedCallBackEvent.getReturnData() instanceof String) {
            String revokeReason = (String)closedCallBackEvent.getReturnData();
            OperateOption option = OperateOption.create();
            option.setVariableValue("withdrawreason", revokeReason);
            this.getView().invokeOperation("revocation", option);
            return;
        }
        if (HRStringUtils.equals((String)actionId, (String)"cadm_brewmatchdetail") && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.updateCandidateMatchData(returnData);
        }
    }

    private void updateCandidateMatchData(Object returnData) {
        String matchDataBase64String = (String)returnData;
        Map currentRowMatchData = (Map)SerializationUtils.deSerializeFromBase64((String)matchDataBase64String);
        if (CollectionUtils.isEmpty((Map)currentRowMatchData)) {
            return;
        }
        String allMatchDataBase64String = this.getPageCache().get(CACHE_BREWMATCHDETAIL);
        if (HRStringUtils.isEmpty((String)allMatchDataBase64String)) {
            this.getPageCache().put(CACHE_BREWMATCHDETAIL, matchDataBase64String);
        } else {
            Map allMatchData = (Map)SerializationUtils.deSerializeFromBase64((String)matchDataBase64String);
            allMatchData.putAll(currentRowMatchData);
            this.getPageCache().put(CACHE_BREWMATCHDETAIL, SerializationUtils.serializeToBase64((Object)allMatchData));
        }
        Map<String, String> propertyMapping = candidateFormService.getCardMatchFieldMapping();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("candidateentry");
        DynamicObject employee = (DynamicObject)this.getModel().getValue("candcardemployee", currentRowIndex);
        List matchDataList = (List)currentRowMatchData.get(HRDyObjectPropUtil.getId((DynamicObject)employee));
        for (BrewMatchBo matchData : matchDataList) {
            String matchResult = matchData.getMatchResult();
            this.getModel().setValue(propertyMapping.get(matchData.getMatchItemNumber()), (Object)matchResult, currentRowIndex);
        }
        this.getView().updateView("candidateentry");
        this.setCandidateCardVisible();
    }

    private Map<String, String> getMatchItemPropertyMapping() {
        HashMap<String, String> propertyMapping = new HashMap<String, String>(16);
        propertyMapping.put(BrewPersonPositionMatchEnum.DIPLOMA.getNumber(), "diplomareq.name");
        propertyMapping.put(BrewPersonPositionMatchEnum.AGE.getNumber(), "agereq");
        propertyMapping.put(BrewPersonPositionMatchEnum.KNOWLEDGE.getNumber(), "knowledgereq");
        propertyMapping.put(BrewPersonPositionMatchEnum.SKILL.getNumber(), "skillreq");
        propertyMapping.put(BrewPersonPositionMatchEnum.ABILITY.getNumber(), "abilityreq");
        propertyMapping.put(BrewPersonPositionMatchEnum.EXPERIENCE.getNumber(), "experiencereq");
        return propertyMapping;
    }

    private List<BrewMatchBo> getMatchDetailData(int currentRowIndex) {
        DynamicObject person = (DynamicObject)this.getModel().getValue("candcardperson", currentRowIndex);
        DynamicObject employee = (DynamicObject)this.getModel().getValue("candcardemployee", currentRowIndex);
        DynamicObject candBrew = new DynamicObject();
        String positionType = this.getModel().getValue("positiontype").toString();
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            candBrew = (DynamicObject)this.getModel().getValue("candcardstdposition", currentRowIndex);
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            candBrew = (DynamicObject)this.getModel().getValue("candcardposition", currentRowIndex);
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            candBrew = (DynamicObject)this.getModel().getValue("candcardjob", currentRowIndex);
        }
        DynamicObject brewObject = this.getBrewObject();
        Long billId = (Long)this.getModel().getValue("id");
        BrewPersonPositionMatchEnum[] matchEnums = BrewPersonPositionMatchEnum.values();
        Map<String, String> matchFieldMapping = candidateFormService.getCardMatchFieldMapping();
        Map<String, String> propertyMapping = this.getMatchItemPropertyMapping();
        Map<String, String> personInfo = this.getPersonInfo(HRDyObjectPropUtil.getId((DynamicObject)person));
        ArrayList<BrewMatchBo> brewMatchBoList = new ArrayList<BrewMatchBo>(matchEnums.length);
        for (BrewPersonPositionMatchEnum matchEnum : matchEnums) {
            BrewMatchBo brewMatchBo = new BrewMatchBo();
            String matchItemNumber = matchEnum.getNumber();
            String itemMatchResult = (String)this.getModel().getValue(matchFieldMapping.get(matchItemNumber), currentRowIndex);
            brewMatchBo.setMatchItemNumber(matchItemNumber);
            brewMatchBo.setMatchResult(itemMatchResult);
            brewMatchBo.setBrewBillId(billId);
            brewMatchBo.setPositionType(positionType);
            brewMatchBo.setPersonPositionId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)candBrew)));
            brewMatchBo.setMatchPositionId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)brewObject)));
            brewMatchBo.setCandEmployeeId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)employee)));
            brewMatchBo.setPersonInfo((ILocaleString)new LocaleString(personInfo.get(matchItemNumber)));
            if (brewObject != null && !PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                brewMatchBo.setPositionReq(brewObject.getLocaleString(propertyMapping.get(matchItemNumber)));
            }
            brewMatchBoList.add(brewMatchBo);
        }
        return brewMatchBoList;
    }

    private void updateCandidateEntryByInput(Object returnData) {
        String entryBase64String = (String)returnData;
        DynamicObjectCollection entryObjs = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)entryBase64String);
        Map<Long, DynamicObject> entryDataMap = entryObjs.stream().collect(Collectors.toMap(entryRow -> HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("candcardperson")), entryRow -> entryRow, (v1, v2) -> v2));
        int size = this.getModel().getEntryEntity("candidateentry").size();
        for (int row = 0; row < size; ++row) {
            DynamicObject person = (DynamicObject)this.getModel().getValue("candcardperson", row);
            DynamicObject inputData = entryDataMap.get(HRDyObjectPropUtil.getId((DynamicObject)person));
            if (inputData == null) continue;
            this.getModel().setValue("isbrewpass", (Object)inputData.getString("isbrewpass"), row);
            this.getModel().setValue("candbrewcomment", (Object)inputData.getString("candbrewcomment"), row);
            this.getModel().setValue("nominatehandler", (Object)HRDyObjectPropUtil.getId((DynamicObject)inputData.getDynamicObject("nominatehandler")), row);
        }
        this.getModel().updateCache();
        candidateFormService.calculateCandidateEntryData((AbstractFormPlugin)this);
    }

    private void showQuickInputConclusion() {
        DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_inputconclusion");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165\u915d\u917f\u7ed3\u8bba", (String)"BrewBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("candidatedata", (Object)SerializationUtils.serializeToBase64((Object)candidateEntry));
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cadm_inputconclusion"));
        this.getView().showForm(formShowParameter);
    }

    private DynamicObject getBrewObject() {
        String positionType;
        DynamicObject brewObject = null;
        String string = positionType = this.getModel().getValue("positiontype") == null ? "" : this.getModel().getValue("positiontype").toString();
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            brewObject = this.getModel().getDataEntity().getDynamicObject("brewstandardposition");
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            brewObject = this.getModel().getDataEntity().getDynamicObject("brewposition");
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            brewObject = this.getModel().getDataEntity().getDynamicObject("brewjob");
        }
        return brewObject;
    }

    private void showCandidateComp() {
        HashMap<String, Object> candidateCompMap = new HashMap<String, Object>(16);
        DynamicObject brewObject = this.getBrewObject();
        candidateCompMap.put("brewObject", brewObject);
        candidateCompMap.put("positiontype", this.getModel().getValue("positiontype").toString());
        DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
        if (candidateEntry.size() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u6bd4\u4eba\u6570\u6dfb\u52a0\u8d85\u8fc7{0}\u4eba\u65f6\uff0c\u9ed8\u8ba4\u9009\u62e9\u524d{0}\u4f4d\u3002", (String)"BrewBillCandidateFormService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{50}));
            List subList = candidateEntry.subList(0, 50);
            candidateEntry = new DynamicObjectCollection();
            candidateEntry.addAll((Collection)subList);
        }
        List<Object> personList = new ArrayList();
        List<Object> employList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)candidateEntry)) {
            personList = candidateEntry.stream().filter(p -> p.getDynamicObject("candcardperson") != null).map(dynamicObject -> dynamicObject.getDynamicObject("candcardperson").getLong("id")).collect(Collectors.toList());
            employList = candidateEntry.stream().filter(p -> p.getDynamicObject("candcardemployee") != null).map(dynamicObject -> dynamicObject.getDynamicObject("candcardemployee").getLong("id")).collect(Collectors.toList());
        }
        candidateCompMap.put("person", personList);
        candidateCompMap.put("employee", employList);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_brewcandidatecomp");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5bf9\u6bd4", (String)"BrewBillEdit_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("candidateCompareData", (Object)SerializationUtils.serializeToBase64(candidateCompMap));
        formShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(formShowParameter);
    }

    private void setEntryBrewConclusion(String operateKey) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("candidateentry");
        String oldConclusion = (String)this.getModel().getValue("isbrewpass", currentRowIndex);
        if (operateKey.equals(OP_BREWPASS) && !HRStringUtils.equals((String)oldConclusion, (String)"1")) {
            this.getModel().setValue("isbrewpass", (Object)"1");
        } else if (operateKey.equals(OP_BREWNOPASS) && !HRStringUtils.equals((String)oldConclusion, (String)"0")) {
            this.getModel().setValue("isbrewpass", (Object)"0");
        }
        this.getModel().updateCache();
    }

    private Map<String, String> getPersonInfo(long personId) {
        HashMap<String, String> personInfo = new HashMap<String, String>(16);
        String education = ExternalDataService.getHighestEdu((long)personId);
        personInfo.put(BrewPersonPositionMatchEnum.DIPLOMA.getNumber(), education);
        Map personBaseInfo = ExternalDataService.getPersonBaseInfo((Long)personId);
        Object age = personBaseInfo.get("age");
        if (age != null) {
            personInfo.put(BrewPersonPositionMatchEnum.AGE.getNumber(), age.toString());
        }
        return personInfo;
    }

    private void setCandidateCardVisible() {
        CardEntry cardEntry = (CardEntry)this.getControl("candidateentry");
        DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
        for (int i = 0; i < candidateEntry.size(); ++i) {
            String jobLevelInfo;
            String entServiceLenValue;
            String serviceLenValue;
            String managePositionNum;
            String positionNum;
            String ageValue = ((DynamicObject)candidateEntry.get(i)).getString("candcardage");
            if (HRStringUtils.isEmpty((String)ageValue) || HRStringUtils.equals((String)ageValue, (String)"0")) {
                cardEntry.setChildVisible(false, i, new String[]{CARDFLEX_AGE});
            }
            if (HRStringUtils.isEmpty((String)(positionNum = ((DynamicObject)candidateEntry.get(i)).getString("candcardposnum"))) || HRStringUtils.equals((String)positionNum, (String)"0")) {
                cardEntry.setChildVisible(false, i, new String[]{CARDFLEX_CARDPOS});
            }
            if (HRStringUtils.isEmpty((String)(managePositionNum = ((DynamicObject)candidateEntry.get(i)).getString("candcardmanageposnum"))) || HRStringUtils.equals((String)managePositionNum, (String)"0")) {
                cardEntry.setChildVisible(false, i, new String[]{CARDFLEX_CARDMANAGEPOS});
            }
            if (HRStringUtils.isEmpty((String)(serviceLenValue = ((DynamicObject)candidateEntry.get(i)).getString("candcardservicelen"))) || HRStringUtils.equals((String)serviceLenValue, (String)"0")) {
                cardEntry.setChildVisible(false, i, new String[]{CARDFLEX_SERVICELEN});
            }
            if (HRStringUtils.isEmpty((String)(entServiceLenValue = ((DynamicObject)candidateEntry.get(i)).getString("candcardentservicelen"))) || HRStringUtils.equals((String)entServiceLenValue, (String)"0")) {
                cardEntry.setChildVisible(false, i, new String[]{CARDFLEX_ENTSERVICELEN});
            }
            if (!HRStringUtils.isEmpty((String)(jobLevelInfo = ((DynamicObject)candidateEntry.get(i)).getString("candcardjoblevel"))) && !HRStringUtils.equals((String)jobLevelInfo, (String)"-")) continue;
            cardEntry.setChildVisible(false, i, new String[]{CARDFLEX_JOBLEVEL});
        }
    }

    private void setViewVisible(boolean isNew) {
        DynamicObject brewPosition = this.getBrewObject();
        if (brewPosition == null) {
            this.showBillBlankView();
            if (isNew) {
                return;
            }
        }
        this.showBillContentView();
        this.setCandidateViewVisible();
    }

    private void setCandidateViewVisible() {
        DynamicObjectCollection candidateEntry = this.getModel().getEntryEntity("candidateentry");
        if (CollectionUtils.isEmpty((Collection)candidateEntry)) {
            this.showCandidateBlankView();
            return;
        }
        this.showCandidateContentView();
    }

    private void showBillBlankView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_BILL_CONTENT});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_BILL_BLANK});
    }

    private void showBillContentView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_BILL_CONTENT});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_BILL_BLANK});
    }

    private void showCandidateBlankView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CANDIDATE_BLANK});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CANDIDATE_INFO, "flexstatistics"});
    }

    private void showCandidateContentView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CANDIDATE_INFO, "flexstatistics"});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CANDIDATE_BLANK});
    }

    private void showCandidatePositionInfoView(Long personId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_candidateposition");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("candidatepersonid", (Object)String.valueOf(personId));
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5168\u90e8\u73b0\u5c97\u4fe1\u606f", (String)"BrewBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean checkOrgIsEmpty() {
        Object orgDy = this.getModel().getValue("org");
        if (orgDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u3002", (String)"BrewBillEdit_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void showRevocationForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_unsubmitbrew");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "revocation"));
        this.getView().showForm(formShowParameter);
    }

    private void showMatchDetailForm() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("candidateentry");
        DynamicObject employee = (DynamicObject)this.getModel().getValue("candcardemployee", currentRowIndex);
        DynamicObject candPosition = (DynamicObject)this.getModel().getValue("candcardposition", currentRowIndex);
        DynamicObject candStdPosition = (DynamicObject)this.getModel().getValue("candcardstdposition", currentRowIndex);
        DynamicObject candJob = (DynamicObject)this.getModel().getValue("candcardjob", currentRowIndex);
        long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)this.getModel().getValue("candcardadminorg", currentRowIndex)));
        String candPositionType = (String)this.getModel().getValue("candcardpositiontype", currentRowIndex);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("candcardpositiontype", candPositionType);
        customParams.put("candcardadminorg", adminOrgId);
        customParams.put("candcardemployee", String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)employee)));
        customParams.put("candcardposition", String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)candPosition)));
        customParams.put("candcardstdposition", String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)candStdPosition)));
        customParams.put("candcardjob", String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)candJob)));
        String positionType = this.getModel().getValue("positiontype").toString();
        customParams.put("positiontype", positionType);
        DynamicObject brewObject = this.getBrewObject();
        customParams.put("brewObject", String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)brewObject)));
        List<BrewMatchBo> matchDetailData = this.getMatchDetailData(currentRowIndex);
        customParams.put("matchdata", SerializationUtils.serializeToBase64(matchDetailData));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_brewmatchdetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cadm_brewmatchdetail"));
        formShowParameter.setCustomParams(customParams);
        String billStatus = (String)this.getModel().getValue("billstatus");
        OperationStatus status = billStatus.equals("A") || billStatus.equals("G") ? OperationStatus.EDIT : OperationStatus.VIEW;
        status = this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW ? OperationStatus.VIEW : status;
        formShowParameter.setStatus(status);
        this.getView().showForm(formShowParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setPropertyNotDataChanged();
    }

    private void setPropertyNotDataChanged() {
        DataEntityPropertyCollection billProperties = this.getModel().getDataEntityType().getProperties();
        EntryProp candidateEntryProp = (EntryProp)billProperties.get((Object)"candidateentry");
        ArrayList allProperties = new ArrayList();
        allProperties.addAll(billProperties);
        allProperties.addAll(candidateEntryProp.getDynamicCollectionItemPropertyType().getProperties());
        List<String> allFieldKeys = allProperties.stream().map(IMetadata::getName).collect(Collectors.toList());
        List<String> canShowDataChangeFieldKey = this.getCanDataChangedFieldKey();
        allFieldKeys.removeAll(canShowDataChangeFieldKey);
        cadmFormService.setPropertyNotDataChanged(this.getModel(), allFieldKeys.toArray(new String[0]));
    }

    private List<String> getCanDataChangedFieldKey() {
        ArrayList<String> canShowDataChangeFieldKey = new ArrayList<String>();
        canShowDataChangeFieldKey.add("brewposition");
        canShowDataChangeFieldKey.add("brewstandardposition");
        canShowDataChangeFieldKey.add("brewjob");
        canShowDataChangeFieldKey.add("brewdate");
        canShowDataChangeFieldKey.add("brewparticipant");
        canShowDataChangeFieldKey.add("brewfollowupper");
        canShowDataChangeFieldKey.add("brewdescription");
        canShowDataChangeFieldKey.add("candidateentry");
        canShowDataChangeFieldKey.add("isbrewpass");
        canShowDataChangeFieldKey.add("candbrewcomment");
        canShowDataChangeFieldKey.add("nominatehandler");
        return canShowDataChangeFieldKey;
    }
}

