/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.brew;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewCandidateCompPlugin
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(BrewCandidateCompPlugin.class);
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final String DES = "des";
    private static final String KEY = "key";
    private static final String KEY_PERSON_INFO = "personInfo";
    private static final String KEY_JOB_REQUIREMENT = "jobRequirement";
    private static final String KEY_IS_MATCH = "isMatch";
    private static final String INFORMATION = "infomation";
    private static final String REQUESTED = "requested";
    private static final String DES_SIGN = "desSign";
    private static final String AVATAR = "avatar";
    private static final String PARAM = "param";
    private static final String WORK_YEAR = "workYear";
    private static final String COMPANY_YEAR = "companyYear";
    private static final String AGE = "age";
    private static final String EDUCATION = "education";
    private static final String IS_N = "isN";
    private static final String ADD_CAND_F7 = "addcandf7";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("candidateCompareData");
        if (HRStringUtils.isEmpty((String)param)) {
            return;
        }
        Map compareMap = (Map)SerializationUtils.deSerializeFromBase64((String)param);
        if (CollectionUtils.isEmpty((Map)compareMap)) {
            return;
        }
        this.getView().getPageCache().put(PARAM, param);
        this.showCandidateInfo(compareMap);
    }

    private void showCandidateInfo(Map<String, Object> compareMap) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(3);
        paramsMap.put("jobName", this.getJobNameMap(compareMap));
        paramsMap.put("compareDimensions", this.getCompareDimensions(compareMap));
        paramsMap.put("candidateList", this.getCandidateList((List)compareMap.get("person")));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        LOG.info("showCandidateInfo send paramsMap:{}", paramsMap);
        proxy.setEntryProperty("customcontrolap", "data", paramsMap);
    }

    private Map<String, String> getJobNameMap(Map<String, Object> compareMap) {
        HashMap<String, String> jobNameMap = new HashMap<String, String>(2);
        if (CollectionUtils.isEmpty(compareMap)) {
            return jobNameMap;
        }
        String department = "";
        String title = "";
        DynamicObject brewObject = (DynamicObject)compareMap.get("brewObject");
        if (brewObject != null) {
            String positionType = compareMap.get("positiontype").toString();
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) || PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                department = brewObject.getString("createorg.name");
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                department = brewObject.getString("adminorg.name");
            }
            title = brewObject.getString("name");
        }
        jobNameMap.put("department", department);
        jobNameMap.put("title", title);
        return jobNameMap;
    }

    private List<Map<String, Object>> getCompareDimensions(Map<String, Object> compareMap) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(3);
        Map<String, Object> personMap = this.getCompareDimensionsPersonInfo();
        Map<String, Object> positionMap = this.getCompareDimensionsPositionInfo((DynamicObject)compareMap.get("brewObject"));
        Map<String, Object> matchMap = this.getCompareDimensionsMatch();
        list.add(personMap);
        list.add(positionMap);
        list.add(matchMap);
        return list;
    }

    private Map<String, Object> getCompareDimensionsPersonInfo() {
        HashMap<String, Object> personMap = new HashMap<String, Object>(2);
        personMap.put(DES, ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f", (String)"BrewCandidateCompPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        personMap.put(KEY, KEY_PERSON_INFO);
        ArrayList informationList = new ArrayList();
        HashMap<String, String> personAgeMap = new HashMap<String, String>(3);
        personAgeMap.put(DES, ResManager.loadKDString((String)"\u5de5\u9f84", (String)"BrewCandidateCompPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        personAgeMap.put(REQUESTED, "-");
        personAgeMap.put(DES_SIGN, WORK_YEAR);
        informationList.add(personAgeMap);
        HashMap<String, String> companyAgeMap = new HashMap<String, String>(3);
        companyAgeMap.put(DES, ResManager.loadKDString((String)"\u53f8\u9f84", (String)"BrewCandidateCompPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        companyAgeMap.put(REQUESTED, "-");
        companyAgeMap.put(DES_SIGN, COMPANY_YEAR);
        informationList.add(companyAgeMap);
        personMap.put(INFORMATION, informationList);
        return personMap;
    }

    private Map<String, Object> getCompareDimensionsPositionInfo(DynamicObject position) {
        HashMap<String, Object> positionMap = new HashMap<String, Object>(3);
        positionMap.put(DES, ResManager.loadKDString((String)"\u5c97\u4f4d\u8981\u6c42", (String)"BrewCandidateCompPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        positionMap.put(KEY, KEY_JOB_REQUIREMENT);
        ArrayList informationList = new ArrayList();
        HashMap<String, String> educationMap = new HashMap<String, String>(3);
        educationMap.put(DES, ResManager.loadKDString((String)"\u5b66\u5386", (String)"BrewCandidateCompPlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        DynamicObject eduDO = position != null && position.containsProperty("diplomareq") ? position.getDynamicObject("diplomareq") : null;
        educationMap.put(REQUESTED, eduDO == null ? "-" : eduDO.getString("name"));
        educationMap.put(DES_SIGN, EDUCATION);
        informationList.add(educationMap);
        HashMap<String, String> ageMap = new HashMap<String, String>(3);
        ageMap.put(DES, ResManager.loadKDString((String)"\u5e74\u9f84", (String)"BrewCandidateCompPlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ageMap.put(REQUESTED, position != null && position.containsProperty("agereq") ? position.getString("agereq") : "-");
        ageMap.put(DES_SIGN, AGE);
        informationList.add(ageMap);
        HashMap<String, String> expMap = new HashMap<String, String>(3);
        expMap.put(DES, ResManager.loadKDString((String)"\u76f8\u5173\u4ece\u4e1a\u7ecf\u9a8c", (String)"BrewCandidateCompPlugin_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        expMap.put(REQUESTED, position != null && position.containsProperty("experiencereq") ? position.getString("experiencereq") : "-");
        expMap.put(DES_SIGN, "experience");
        informationList.add(expMap);
        HashMap<String, String> performanceMap = new HashMap<String, String>(3);
        performanceMap.put(DES, ResManager.loadKDString((String)"\u8fd1\u4e09\u5e74\u7ee9\u6548", (String)"BrewCandidateCompPlugin_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        performanceMap.put(REQUESTED, "-");
        performanceMap.put(DES_SIGN, "performance");
        informationList.add(performanceMap);
        HashMap<String, String> quaMap = new HashMap<String, String>(3);
        quaMap.put(DES, ResManager.loadKDString((String)"\u4efb\u804c\u8d44\u683c", (String)"BrewCandidateCompPlugin_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        quaMap.put(REQUESTED, "-");
        quaMap.put(DES_SIGN, "qualification");
        informationList.add(quaMap);
        HashMap<String, String> knowledgeMap = new HashMap<String, String>(3);
        knowledgeMap.put(DES, ResManager.loadKDString((String)"\u77e5\u8bc6", (String)"BrewCandidateCompPlugin_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        knowledgeMap.put(REQUESTED, position != null && position.containsProperty("knowledgereq") ? position.getString("knowledgereq") : "-");
        knowledgeMap.put(DES_SIGN, "knowledge");
        informationList.add(knowledgeMap);
        HashMap<String, String> skillMap = new HashMap<String, String>(3);
        skillMap.put(DES, ResManager.loadKDString((String)"\u6280\u80fd", (String)"BrewCandidateCompPlugin_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        skillMap.put(REQUESTED, position != null && position.containsProperty("skillreq") ? position.getString("skillreq") : "-");
        skillMap.put(DES_SIGN, "skill");
        informationList.add(skillMap);
        positionMap.put(INFORMATION, informationList);
        return positionMap;
    }

    private Map<String, Object> getCompareDimensionsMatch() {
        HashMap<String, Object> personMap = new HashMap<String, Object>(3);
        personMap.put(DES, ResManager.loadKDString((String)"\u662f\u5426\u5339\u914d", (String)"BrewCandidateCompPlugin_11", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        personMap.put(KEY, KEY_IS_MATCH);
        ArrayList list = new ArrayList(3);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("3", ResManager.loadKDString((String)"\u4e0d\u7b26\u5408-\u5f3a\u6821\u9a8c", (String)"BrewCandidateCompPlugin_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("2", ResManager.loadKDString((String)"\u4e0d\u7b26\u5408-\u4e2d\u5ea6\u6821\u9a8c", (String)"BrewCandidateCompPlugin_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("1", ResManager.loadKDString((String)"\u7b26\u5408", (String)"BrewCandidateCompPlugin_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        list.add(map3);
        list.add(map2);
        list.add(map1);
        personMap.put(INFORMATION, list);
        return personMap;
    }

    private List<Map<String, Object>> getCandidateList(List<Long> personList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        if (CollectionUtils.isEmpty(personList)) {
            return list;
        }
        List personInfos = ExternalDataService.listPersonInfos(personList);
        for (Map perMap : personInfos) {
            HashMap<String, String> ageMap;
            Long personId = (Long)perMap.get("id");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", personId);
            if (CollectionUtils.isEmpty((Map)perMap)) {
                map.put(WORK_YEAR, "-");
                map.put(COMPANY_YEAR, "-");
                map.put("name", "-");
                map.put("Tnumber", "-");
                map.put(AVATAR, "-");
                map.put(AGE, this.createEmptyBusMap());
            } else {
                map.put(WORK_YEAR, perMap.get("servicelen"));
                map.put(COMPANY_YEAR, perMap.get("entservicelen"));
                map.put("name", perMap.get("name"));
                map.put("Tnumber", perMap.get("number"));
                Object headImageObject = perMap.get("headsculpture");
                if (!HRObjectUtils.isEmpty(headImageObject)) {
                    map.put(AVATAR, HRImageUrlUtil.getImageFullUrl((String)headImageObject.toString()));
                } else {
                    map.put(AVATAR, "-");
                }
                if (HRObjectUtils.isEmpty(perMap.get(AGE))) {
                    map.put(AGE, this.createEmptyBusMap());
                } else {
                    ageMap = new HashMap(2);
                    ageMap.put(DES, perMap.get(AGE).toString());
                    ageMap.put(IS_N, "0");
                    map.put(AGE, ageMap);
                }
            }
            String highestEdu = ExternalDataService.getHighestEdu((long)personId);
            if (HRStringUtils.isEmpty((String)highestEdu)) {
                map.put(EDUCATION, this.createEmptyBusMap());
            } else {
                ageMap = new HashMap<String, String>(2);
                ageMap.put(DES, highestEdu);
                ageMap.put(IS_N, "0");
                map.put(EDUCATION, ageMap);
            }
            map.put("experience", this.createEmptyBusMap());
            map.put("performance", this.createEmptyBusMap());
            map.put("knowledge", this.createEmptyBusMap());
            map.put("skill", this.createEmptyBusMap());
            map.put("qualification", this.getQualification(personId));
            list.add(map);
        }
        return list;
    }

    private Map<String, String> createEmptyBusMap() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(DES, "-");
        map.put(IS_N, "0");
        return map;
    }

    private Map<String, String> getQualification(long personId) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String qualificationString = brewBillApplicationService.getCerProService(personId);
        if (HRStringUtils.isEmpty((String)qualificationString)) {
            map.put(DES, "-");
        } else {
            map.put(DES, qualificationString);
        }
        map.put(IS_N, "0");
        return map;
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("addNewCandidate".equals(eventName)) {
            String param = this.getView().getPageCache().get(PARAM);
            if (HRStringUtils.isEmpty((String)param)) {
                return;
            }
            Map compareMap = (Map)SerializationUtils.deSerializeFromBase64((String)param);
            if (CollectionUtils.isEmpty((Map)compareMap)) {
                return;
            }
            this.showSelectCandidateF7((List)compareMap.get("employee"));
        }
        if ("delCurrentCandidate".equals(eventName)) {
            String number;
            String eventArgs = e.getEventArgs();
            Map map = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            String string = number = HRObjectUtils.isEmpty(map.get("Tnumber")) ? "" : map.get("Tnumber").toString();
            if (HRStringUtils.isEmpty((String)number)) {
                return;
            }
            DynamicObject employeeDy = brewBillApplicationService.getPersonBaseInfoByNumber(number);
            if (HRObjectUtils.isEmpty((Object)employeeDy)) {
                return;
            }
            long personId = employeeDy.getLong("person.id");
            long employeeId = employeeDy.getLong("id");
            String param = this.getView().getPageCache().get(PARAM);
            if (HRStringUtils.isEmpty((String)param)) {
                return;
            }
            Map compareMap = (Map)SerializationUtils.deSerializeFromBase64((String)param);
            if (CollectionUtils.isEmpty((Map)compareMap)) {
                return;
            }
            List personList = (List)compareMap.get("person");
            List employeeList = (List)compareMap.get("employee");
            personList.remove(personId);
            employeeList.remove(employeeId);
            compareMap.put("person", personList);
            compareMap.put("employee", employeeList);
            String compareMapDeSer = SerializationUtils.serializeToBase64((Object)compareMap);
            this.getView().getPageCache().put(PARAM, compareMapDeSer);
        }
    }

    private void showSelectCandidateF7(List<Long> employeeList) {
        this.getModel().beginInit();
        Object[] employeeIds = employeeList.toArray();
        this.getModel().setValue(ADD_CAND_F7, (Object)employeeIds);
        this.getModel().endInit();
        BasedataEdit addCandidateF7 = (BasedataEdit)this.getControl(ADD_CAND_F7);
        addCandidateF7.click();
        this.getPageCache().put("isaddcandidate", "1");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(ADD_CAND_F7)) {
            String param = this.getView().getPageCache().get(PARAM);
            if (HRStringUtils.isEmpty((String)param)) {
                return;
            }
            Map compareMap = (Map)SerializationUtils.deSerializeFromBase64((String)param);
            if (CollectionUtils.isEmpty((Map)compareMap)) {
                return;
            }
            MulBasedataDynamicObjectCollection employeeIdDOC = (MulBasedataDynamicObjectCollection)this.getModel().getValue(ADD_CAND_F7);
            if (employeeIdDOC.size() > 50) {
                List subList = employeeIdDOC.subList(0, 50);
                employeeIdDOC = new MulBasedataDynamicObjectCollection();
                employeeIdDOC.addAll((Collection)subList);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u6bd4\u4eba\u6570\u6dfb\u52a0\u8d85\u8fc7{0}\u4eba\u65f6\uff0c\u9ed8\u8ba4\u9009\u62e9\u524d{0}\u4f4d\u3002", (String)"BrewBillCandidateFormService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{50}));
            }
            List<Object> personList = new ArrayList();
            List<Object> employeeList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)employeeIdDOC)) {
                personList = employeeIdDOC.stream().map(dynamicObject -> ((DynamicObject)dynamicObject.get("fbasedataid")).getLong("person.id")).collect(Collectors.toList());
                employeeList = employeeIdDOC.stream().map(dynamicObject -> ((DynamicObject)dynamicObject.get("fbasedataid")).getLong("id")).collect(Collectors.toList());
            }
            compareMap.put("person", personList);
            compareMap.put("employee", employeeList);
            String compareMapDeSer = SerializationUtils.serializeToBase64((Object)compareMap);
            this.getView().getPageCache().put(PARAM, compareMapDeSer);
            this.showCandidateInfo(compareMap);
        }
    }
}

