/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.brew;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewPersonPositionMatchEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewMatchDetailPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_OK = "btnok";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initInfoFromParent();
        this.initMatchEntry();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_OK.equals(key)) {
            Map<Long, List<BrewMatchBo>> matchResult = this.getBrewMatchData();
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(matchResult));
            this.getView().close();
        }
    }

    private Map<Long, List<BrewMatchBo>> getBrewMatchData() {
        ArrayList<BrewMatchBo> brewMatchBoList = new ArrayList<BrewMatchBo>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long employeeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("employee"));
        Long brewPositionId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("brewposition"));
        DynamicObjectCollection matchEntry = this.getModel().getEntryEntity("matchentry");
        for (DynamicObject entry : matchEntry) {
            BrewMatchBo brewMatchBo = new BrewMatchBo();
            brewMatchBo.setMatchPositionId(brewPositionId);
            brewMatchBo.setMatchResult(entry.getString("matchresult"));
            brewMatchBo.setMatchItemNumber(entry.getString("itemkey"));
            brewMatchBoList.add(brewMatchBo);
        }
        HashMap<Long, List<BrewMatchBo>> matchResult = new HashMap<Long, List<BrewMatchBo>>(16);
        matchResult.put(employeeId, brewMatchBoList);
        return matchResult;
    }

    private void initMatchEntry() {
        String dataBase64String = (String)this.getView().getFormShowParameter().getCustomParam("matchdata");
        List matchData = (List)SerializationUtils.deSerializeFromBase64((String)dataBase64String);
        Map<String, BrewMatchBo> brewMatchBoMap = matchData.stream().collect(Collectors.toMap(BrewMatchBo::getMatchItemNumber, data -> data));
        BrewPersonPositionMatchEnum[] matchItems = BrewPersonPositionMatchEnum.values();
        this.getModel().deleteEntryData("matchentry");
        int[] newEntryRow = this.getModel().batchCreateNewEntryRow("matchentry", matchItems.length);
        for (int i = 0; i < newEntryRow.length; ++i) {
            String matchItemNumber = matchItems[i].getNumber();
            String matchItemName = matchItems[i].getName();
            BrewMatchBo brewMatchBo = brewMatchBoMap.get(matchItemNumber);
            this.getModel().setValue("itemkey", (Object)matchItemNumber, i);
            this.getModel().setValue("matchitem", (Object)matchItemName, i);
            this.getModel().setValue("personinfo", (Object)brewMatchBo.getPersonInfo().getLocaleValue(), i);
            this.getModel().setValue("positioninfo", (Object)brewMatchBo.getPositionReq(), i);
            String matchResult = brewMatchBo.getMatchResult();
            if (HRStringUtils.isEmpty((String)matchResult) || "30".equals(matchResult)) continue;
            this.getModel().setValue("matchresult", (Object)matchResult, i);
        }
    }

    private void initInfoFromParent() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String employeeId = (String)customParams.get("candcardemployee");
        String positionId = (String)customParams.get("candcardposition");
        String stdPositionId = (String)customParams.get("candcardstdposition");
        String jobId = (String)customParams.get("candcardjob");
        String positionType = (String)customParams.get("positiontype");
        String candPositionType = (String)customParams.get("candcardpositiontype");
        Object adminOrgId = customParams.get("candcardadminorg");
        String brewPositionId = (String)customParams.get("brewObject");
        TextEdit positionInfoText = (TextEdit)this.getControl("positioninfo");
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            this.getModel().setValue("brewstandardposition", (Object)Long.valueOf(brewPositionId));
            positionInfoText.setCaption(new LocaleString(ResManager.loadKDString((String)"\u915d\u917f\u6807\u51c6\u5c97\u4f4d\u8981\u6c42", (String)"BrewMatchDetailPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            this.getModel().setValue("brewposition", (Object)Long.valueOf(brewPositionId));
            positionInfoText.setCaption(new LocaleString(ResManager.loadKDString((String)"\u915d\u917f\u5c97\u4f4d\u8981\u6c42", (String)"BrewMatchDetailPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            this.getModel().setValue("brewjob", (Object)Long.valueOf(brewPositionId));
            positionInfoText.setCaption(new LocaleString(ResManager.loadKDString((String)"\u915d\u917f\u804c\u4f4d\u8981\u6c42", (String)"BrewMatchDetailPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        this.getModel().setValue("employee", (Object)Long.valueOf(employeeId));
        this.getModel().setValue("personposition", (Object)(positionId == null ? 0L : Long.parseLong(positionId)));
        this.getModel().setValue("personstdposition", (Object)(stdPositionId == null ? 0L : Long.parseLong(stdPositionId)));
        this.getModel().setValue("personjob", (Object)(jobId == null ? 0L : Long.parseLong(jobId)));
        this.getModel().setValue("positiontype", (Object)positionType);
        this.getModel().setValue("candcardpositiontype", (Object)candPositionType);
        this.getModel().setValue("candcardadminorg", adminOrgId);
        DynamicObject employee = (DynamicObject)this.getModel().getValue("employee");
        Long personId = HRDyObjectPropUtil.getId((DynamicObject)employee.getDynamicObject("person"));
        this.getModel().setValue("person", (Object)personId);
    }
}

