/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.brew;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class CandidatePositionPlugin
extends HRDynamicFormBasePlugin {
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    public static final String ENTRY_ENTRYENTITY = "entryentity";
    public static final String ENTRYFIELD_ADMINORG = "adminorg";
    public static final String ENTRYFIELD_POSITION = "position";
    public static final String ENTRYFIELD_EMPPOSORGREL = "empposorgrel";
    public static final String ENTRYFIELD_SERVICELEN = "servicelen";
    public static final int YEAR_DAYS = 365;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long candidatePersonId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("candidatepersonid"));
        List<Map<String, Object>> personEmpposorgrels = this.queryEmpposorgrels(candidatePersonId);
        this.showEntryInfo(personEmpposorgrels);
    }

    private void showEntryInfo(List<Map<String, Object>> personEmpposorgrels) {
        this.getModel().deleteEntryData(ENTRY_ENTRYENTITY);
        int[] entryRow = this.getModel().batchCreateNewEntryRow(ENTRY_ENTRYENTITY, personEmpposorgrels.size());
        List positionIds = personEmpposorgrels.stream().map(p -> p.get("position_id")).collect(Collectors.toList());
        List stdPositionIds = personEmpposorgrels.stream().map(p -> p.get("stdposition_id")).collect(Collectors.toList());
        List jobIds = personEmpposorgrels.stream().map(p -> p.get("job_id")).collect(Collectors.toList());
        List managePositionIds = new ArrayList(10);
        List manageStdPositionIds = new ArrayList(10);
        List manageJobIds = new ArrayList(10);
        if (CollectionUtils.isNotEmpty(positionIds)) {
            managePositionIds = brewBillApplicationService.queryManagePosition(positionIds);
        }
        if (CollectionUtils.isNotEmpty(stdPositionIds)) {
            manageStdPositionIds = brewBillApplicationService.queryManageStandardPosition(stdPositionIds);
        }
        if (CollectionUtils.isNotEmpty(jobIds)) {
            manageJobIds = brewBillApplicationService.queryManageJob(jobIds);
        }
        for (int i = 0; i < entryRow.length; ++i) {
            Map<String, Object> empposorgrelObj = personEmpposorgrels.get(i);
            Long adminorgId = (Long)empposorgrelObj.get("adminorg_id");
            Long positionId = (Long)empposorgrelObj.get("position_id");
            Long empposorgrelId = (Long)empposorgrelObj.get("id");
            Integer serviceLength = (Integer)empposorgrelObj.get("servicelength");
            BigDecimal serviceLenYear = BigDecimal.ZERO;
            if (serviceLength != null) {
                serviceLenYear = BigDecimal.valueOf(serviceLength.intValue()).divide(BigDecimal.valueOf(365L), 1, RoundingMode.UP);
            }
            String positionType = empposorgrelObj.get("apositiontype") == null ? "" : empposorgrelObj.get("apositiontype").toString();
            Long jobId = (Long)empposorgrelObj.get("job_id");
            Long stdPositionId = (Long)empposorgrelObj.get("stdposition_id");
            this.getModel().setValue(ENTRYFIELD_ADMINORG, (Object)adminorgId, entryRow[i]);
            this.getModel().setValue(ENTRYFIELD_POSITION, (Object)positionId, entryRow[i]);
            this.getModel().setValue(ENTRYFIELD_EMPPOSORGREL, (Object)empposorgrelId, entryRow[i]);
            this.getModel().setValue(ENTRYFIELD_SERVICELEN, (Object)serviceLenYear.stripTrailingZeros(), entryRow[i]);
            this.getModel().setValue("positiontype", (Object)positionType, entryRow[i]);
            this.getModel().setValue("stdposition", (Object)stdPositionId, entryRow[i]);
            this.getModel().setValue("job", (Object)jobId, entryRow[i]);
            boolean isManage = false;
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                isManage = managePositionIds.contains(positionId);
            }
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                isManage = manageStdPositionIds.contains(stdPositionId);
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                isManage = manageJobIds.contains(jobId);
            }
            this.getModel().setValue("ismanage", (Object)isManage, entryRow[i]);
        }
    }

    private List<Map<String, Object>> queryEmpposorgrels(Long personId) {
        Map empposorgrels = brewBillApplicationService.queryEmpposorgrels(Collections.singletonList(personId));
        return (List)empposorgrels.get(personId);
    }
}

