/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.brew;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewPersonPositionMatchEnum;
import kd.tdc.cadm.bussiness.util.CastUtils;

public class PositionMatchPlugin
extends HRDynamicFormBasePlugin {
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final String CACHE_BREWMATCHDATA = "brewmatchdata";
    private static final String BTN_MATCHDETAIL = "matchdetail";
    private static final String ADMIN_ORG_ID = "adminorgId";
    private static final String PERSON_POSITION_TYPE = "personPositionType";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MATCHDETAIL});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String brewBillId = (String)this.getView().getFormShowParameter().getCustomParam("brewbillid");
        String employeeId = (String)this.getView().getFormShowParameter().getCustomParam("employeeid");
        String personId = (String)this.getView().getFormShowParameter().getCustomParam("personid");
        this.queryEmpposorgrels(Long.valueOf(personId));
        List<BrewMatchBo> brewMatchData = this.getBrewMatchData(brewBillId, employeeId);
        this.getPageCache().put(CACHE_BREWMATCHDATA, SerializationUtils.serializeToBase64(brewMatchData));
        this.initPositionMatchLabel(brewMatchData);
        if (CollectionUtils.isEmpty(brewMatchData)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_MATCHDETAIL});
        }
    }

    public void queryEmpposorgrels(Long personId) {
        Map personEmpposorgrelMap = brewBillApplicationService.queryEmpposorgrels(Collections.singletonList(personId));
        HashMap primaryEmpposorgrelMap = new HashMap(16);
        for (Map.Entry entry : personEmpposorgrelMap.entrySet()) {
            Optional<Map> optionalObject = ((List)entry.getValue()).stream().filter(objMap -> objMap.get("isprimary").equals(Boolean.TRUE)).findFirst();
            if (!optionalObject.isPresent()) continue;
            Map primaryEmpposorgrel = optionalObject.get();
            primaryEmpposorgrelMap.put(entry.getKey(), primaryEmpposorgrel);
        }
        HashMap primaryEmpposorgrelInfo = (HashMap)primaryEmpposorgrelMap.get(personId);
        if (primaryEmpposorgrelInfo == null) {
            primaryEmpposorgrelInfo = new HashMap(16);
        }
        Long adminorgId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("adminorg_id"), Long.class);
        String personPositionType = (String)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("apositiontype"), String.class);
        Long positionId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("position_id"), Long.class);
        Long jobId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("job_id"), Long.class);
        Long stdPositionId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("stdposition_id"), Long.class);
        this.getPageCache().put(ADMIN_ORG_ID, String.valueOf(adminorgId));
        this.getPageCache().put(PERSON_POSITION_TYPE, personPositionType);
        this.getPageCache().put("candcardposition", String.valueOf(positionId));
        this.getPageCache().put("candcardstdposition", String.valueOf(stdPositionId));
        this.getPageCache().put("candcardjob", String.valueOf(jobId));
    }

    private void initPositionMatchLabel(List<BrewMatchBo> brewMatchData) {
        for (BrewMatchBo brewMatchBo : brewMatchData) {
            String matchResult = brewMatchBo.getMatchResult();
            String matchItemNumber = brewMatchBo.getMatchItemNumber();
            Arrays.stream(BrewPersonPositionMatchEnum.values()).filter(matchEnum -> matchEnum.getNumber().equals(matchItemNumber)).findFirst().ifPresent(positionMatchEnum -> {
                switch (positionMatchEnum) {
                    case DIPLOMA: {
                        this.setMatchLabelVisible(matchResult, "diplomamatch1", "diplomamatch2", "diplomamatch3");
                        break;
                    }
                    case AGE: {
                        this.setMatchLabelVisible(matchResult, "agematch1", "agematch2", "agematch3");
                        break;
                    }
                    case KNOWLEDGE: {
                        this.setMatchLabelVisible(matchResult, "knowledgematch1", "knowledgematch2", "knowledgematch3");
                        break;
                    }
                    case SKILL: {
                        this.setMatchLabelVisible(matchResult, "skillmatch1", "skillmatch2", "skillmatch3");
                        break;
                    }
                    case ABILITY: {
                        this.setMatchLabelVisible(matchResult, "abilitymatch1", "abilitymatch2", "abilitymatch3");
                        break;
                    }
                    case EXPERIENCE: {
                        this.setMatchLabelVisible(matchResult, "expmatch1", "expmatch2", "expmatch3");
                        break;
                    }
                }
            });
        }
    }

    private void setMatchLabelVisible(String matchResult, String defaultLabel, String fitLabel, String unFitLabel) {
        if (matchResult.equals(BrewMatchBo.MatchCode.FIT.getMatchCode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{fitLabel});
            this.getView().setVisible(Boolean.FALSE, new String[]{unFitLabel, defaultLabel});
        } else if (matchResult.equals(BrewMatchBo.MatchCode.UNFIT.getMatchCode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{unFitLabel});
            this.getView().setVisible(Boolean.FALSE, new String[]{fitLabel, defaultLabel});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{defaultLabel});
            this.getView().setVisible(Boolean.FALSE, new String[]{fitLabel, unFitLabel});
        }
    }

    private List<BrewMatchBo> getBrewMatchData(String brewBillId, String employeeId) {
        DynamicObject[] brewMatchDys = brewBillApplicationService.queryBrewMatchResult(Long.valueOf(brewBillId), Long.valueOf(employeeId));
        List<BrewMatchBo> brewMatchBoList = Arrays.stream(brewMatchDys).map(matchResultDy -> {
            BrewMatchBo brewMatchBo = new BrewMatchBo();
            brewMatchBo.setBrewBillId(Long.valueOf(brewBillId));
            brewMatchBo.setCandEmployeeId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)matchResultDy.getDynamicObject("candemployee"))));
            brewMatchBo.setPersonPositionId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)matchResultDy.getDynamicObject("personposition"))));
            brewMatchBo.setMatchPositionId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)matchResultDy.getDynamicObject("matchposition"))));
            brewMatchBo.setMatchResult(matchResultDy.getString("matchresult"));
            brewMatchBo.setMatchItemNumber(matchResultDy.getString("matchitemnumber"));
            brewMatchBo.setPersonInfo(matchResultDy.getLocaleString("personinfo"));
            brewMatchBo.setPositionReq(matchResultDy.getLocaleString("positionreq"));
            brewMatchBo.setPositionType(matchResultDy.getString("positiontype"));
            return brewMatchBo;
        }).collect(Collectors.toList());
        return brewMatchBoList;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(BTN_MATCHDETAIL)) {
            this.showMatchDetailForm();
        }
    }

    private void showMatchDetailForm() {
        String positionType = (String)this.getView().getFormShowParameter().getCustomParam("positiontype");
        long positionId = (Long)this.getView().getFormShowParameter().getCustomParam("candcardposition");
        String matchDataBase64String = this.getPageCache().get(CACHE_BREWMATCHDATA);
        List brewMatchBoList = (List)SerializationUtils.deSerializeFromBase64((String)matchDataBase64String);
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("candcardemployee", String.valueOf(((BrewMatchBo)brewMatchBoList.get(0)).getCandEmployeeId()));
        customParams.put("candcardposition", String.valueOf(((BrewMatchBo)brewMatchBoList.get(0)).getPersonPositionId()));
        customParams.put("brewposition", String.valueOf(((BrewMatchBo)brewMatchBoList.get(0)).getMatchPositionId()));
        customParams.put("matchdata", SerializationUtils.serializeToBase64((Object)brewMatchBoList));
        customParams.put("positiontype", positionType);
        customParams.put("brewObject", String.valueOf(positionId));
        String adminorgId = this.getPageCache().get(ADMIN_ORG_ID);
        String personPositionType = this.getPageCache().get(PERSON_POSITION_TYPE);
        customParams.put("candcardadminorg", adminorgId);
        customParams.put("candcardpositiontype", personPositionType);
        customParams.put("candcardposition", this.getPageCache().get("candcardposition"));
        customParams.put("candcardstdposition", this.getPageCache().get("candcardstdposition"));
        customParams.put("candcardjob", this.getPageCache().get("candcardjob"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_brewmatchdetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(formShowParameter);
    }
}

