/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.common.enums.StatusTypeEnum;

public class HeadBillInfoEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(HeadBillInfoEdit.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String billTypeName = (String)customParams.get("billtypename");
        String billNo = (String)customParams.get("billno");
        String appointType = (String)customParams.get("appointtype");
        String orgName = (String)customParams.get("orgname");
        String statusName = (String)customParams.get("statusname");
        String statusType = (String)customParams.get("statustype");
        String handlerName = (String)customParams.get("handlername");
        String handlerNumber = (String)customParams.get("handlernumber");
        String handleTime = (String)customParams.get("handletime");
        Boolean isFastApply = (Boolean)customParams.get("isfastapply");
        this.getView().setVisible(isFastApply, new String[]{"fastapply"});
        if (HRStringUtils.isBlank((CharSequence)billTypeName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billtypename"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"billtypename"});
            this.getModel().setValue("billtypename", (Object)billTypeName);
        }
        if (HRStringUtils.isBlank((CharSequence)billNo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billno"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"billno"});
            this.getModel().setValue("billno", (Object)billNo);
        }
        if (HRStringUtils.isBlank((CharSequence)appointType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"appointtype"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"appointtype"});
            this.getModel().setValue("appointtype", (Object)appointType);
        }
        if (HRStringUtils.isBlank((CharSequence)orgName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"orgname"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"orgname"});
            this.getModel().setValue("orgname", (Object)orgName);
        }
        this.statusBtnControl(statusName, statusType);
        String handler = "";
        if (HRStringUtils.isNotEmpty((String)handlerName) || HRStringUtils.isNotEmpty((String)handlerNumber)) {
            handler = handlerName + " " + handlerNumber;
        }
        this.getModel().setValue("handler", (Object)(HRStringUtils.isEmpty((String)handler) ? "-" : handler));
        if (HRStringUtils.isEmpty((String)handleTime)) {
            this.getModel().setValue("handletime", (Object)"-");
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date handleTimeDate = sdf.parse(handleTime);
                String handleTimeStr = HRInteDateTimeUtil.formatDate((String)"cadm_reviewbill", (String)"revdealtime", (Date)handleTimeDate);
                this.getModel().setValue("handletime", (Object)handleTimeStr);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
    }

    private void statusBtnControl(String statusName, String statusType) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"underway", "completed", "invalid"});
        if (StatusTypeEnum.INVALID.name().equals(statusType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"invalid"});
        }
        if (StatusTypeEnum.UNDERWAY.name().equals(statusType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"underway"});
        }
        if (StatusTypeEnum.COMPLETED.name().equals(statusType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"completed"});
        }
        this.getModel().setValue("underway", (Object)statusName);
        this.getModel().setValue("completed", (Object)statusName);
        this.getModel().setValue("invalid", (Object)statusName);
    }
}

