/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.database;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.formservice.CadmConfigFormService;

public class AppointConfigPlugin
extends HRBaseDataCommonEdit
implements UploadListener {
    private static final CadmConfigFormService cadmConfigFormService = (CadmConfigFormService)ServiceFactory.getService(CadmConfigFormService.class);
    private static final String OP_SAVE = "save";
    private static final String FIELD_CONTENT_TAG = "content_tag";
    private static final String KEY_CONTENTEDITORAP = "richtext";
    private static final String OLD_KEY = "oldKey";

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (Objects.isNull(urls) || urls.length < 1) {
            return;
        }
        this.getModel().setValue("value", urls[0]);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String content = (String)this.getModel().getValue(FIELD_CONTENT_TAG);
        RichTextEditor contentEdit = (RichTextEditor)this.getView().getControl(KEY_CONTENTEDITORAP);
        contentEdit.setText(content);
        String oldKey = this.getModel().getDataEntity().getString("key");
        if (!HRStringUtils.isEmpty((String)oldKey)) {
            this.getPageCache().put(OLD_KEY, oldKey);
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventArgs = evt.getEventArgs();
        if (HRStringUtils.isNotEmpty((String)eventArgs)) {
            this.getModel().setValue(FIELD_CONTENT_TAG, (Object)eventArgs);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        RichTextEditor contentEdit;
        String content;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (OP_SAVE.equals(operateKey) && HRStringUtils.isNotEmpty((String)(content = (contentEdit = (RichTextEditor)this.getView().getControl(KEY_CONTENTEDITORAP)).getText()))) {
            this.getModel().setValue(FIELD_CONTENT_TAG, (Object)content);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oldKey;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_SAVE.equals(operateKey) && args.getOperationResult().isSuccess() && HRStringUtils.isNotEmpty((String)(oldKey = this.getPageCache().get(OLD_KEY)))) {
            String realKey = cadmConfigFormService.getRealKey(oldKey);
            cadmConfigFormService.removeCache(realKey);
        }
    }
}

