/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.database;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;

public class AuditSchemeEdit
extends HRDataBaseEdit
implements AfterF7SelectListener {
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit matchItems = (MulBasedataEdit)this.getControl("audititems");
        matchItems.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String action = (String)customParams.get("his_action");
        if (HRStringUtils.equals((String)action, (String)"open_insert_new_data_page")) {
            DynamicObjectCollection entryRows = this.getModel().getEntryEntity("audititementry");
            for (DynamicObject entryRow : entryRows) {
                entryRow.getDataEntityState().setBizChanged(true);
                entryRow.getDataEntityState().setDirty(true);
                entryRow.getDataEntityState().setPushChanged(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateAuditItems();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("donothing_addentry".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            MulBasedataEdit matchItems = (MulBasedataEdit)this.getControl("audititems");
            matchItems.click();
        }
        if ("deleteentry".equals(operateKey)) {
            this.updateAuditItems();
        }
    }

    private void updateAuditItems() {
        DynamicObjectCollection matchItemEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("audititementry");
        List<Object> list = matchItemEntry.stream().map(item -> item.getDynamicObject("audititem").getLong("id")).collect(Collectors.toList());
        if (list.size() > 0) {
            this.getModel().setValue("audititems", (Object)list.toArray(new Object[]{list.size()}));
        } else {
            this.getModel().setValue("audititems", null);
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("audititems".equals(key)) {
            this.updateEntry();
        }
    }

    private void updateEntry() {
        Map<Long, String> requireMap = this.getEntryRequireValue();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("audititementry");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("audititem", new Object[0]);
        setter.addField("require", new Object[0]);
        DynamicObjectCollection matchItems = this.getModel().getDataEntity().getDynamicObjectCollection("audititems");
        for (DynamicObject matchItem : matchItems) {
            DynamicObject dynamicObject = matchItem.getDynamicObject("fbasedataid");
            long id = dynamicObject.getLong("id");
            String require = requireMap.containsKey(id) ? requireMap.get(id) : dynamicObject.getString("require");
            setter.addRow(new Object[]{id, require});
        }
        model.batchCreateNewEntryRow("audititementry", setter);
        model.endInit();
        this.getView().updateView("audititementry");
    }

    private Map<Long, String> getEntryRequireValue() {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        DynamicObjectCollection auditItemEntry = this.getModel().getEntryEntity("audititementry");
        for (DynamicObject auditItem : auditItemEntry) {
            long id = auditItem.getLong("audititem.id");
            String require = auditItem.getString("require");
            map.put(id, require);
        }
        return map;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"audititems"});
    }
}

