/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.dismiss;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.DismissBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.common.enums.StatusTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchTerminateFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchUnSubmitFormService;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;

public class DismissBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final DismissBillApplicationService dismissBillApplicationService = (DismissBillApplicationService)ServiceFactory.getService(DismissBillApplicationService.class);
    private static final AppointBatchTerminateFormService terminateFormService = (AppointBatchTerminateFormService)ServiceFactory.getService(AppointBatchTerminateFormService.class);
    private static final AppointBatchUnSubmitFormService unSubmitFormService = (AppointBatchUnSubmitFormService)ServiceFactory.getService(AppointBatchUnSubmitFormService.class);
    private static final NominateCommonFormService nominateCommonFormService = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    private static final String FLEX_HEADFLEXVIEW = "headflexview";
    private static final String FLEX_DISMISSINFO = "flexdismissinfo";
    private static final String FLEX_BILLBLANK = "flexbillblank";
    private static final String FLEX_EDITINFO = "flexeditinfo";
    private static final String FLEX_PERSONINFOCARDVIEW = "personinfocardview";
    private static final String FLEX_PERSONINFOCARDEDIT = "personinfocardedit";
    private static final String LBL_QUICKDISMISS = "lblquickdismiss";
    private static final String LBL_APPOINTTYPENAME = "appointtypename";
    private static final String D_POSITION_VECTOR = "dpositionvectorap";
    private static final String BTN_SAVE = "bar_save";
    private static final String BTN_SUBMIT = "bar_submit";
    private static final String BTN_UNSUBMIT = "bar_unsubmit";
    private static final String BTN_TERMINATE = "bar_terminate";
    private static final String BTN_DEL = "bar_del";
    private static final String BTN_VIEWFLOWCHART = "bar_viewflowchart";
    private static final String FLEX_TERMINATERDATEFLEX = "terminaterdateflex";
    private static final String FLEX_TERMINATIONIDEA = "terminationideaflex";
    public static final String CACHE_PERSONINFOCARD = "personinfocardcache";
    public static final String CACHE_PERSONINFORECORD = "personinforecordcache";
    private static final String DISMISS_POSITION = "dismissposition";
    private static final String[] ALL_BTN_STR_ARR = new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_terminate", "bar_del", "bar_viewflowchart"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getFormShowParameter();
        String formPkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)formPkId)) {
            billShowParameter.setPkId((Object)formPkId);
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        String isQuickDismiss = (String)billShowParameter.getCustomParam("applytype");
        OperationStatus status = billShowParameter.getStatus();
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u514d\u804c\u7533\u8bf7", (String)"DismissBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            if (HRStringUtils.equals((String)isQuickDismiss, (String)"1")) {
                caption = ResManager.loadKDString((String)"\u65b0\u589e\u5feb\u901f\u514d\u804c", (String)"DismissBillEdit_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            }
        } else {
            Object pkIdObj = billShowParameter.getPkId();
            if (pkIdObj == null) {
                return;
            }
            Long pkId = 0L;
            if (pkIdObj instanceof String) {
                pkId = Long.parseLong(pkIdObj.toString());
            } else if (pkIdObj instanceof Long) {
                pkId = (Long)billShowParameter.getPkId();
            }
            DynamicObject dismissBill = dismissBillApplicationService.getDismissBillById("person", pkId.longValue());
            DynamicObject person = dismissBill.getDynamicObject("person");
            if (person != null) {
                String personName = person.getString("name");
                caption = HRStringUtils.equals((String)isQuickDismiss, (String)"1") ? ResManager.loadKDString((String)"\u5feb\u901f\u514d\u804c-{0}", (String)"DismissBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName}) : ResManager.loadKDString((String)"\u514d\u804c\u7533\u8bf7-{0}", (String)"DismissBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
            }
        }
        billShowParameter.setCaption(caption);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit appointType = (BasedataEdit)this.getControl("appointtype");
        appointType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Vector vector = (Vector)this.getControl(D_POSITION_VECTOR);
        vector.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if (propertyName.equals("appointtype")) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("group.id", "=", (Object)1472620455524432896L));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setIsQuickDismissBill();
        this.setAddNewBillStatus();
        TextEdit textEdit = (TextEdit)this.getControl(DISMISS_POSITION);
        textEdit.setMustInput(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewVisible();
        this.setBtnVisible();
        DynamicObject dTenure = (DynamicObject)this.getModel().getValue("dismisstenure");
        if (null != dTenure) {
            String positionType = dTenure.getString("apositiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                this.getModel().setValue(DISMISS_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)dTenure.getDynamicObject("position")));
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                this.getModel().setValue(DISMISS_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)dTenure.getDynamicObject("job")));
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                this.getModel().setValue(DISMISS_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)dTenure.getDynamicObject("standardpost")));
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (propertyName.equals("employee")) {
            this.employeeFieldChange(dataEntity);
        }
        if (propertyName.equals("appointstartdate")) {
            this.appointStartDateChange();
        }
        if (propertyName.equals("appointtype")) {
            this.setAppointTypeVisible();
        }
        if ("dismisstenure".equals(propertyName)) {
            DateEdit dateEdit = (DateEdit)this.getControl("appointenddate");
            nominateCommonFormService.setLeaveOrRemovalInfo(this.getView(), dateEdit, true);
            DynamicObject dismissTenureDynamic = (DynamicObject)this.getModel().getDataEntity().get("dismisstenure");
            if (null != dismissTenureDynamic) {
                DynamicObject depemp = dismissTenureDynamic.getDynamicObject("depemp");
                DynamicObject cmpemp = dismissTenureDynamic.getDynamicObject("cmpemp");
                this.getModel().setValue("depemp", (Object)HRDyObjectPropUtil.getId((DynamicObject)depemp));
                this.getModel().setValue("cmpemp", (Object)HRDyObjectPropUtil.getId((DynamicObject)cmpemp));
            }
        }
        if (DISMISS_POSITION.equals(propertyName)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("dismisstenure");
            this.getModel().setValue(DISMISS_POSITION, (Object)nominateCommonFormService.getTenurePositionName(dynamicObject));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (D_POSITION_VECTOR.equals(source.getKey())) {
            nominateCommonFormService.openEffectTenureWindowAfterClick(this.getView(), source.getKey(), (IFormPlugin)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            OperationStatus status;
            FormOperate operate = (FormOperate)source;
            String operateKey = operate.getOperateKey();
            if (operateKey.equals("save") && (status = this.getView().getFormShowParameter().getStatus()).equals((Object)OperationStatus.ADDNEW) && !this.checkSavePermission()) {
                String formId = this.getView().getFormShowParameter().getFormId();
                LocaleString formName = FormMetadataCache.getFormConfig((String)formId).getCaption();
                String errorMsg = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DismissBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[]{formName});
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
            }
            if (operateKey.equals("unsubmit")) {
                unSubmitFormService.callSingleBillValidatorBeforeDoOp(args, (AbstractFormPlugin)this);
            }
            if (operateKey.equals("terminate")) {
                terminateFormService.callSingleBillTerminateValidatorBeforeDoOp(args, (AbstractFormPlugin)this);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.refreshAfterOp(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("unsubmit") && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            unSubmitFormService.doOperationConfirmCallBack((AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("cadm_termination")) {
            terminateFormService.doTerminateAllCloseCallBack(returnData, (AbstractFormPlugin)this);
        } else if (D_POSITION_VECTOR.equals(actionId)) {
            nominateCommonFormService.effectTenureAfterSelectClose(this.getView(), closedCallBackEvent);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setPropertyNotShowChangeNotify();
    }

    private void employeeFieldChange(DynamicObject dataEntity) {
        this.getModel().setValue("dposition", null);
        DynamicObject employee = dataEntity.getDynamicObject("employee");
        if (employee != null) {
            DynamicObject person = employee.getDynamicObject("person");
            long personId = HRDyObjectPropUtil.getId((DynamicObject)person);
            long employeeId = HRDyObjectPropUtil.getId((DynamicObject)employee);
            Map primaryEmpposorgrel = ExternalDataService.queryPrimaryEmpposorgrelUnlimited((Long)employeeId);
            long depempId = primaryEmpposorgrel.get("depemp_id") == null ? 0L : (Long)primaryEmpposorgrel.get("depemp_id");
            long companyId = primaryEmpposorgrel.get("company_id") == null ? 0L : (Long)primaryEmpposorgrel.get("company_id");
            long adminorgId = primaryEmpposorgrel.get("adminorg_id") == null ? 0L : (Long)primaryEmpposorgrel.get("adminorg_id");
            long positionId = primaryEmpposorgrel.get("position_id") == null ? 0L : (Long)primaryEmpposorgrel.get("position_id");
            long jobId = primaryEmpposorgrel.get("job_id") == null ? 0L : (Long)primaryEmpposorgrel.get("job_id");
            long standardPositionId = primaryEmpposorgrel.get("stdposition_id") == null ? 0L : (Long)primaryEmpposorgrel.get("stdposition_id");
            this.getModel().setValue("person", (Object)(personId == 0L ? null : Long.valueOf(personId)));
            this.getModel().setValue("depemp", (Object)(depempId == 0L ? null : Long.valueOf(depempId)));
            this.getModel().setValue("bcompanyhis", (Object)(companyId == 0L ? null : Long.valueOf(companyId)));
            this.getModel().setValue("badminorghis", (Object)(adminorgId == 0L ? null : Long.valueOf(adminorgId)));
            this.getModel().setValue("bpositionhis", (Object)(positionId == 0L ? null : Long.valueOf(positionId)));
            this.getModel().setValue("bjobhis", (Object)(jobId == 0L ? null : Long.valueOf(jobId)));
            this.getModel().setValue("bstandardpositionhis", (Object)(standardPositionId == 0L ? null : Long.valueOf(standardPositionId)));
            this.getModel().setValue("dismisstenure", null);
            this.getModel().setValue("appointenddate", null);
        }
        this.getPageCache().remove(CACHE_PERSONINFOCARD);
        this.getPageCache().remove(CACHE_PERSONINFORECORD);
        this.setViewVisible();
    }

    private void appointStartDateChange() {
        Date startDate = (Date)this.getModel().getValue("appointstartdate");
        DateEdit endDateEdit = (DateEdit)this.getControl("appointenddate");
        endDateEdit.setMinDate(startDate);
        Date endDate = (Date)this.getModel().getValue("appointenddate");
        if (endDate != null && startDate != null && endDate.before(startDate)) {
            this.getModel().setValue("appointenddate", null);
        }
    }

    private void setAppointTypeVisible() {
        DynamicObject appointType = this.getModel().getDataEntity().getDynamicObject("appointtype");
        if (appointType == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_APPOINTTYPENAME});
        }
    }

    private boolean checkSavePermission() {
        String quickDismiss = this.getModel().getDataEntity().getString("applytype");
        String permItemId = HRStringUtils.equals((String)quickDismiss, (String)"1") ? "2KZS2EJDYE9=" : "2KZS13/GDPV4";
        String formId = this.getView().getFormShowParameter().getFormId();
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"cadm", (String)formId, (String)permItemId);
    }

    private void refreshAfterOp(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        ArrayList<String> needRefreshOp = new ArrayList<String>(10);
        needRefreshOp.add("save");
        needRefreshOp.add("submit");
        needRefreshOp.add("unsubmit");
        needRefreshOp.add("terminate");
        if (needRefreshOp.contains(operateKey) && eventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setPropertyNotShowChangeNotify() {
        ArrayList<String> propertyNameList = new ArrayList<String>(10);
        propertyNameList.add("applytype");
        propertyNameList.add("bcompanyhis");
        propertyNameList.add("badminorghis");
        propertyNameList.add("bpositionhis");
        propertyNameList.add("bjobhis");
        propertyNameList.add("depemp");
        propertyNameList.add("person");
        propertyNameList.add("cmpemp");
        propertyNameList.add("dadminorg");
        propertyNameList.add("dcompany");
        propertyNameList.add("appointstartdate");
        propertyNameList.add("appointstatus");
        propertyNameList.add("applykind");
        propertyNameList.add("billno");
        propertyNameList.add("billnocopy");
        propertyNameList.add("orgcopy");
        propertyNameList.add("creatorcopy");
        propertyNameList.add("createtimecopy");
        propertyNameList.add("createtimecopy");
        propertyNameList.add("createtimecopy");
        propertyNameList.add("createtimecopy");
        propertyNameList.add("underway");
        propertyNameList.add("completed");
        propertyNameList.add("invalid");
        cadmFormService.setPropertyNotDataChanged(this.getModel(), propertyNameList.toArray(new String[0]));
    }

    private void setIsQuickDismissBill() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String isQuickDismiss = (String)this.getView().getFormShowParameter().getCustomParam("applytype");
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            if (HRStringUtils.equals((String)isQuickDismiss, (String)"1")) {
                this.getModel().setValue("applytype", (Object)"1");
                this.getView().setVisible(Boolean.TRUE, new String[]{LBL_QUICKDISMISS});
            } else {
                this.getModel().setValue("applytype", (Object)"0");
                this.getView().setVisible(Boolean.FALSE, new String[]{LBL_QUICKDISMISS});
            }
        }
    }

    private void setAddNewBillStatus() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            this.getModel().setValue("nominatestatus", (Object)NominateStatusEnum.WAIT_NOMINATE.getVal());
            this.getModel().setValue("appointstatus", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
            this.getModel().setValue("applykind", (Object)ApplyKindEnum.DISMISS.getNumber());
        }
    }

    private void setBtnVisible() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            this.showBtn(BTN_SAVE, BTN_SUBMIT);
            return;
        }
        String appointStatus = this.getModel().getDataEntity().getString("appointstatus");
        String applyStatus = this.getModel().getDataEntity().getString("nominatestatus");
        if (appointStatus.equals(AppointStatusEnum.WAIT_APPOINT.getVal()) && applyStatus.equals(NominateStatusEnum.WAIT_NOMINATE.getVal())) {
            this.showBtn(BTN_SAVE, BTN_SUBMIT, BTN_DEL);
        }
        if (appointStatus.equals(AppointStatusEnum.WAIT_APPOINT.getVal()) && applyStatus.equals(NominateStatusEnum.RESUBMIT_NOMINATE.getVal())) {
            this.showBtn(BTN_SAVE, BTN_SUBMIT, BTN_TERMINATE, BTN_VIEWFLOWCHART);
        }
        if (appointStatus.equals(AppointStatusEnum.ING_APPOINT.getVal())) {
            this.showBtn(BTN_UNSUBMIT, BTN_TERMINATE, BTN_VIEWFLOWCHART);
        }
        if (appointStatus.equals(AppointStatusEnum.SUCCESS_APPOINT.getVal()) || appointStatus.equals(AppointStatusEnum.TERMINATE_APPOINT.getVal())) {
            this.showBtn(BTN_VIEWFLOWCHART);
        }
        if (status.equals((Object)OperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        }
    }

    private void showBtn(String ... btnKey) {
        ArrayList<String> showBtnList = new ArrayList<String>(Arrays.asList(btnKey));
        this.getView().setVisible(Boolean.TRUE, btnKey);
        ArrayList<String> allBtn = new ArrayList<String>(Arrays.asList(ALL_BTN_STR_ARR));
        allBtn.removeAll(showBtnList);
        this.getView().setVisible(Boolean.FALSE, allBtn.toArray(new String[0]));
    }

    private void setViewVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_TERMINATERDATEFLEX, FLEX_TERMINATIONIDEA});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject employee = dataEntity.getDynamicObject("employee");
        if (employee == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EDITINFO, FLEX_BILLBLANK});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PERSONINFOCARDEDIT, FLEX_HEADFLEXVIEW, FLEX_DISMISSINFO});
            return;
        }
        String appointStatus = dataEntity.getString("appointstatus");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if ((status.equals((Object)OperationStatus.EDIT) || status.equals((Object)OperationStatus.ADDNEW)) && appointStatus.equals(AppointStatusEnum.WAIT_APPOINT.getVal())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_EDITINFO, FLEX_PERSONINFOCARDEDIT, FLEX_DISMISSINFO});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_HEADFLEXVIEW, FLEX_BILLBLANK});
            this.showPerInfoCardFlex(dataEntity, FLEX_PERSONINFOCARDEDIT);
            this.appointStartDateChange();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{D_POSITION_VECTOR});
        }
        HashSet viewStatusValue = Sets.newHashSet((Object[])new String[]{AppointStatusEnum.ING_APPOINT.getVal(), AppointStatusEnum.SUCCESS_APPOINT.getVal(), AppointStatusEnum.TERMINATE_APPOINT.getVal()});
        if (status.equals((Object)OperationStatus.VIEW) || viewStatusValue.contains(appointStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_HEADFLEXVIEW, FLEX_DISMISSINFO});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_EDITINFO, FLEX_BILLBLANK});
            this.getModel().setValue("billnocopy", (Object)dataEntity.getString("billno"));
            this.getModel().setValue("orgcopy", (Object)HRDyObjectPropUtil.getName((DynamicObject)dataEntity.getDynamicObject("org")));
            String creatorName = HRDyObjectPropUtil.getName((DynamicObject)dataEntity.getDynamicObject("creator"));
            String creatorNumber = HRDyObjectPropUtil.getString((DynamicObject)dataEntity.getDynamicObject("creator"), (String)"number");
            this.getModel().setValue("creatorcopy", (Object)(creatorName + " " + creatorNumber));
            this.getModel().setValue("createtimecopy", (Object)dataEntity.getDate("createtime"));
            this.showPerInfoCardFlex(dataEntity, FLEX_PERSONINFOCARDVIEW);
            this.appointStatusBtnControl();
            String isQuickDismiss = dataEntity.getString("applytype");
            if (HRStringUtils.equals((String)isQuickDismiss, (String)"1")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{LBL_QUICKDISMISS});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{LBL_QUICKDISMISS});
            }
            if (appointStatus.equals(AppointStatusEnum.TERMINATE_APPOINT.getVal())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_TERMINATERDATEFLEX, FLEX_TERMINATIONIDEA});
            }
            this.setAppointTypeVisible();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{D_POSITION_VECTOR});
        }
    }

    private void appointStatusBtnControl() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"underway", "completed", "invalid"});
        String appointStatus = this.getModel().getDataEntity().getString("appointstatus");
        if (HRStringUtils.isNotEmpty((String)appointStatus)) {
            AppointStatusEnum appointStatusEnum = AppointStatusEnum.getEnumByVal((String)appointStatus);
            String statusType = appointStatusEnum.getStatusType().name();
            String statusName = appointStatusEnum.getName();
            if (StatusTypeEnum.INVALID.name().equals(statusType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"invalid"});
            }
            if (StatusTypeEnum.UNDERWAY.name().equals(statusType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"underway"});
            }
            if (StatusTypeEnum.COMPLETED.name().equals(statusType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"completed"});
            }
            this.getModel().setValue("underway", (Object)statusName);
            this.getModel().setValue("completed", (Object)statusName);
            this.getModel().setValue("invalid", (Object)statusName);
        }
    }

    private void showPerInfoCardFlex(DynamicObject dataEntity, String targetKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_appointbaseinfo");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("depEmpId", (Object)dataEntity.getString("depemp.id"));
        showParameter.setCustomParam("personId", (Object)dataEntity.getString("person.id"));
        showParameter.setCustomParam("employee", (Object)dataEntity.getString("employee.id"));
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm(showParameter);
    }
}

