/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.dismiss;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.DismissBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchDeleteFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchTerminateFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchUnSubmitFormService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.cadm.formplugin.web.formservice.appointedit.AppointEditorUtil;

public class DismissBillList
extends HRCoreBaseList {
    private static final DismissBillApplicationService dismissBillApplicationService = (DismissBillApplicationService)ServiceFactory.getService(DismissBillApplicationService.class);
    private static final AppointBatchDeleteFormService deleteFormService = (AppointBatchDeleteFormService)ServiceFactory.getService(AppointBatchDeleteFormService.class);
    private static final AppointBatchTerminateFormService terminateFormService = (AppointBatchTerminateFormService)ServiceFactory.getService(AppointBatchTerminateFormService.class);
    private static final AppointBatchUnSubmitFormService unSubmitFormService = (AppointBatchUnSubmitFormService)ServiceFactory.getService(AppointBatchUnSubmitFormService.class);
    private static final NominateCommonFormService nominateCommonFormService = FormServiceFactory.getService(NominateCommonFormService.class);
    private static final String LIST_FIELD_PERSONNUMBER = "person.number";
    private static final String EXPORT_APPOINT = "exportappoint";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object dataSource = customParams.get("dataSource");
        List fastFilterColumns = args.getFastFilterColumns();
        if ("departMsg".equals(dataSource) || "withdrawDepartMsg".equals(dataSource)) {
            Object personNumber = customParams.get("personNumber");
            Object personName = customParams.get("personName");
            fastFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if (LIST_FIELD_PERSONNUMBER.equals(fieldName) && personNumber != null) {
                    item.setDefaultValue(String.valueOf(personNumber));
                }
                if ("person.name".equals(fieldName) && personName != null) {
                    item.setDefaultValue(String.valueOf(personName));
                }
            });
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        if ("departMsg".equals(dataSource)) {
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("appointstatus".equals(fieldName)) {
                    item.setDefaultValue(AppointStatusEnum.ING_APPOINT.getVal());
                }
                if ("org.name".equals(fieldName)) {
                    item.setDefaultValue(null);
                }
            });
        }
        if ("withdrawDepartMsg".equals(dataSource)) {
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("appointstatus".equals(fieldName)) {
                    item.setDefaultValue(null);
                }
                if ("org.name".equals(fieldName)) {
                    item.setDefaultValue(null);
                }
            });
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("appointtype.id".equals(args.getFieldName())) {
            QFilter qFilter = new QFilter("group.id", "=", (Object)1472620455524432896L);
            args.addCustomQFilter(qFilter);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("appointtype.name")) {
            QFilter qFilter = new QFilter("group.id", "=", (Object)1472620455524432896L);
            args.addCustomQFilter(qFilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter dismissFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.DISMISS.getNumber());
        e.addCustomQFilter(dismissFilter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String isQuickDismiss = this.getPageCache().get("applytype");
        if (!HRStringUtils.isEmpty((String)isQuickDismiss)) {
            e.getParameter().setCustomParam("applytype", (Object)isQuickDismiss);
            this.getPageCache().remove("applytype");
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        for (IListColumn column : columns) {
            column.setFixed(true);
            if (!column.getListFieldKey().equals(LIST_FIELD_PERSONNUMBER)) continue;
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (operateKey.equals("quickdismiss")) {
            this.getPageCache().put("applytype", "1");
        }
        terminateFormService.callValidatorBeforeDoOperation(args, "terminate", (AbstractFormPlugin)this);
        unSubmitFormService.callValidatorBeforeDoOperation(args, "unsubmit", (AbstractFormPlugin)this);
        deleteFormService.callValidatorBeforeDoOperation(args, "listdelete", (AbstractFormPlugin)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject[] dismissBills;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ((operateKey.equals("quickdismiss") || operateKey.equals("newdismiss")) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("new");
        }
        if (operateKey.equals("terminate") || operateKey.equals("unsubmit")) {
            terminateFormService.refreshAfterDoOperation(afterDoOperationEventArgs, (AbstractFormPlugin)this);
        }
        if (EXPORT_APPOINT.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess() && (dismissBills = this.getDismissBills()).length > 0) {
            String url = AppointEditorUtil.getCacheUrl("dismiss", dismissBills);
            this.getView().download(url);
        }
    }

    private DynamicObject[] getDismissBills() {
        List pkIds = this.getSelectedRows().stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        return dismissBillApplicationService.getDismissBillById("person,employee,billno,appointreason,aposition,dposition,appointstatus,nominatestatus,atenure", pkIds);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("unsubmit") && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            unSubmitFormService.doOperationConfirmCallBack((AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("cadm_termination")) {
            terminateFormService.doTerminateAllCloseCallBack(returnData, (AbstractFormPlugin)this);
        }
        if (actionId.equals("terminate")) {
            terminateFormService.doTerminatePartCloseCallBack(returnData, (AbstractFormPlugin)this);
        }
        if (actionId.equals("unsubmit")) {
            unSubmitFormService.doOperationClosedCallBack(returnData, "unsubmit", (AbstractFormPlugin)this);
        }
        if (actionId.equals("listdelete")) {
            deleteFormService.doOperationClosedCallBack(returnData, "listdelete", (AbstractFormPlugin)this);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        nominateCommonFormService.setNominateAndDismissList(args, this.getView().getPageCache());
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        ColumnDesc source = (ColumnDesc)e.getSource();
        String fieldKey = source.getFieldKey();
        if ("dismissposition".equals(fieldKey)) {
            IPageCache pageCache = this.getView().getPageCache();
            String pkObj = e.getRowData().getPkValue().toString();
            String dismissPosition = pageCache.get(pkObj);
            e.setFormatValue((Object)dismissPosition);
        }
    }
}

