/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamHisStatusEnum;

public class ExamHisDetailPlugin
extends HRDynamicFormBasePlugin {
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long recordId = Long.parseLong((String)formShowParameter.getCustomParam("pkId"));
        DynamicObject examArrange = examineBillApplicationService.getExamArrangeHisById("status", recordId.longValue());
        String status = examArrange.getString("status");
        DynamicObject[] coops = examCoopBillApplicationService.queryExamCoopByArrangeRecordId(recordId);
        List sortedRecords = Arrays.stream(coops).sorted(Comparator.comparing(item -> item.getDate("starttime"), (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o2.compareTo((Date)o1);
        })).collect(Collectors.toList());
        if (sortedRecords.size() > 0) {
            int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", sortedRecords.size());
            for (int i = 0; i < indexArr.length; ++i) {
                boolean isDiscard;
                DynamicObject examCoop = (DynamicObject)sortedRecords.get(i);
                long handlerId = examCoop.getLong("handler_id");
                this.getModel().setValue("examinecoop", examCoop.get("id"), indexArr[i]);
                String coopstatus = examCoop.getString("coopstatus");
                boolean bl = isDiscard = ExamHisStatusEnum.DISCARD.getNumber().equals(status) && handlerId != 0L;
                if (ExamCoopStatusEnum.COMPLETED.getNumber().equals(coopstatus) || isDiscard) {
                    this.getModel().setValue("coopresult", (Object)examCoop.getString("coopresult"), indexArr[i]);
                } else {
                    this.getModel().setValue("coopresult", (Object)"", indexArr[i]);
                }
                DynamicObjectCollection entryentity = (DynamicObjectCollection)examCoop.get("entryentity");
                Object[] examItemIdArr = entryentity.stream().map(item -> item.get("examitem_id")).toArray();
                this.getModel().setValue("planexamitem", (Object)examItemIdArr, indexArr[i]);
                this.getModel().setValue("starttime", (Object)examCoop.getDate("starttime"), indexArr[i]);
            }
        }
        this.getView().updateView("entryentity");
    }
}

