/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.common.bo.NodeBo;

public class ExamPlanAddItemEdit
extends HRDynamicFormBasePlugin
implements SearchEnterListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(ExamPlanAddItemEdit.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search leftSearch = (Search)this.getControl("srcsearchap");
        leftSearch.addEnterListener((SearchEnterListener)this);
        Search rightSearch = (Search)this.getView().getControl("destsearchap");
        rightSearch.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"btn_itemadd", "btn_itemdel", "sure", "close"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        Map<String, List<NodeBo>> examPlanMap = this.getExamPlanMap();
        List selectItemIds = (List)this.getView().getFormShowParameter().getCustomParam("selectitemid");
        this.createTreeView("srctreeviewap", examPlanMap, selectItemIds, false, false);
        this.createTreeView("desttreeviewap", examPlanMap, selectItemIds, true, true);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("LeftTreeMapRelation", SerializationUtils.serializeToBase64(examPlanMap));
        pageCache.put("rightTreeCache", SerializationUtils.serializeToBase64((Object)selectItemIds));
    }

    private void createTreeView(String treeViewKey, Map<String, List<NodeBo>> examPlanMap, List<String> selectNodeIds, boolean onlyShowSelectNode, boolean isOpenNode) {
        ArrayList<String> nodeIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(selectNodeIds)) {
            nodeIds.addAll(selectNodeIds);
        }
        if (!onlyShowSelectNode) {
            List allNodeIds = examPlanMap.values().stream().flatMap(Collection::stream).map(NodeBo::getId).collect(Collectors.toList());
            nodeIds.addAll(allNodeIds);
        }
        TreeNode rootTree = this.buildTreeNode(examPlanMap, nodeIds, isOpenNode);
        TreeView rightTreeView = (TreeView)this.getControl(treeViewKey);
        rightTreeView.deleteAllNodes();
        rightTreeView.addNode(rootTree);
    }

    private TreeNode buildTreeNode(Map<String, List<NodeBo>> examPlanMap, List<String> selectNodeIds, boolean isOpenNode) {
        TreeNode rootTree = this.getRootTreeNode();
        for (Map.Entry<String, List<NodeBo>> entry : examPlanMap.entrySet()) {
            List<NodeBo> nodeBos = entry.getValue();
            TreeNode fatherNode = null;
            for (NodeBo nodeBo : nodeBos) {
                String childNodeId = nodeBo.getId();
                if (!selectNodeIds.contains(childNodeId)) continue;
                if (fatherNode == null) {
                    fatherNode = new TreeNode(rootTree.getId(), nodeBo.getParentId(), nodeBo.getParentName());
                    fatherNode.setIsOpened(isOpenNode);
                    rootTree.addChild(fatherNode);
                }
                TreeNode childNode = new TreeNode(fatherNode.getId(), childNodeId, nodeBo.getName());
                fatherNode.addChild(childNode);
            }
        }
        return rootTree;
    }

    private TreeNode getRootTreeNode() {
        TreeNode rootTree = new TreeNode();
        rootTree.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ExamPlanAddItemEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        rootTree.setIsOpened(true);
        return rootTree;
    }

    private Map<String, List<NodeBo>> getExamPlanMap() {
        DynamicObject[] examPlanDynObjs = examineBillApplicationService.getExamItem();
        return Arrays.stream(examPlanDynObjs).map(obj -> {
            String id = obj.getString("id");
            String name = obj.getString("name");
            String parentId = obj.getDynamicObject("group").getString("id");
            String parentName = obj.getDynamicObject("group").getString("name");
            return new NodeBo(parentId, parentName, id, name);
        }).collect(Collectors.groupingBy(NodeBo::getParentId));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("btn_itemadd") || key.equals("btn_itemdel")) {
            this.doRightTreeNodeAddOrDelete(key);
        }
        if (key.equals("sure")) {
            this.returnEntryDataToParent();
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Search search = (Search)searchEnterEvent.getSource();
        String searchText = searchEnterEvent.getText().trim();
        IPageCache pageCache = this.getPageCache();
        String leftTreeMapBase64 = pageCache.get("LeftTreeMapRelation");
        Map examPlanMap = (Map)SerializationUtils.deSerializeFromBase64((String)leftTreeMapBase64);
        if (StringUtils.equals((CharSequence)"srcsearchap", (CharSequence)search.getKey())) {
            this.searchLeftTree(searchText, examPlanMap);
        }
        if (StringUtils.equals((CharSequence)"destsearchap", (CharSequence)search.getKey())) {
            this.searchRightTree(searchText, pageCache, examPlanMap);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey = event.getTabKey();
        if ("chooseexamitem".equals(subTabKey)) {
            this.cacheEntryData();
        }
        if ("sortexamitem".equals(subTabKey)) {
            this.loadNodeDataToEntry();
        }
    }

    private void returnEntryDataToParent() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        Map<String, Object> groupAndItemEntryData = currentTab.equals("sortexamitem") ? this.getGroupAndItemEntryData() : this.getRightTreeData();
        this.getView().returnDataToParent(groupAndItemEntryData);
        this.getView().close();
    }

    private void doRightTreeNodeAddOrDelete(String key) {
        IPageCache pageCache = this.getPageCache();
        String leftTreeMapBase64 = pageCache.get("LeftTreeMapRelation");
        Map examPlanMap = (Map)SerializationUtils.deSerializeFromBase64((String)leftTreeMapBase64);
        List<String> rightTreeNodeIdList = this.getRightTreeNodeId();
        if ("btn_itemadd".equals(key)) {
            List<String> selectedLeftNodeIds = this.getTreeViewSelectedChildNodeId("srctreeviewap");
            if (CollectionUtils.isEmpty(selectedLeftNodeIds)) {
                return;
            }
            rightTreeNodeIdList.addAll(selectedLeftNodeIds);
            this.updateEntryDataByAdd(examPlanMap, rightTreeNodeIdList);
        }
        if ("btn_itemdel".equals(key)) {
            List<String> selectedRightNodeIds = this.getTreeViewSelectedChildNodeId("desttreeviewap");
            if (CollectionUtils.isEmpty(selectedRightNodeIds)) {
                return;
            }
            this.updateEntryDataByDelete(examPlanMap, selectedRightNodeIds);
            rightTreeNodeIdList.removeAll(selectedRightNodeIds);
        }
        this.createTreeView("desttreeviewap", examPlanMap, rightTreeNodeIdList, true, true);
        pageCache.put("rightTreeCache", SerializationUtils.serializeToBase64(rightTreeNodeIdList));
    }

    private List<String> getRightTreeNodeId() {
        ArrayList rightTreeNodeIdList;
        IPageCache pageCache = this.getPageCache();
        String rightNodeIdBase64 = pageCache.get("rightTreeCache");
        if (HRStringUtils.isEmpty((String)rightNodeIdBase64)) {
            rightNodeIdBase64 = "";
        }
        if (CollectionUtils.isEmpty((Collection)(rightTreeNodeIdList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)rightNodeIdBase64)))) {
            rightTreeNodeIdList = new ArrayList();
        }
        return rightTreeNodeIdList;
    }

    private void updateEntryDataByAdd(Map<String, List<NodeBo>> examPlanMap, List<String> selectedNodeIds) {
        IPageCache pageCache = this.getPageCache();
        String parentIdListBase64 = pageCache.get("entryparentid");
        if (HRStringUtils.isEmpty((String)parentIdListBase64)) {
            return;
        }
        List parentIdList = (List)SerializationUtils.deSerializeFromBase64((String)parentIdListBase64);
        if (CollectionUtils.isEmpty((Collection)parentIdList)) {
            return;
        }
        String itemMapBase64 = pageCache.get("entryitemmap");
        Map rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)itemMapBase64);
        List<NodeBo> newNodeData = this.getExamItemNodeByNodeId(examPlanMap, selectedNodeIds);
        for (NodeBo nodeBo : newNodeData) {
            String parentId = nodeBo.getParentId();
            if (!parentIdList.contains(parentId)) {
                parentIdList.add(parentId);
                ArrayList<NodeBo> treeNodes = new ArrayList<NodeBo>();
                treeNodes.add(nodeBo);
                rightTreeNodeMap.put(parentId, treeNodes);
                continue;
            }
            List rightTreeNode = (List)rightTreeNodeMap.get(parentId);
            if (rightTreeNode != null && !rightTreeNode.contains(nodeBo)) {
                rightTreeNode.add(nodeBo);
            }
            rightTreeNodeMap.put(parentId, rightTreeNode);
        }
        pageCache.put("entryparentid", SerializationUtils.serializeToBase64((Object)parentIdList));
        pageCache.put("entryitemmap", SerializationUtils.serializeToBase64((Object)rightTreeNodeMap));
    }

    private void updateEntryDataByDelete(Map<String, List<NodeBo>> examPlanMap, List<String> selectedNodeIds) {
        IPageCache pageCache = this.getPageCache();
        String parentIdListBase64 = pageCache.get("entryparentid");
        if (HRStringUtils.isEmpty((String)parentIdListBase64)) {
            return;
        }
        List parentIdList = (List)SerializationUtils.deSerializeFromBase64((String)parentIdListBase64);
        if (CollectionUtils.isEmpty((Collection)parentIdList)) {
            return;
        }
        String itemMapBase64 = pageCache.get("entryitemmap");
        Map rightTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)itemMapBase64);
        List<NodeBo> newNodeData = this.getExamItemNodeByNodeId(examPlanMap, selectedNodeIds);
        for (NodeBo nodeBo : newNodeData) {
            String parentId = nodeBo.getParentId();
            if (!parentIdList.contains(parentId)) continue;
            List rightTreeNode = (List)rightTreeNodeMap.get(parentId);
            rightTreeNode.removeIf(treeNodeBo -> treeNodeBo.getId().equals(nodeBo.getId()));
            if (rightTreeNode.isEmpty()) {
                parentIdList.remove(parentId);
                rightTreeNodeMap.remove(parentId);
                continue;
            }
            rightTreeNodeMap.put(parentId, rightTreeNode);
        }
        pageCache.put("entryparentid", SerializationUtils.serializeToBase64((Object)parentIdList));
        pageCache.put("entryitemmap", SerializationUtils.serializeToBase64((Object)rightTreeNodeMap));
    }

    private List<String> getTreeViewSelectedChildNodeId(String treeViewKey) {
        TreeView treeView = (TreeView)this.getControl(treeViewKey);
        List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
        if (selectedNodeId.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u6570\u636e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExamPlanAddItemEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return new ArrayList<String>();
        }
        IPageCache pageCache = this.getPageCache();
        String leftTreeMapBase64 = pageCache.get("LeftTreeMapRelation");
        Map examPlanMap = (Map)SerializationUtils.deSerializeFromBase64((String)leftTreeMapBase64);
        List allChildNodeIds = examPlanMap.values().stream().flatMap(Collection::stream).map(NodeBo::getId).collect(Collectors.toList());
        List<String> selectedChildNodeIds = treeView.getTreeState().getSelectedNodeId().stream().filter(allChildNodeIds::contains).collect(Collectors.toList());
        return selectedChildNodeIds;
    }

    private void searchLeftTree(String searchText, Map<String, List<NodeBo>> examPlanMap) {
        ArrayList<String> selectItemIds = new ArrayList<String>();
        for (List<NodeBo> nodeBos : examPlanMap.values()) {
            if (nodeBos.get(0).getParentName().contains(searchText)) {
                selectItemIds.addAll(nodeBos.stream().map(NodeBo::getId).collect(Collectors.toList()));
                continue;
            }
            selectItemIds.addAll(nodeBos.stream().filter(nodeBo -> nodeBo.getName().contains(searchText)).map(NodeBo::getId).collect(Collectors.toList()));
        }
        boolean isOpenNode = !HRStringUtils.isEmpty((String)searchText);
        this.createTreeView("srctreeviewap", examPlanMap, selectItemIds, true, isOpenNode);
    }

    private void searchRightTree(String searchText, IPageCache pageCache, Map<String, List<NodeBo>> examPlanMap) {
        String rightNodeIdBase64 = pageCache.get("rightTreeCache");
        if (HRStringUtils.isEmpty((String)rightNodeIdBase64)) {
            return;
        }
        List rightNodeIdList = (List)SerializationUtils.deSerializeFromBase64((String)rightNodeIdBase64);
        if (CollectionUtils.isEmpty((Collection)rightNodeIdList)) {
            return;
        }
        List<String> selectItemIds = examPlanMap.values().stream().flatMap(Collection::stream).filter(nodeBo -> rightNodeIdList.contains(nodeBo.getId())).filter(nodeBo -> nodeBo.getName().contains(searchText) || nodeBo.getParentName().contains(searchText)).map(NodeBo::getId).collect(Collectors.toList());
        boolean isOpenNode = !HRStringUtils.isEmpty((String)searchText);
        this.createTreeView("desttreeviewap", examPlanMap, selectItemIds, true, isOpenNode);
    }

    private void loadNodeDataToEntry() {
        Map<String, Object> groupAndItemEntryData = this.getRightTreeData();
        List parentIdList = (List)groupAndItemEntryData.get("entryparentid");
        Map rightTreeNodeMap = (Map)groupAndItemEntryData.get("entryitemmap");
        if (CollectionUtils.isEmpty((Collection)parentIdList)) {
            return;
        }
        this.loadEntryData(parentIdList, rightTreeNodeMap);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("entryparentid", SerializationUtils.serializeToBase64((Object)parentIdList));
        pageCache.put("entryitemmap", SerializationUtils.serializeToBase64((Object)rightTreeNodeMap));
    }

    private Map<String, Object> getRightTreeData() {
        Map<String, List<NodeBo>> rightTreeNodeMap;
        ArrayList<String> parentIdList;
        HashMap<String, Object> entryData = new HashMap<String, Object>(16);
        IPageCache pageCache = this.getPageCache();
        String parentIdListBase64 = pageCache.get("entryparentid");
        if (!HRStringUtils.isEmpty((String)parentIdListBase64)) {
            parentIdList = (ArrayList<String>)SerializationUtils.deSerializeFromBase64((String)parentIdListBase64);
            String itemMapBase64 = pageCache.get("entryitemmap");
            rightTreeNodeMap = (Map<String, List<NodeBo>>)SerializationUtils.deSerializeFromBase64((String)itemMapBase64);
        } else {
            String leftTreeMapBase64 = pageCache.get("LeftTreeMapRelation");
            Map examPlanMap = (Map)SerializationUtils.deSerializeFromBase64((String)leftTreeMapBase64);
            String rightNodeIdBase64 = pageCache.get("rightTreeCache");
            if (HRStringUtils.isEmpty((String)rightNodeIdBase64)) {
                return entryData;
            }
            List rightNodeIdList = (List)SerializationUtils.deSerializeFromBase64((String)rightNodeIdBase64);
            if (CollectionUtils.isEmpty((Collection)rightNodeIdList)) {
                return entryData;
            }
            List<NodeBo> rightTreeChildNodeList = this.getExamItemNodeByNodeId(examPlanMap, rightNodeIdList);
            logger.info("getRightTreeData rightTreeChildNodeList data:{}", (Object)rightTreeChildNodeList.toString());
            parentIdList = new ArrayList<String>();
            for (NodeBo nodeBo2 : rightTreeChildNodeList) {
                if (parentIdList.contains(nodeBo2.getParentId())) continue;
                parentIdList.add(nodeBo2.getParentId());
            }
            rightTreeNodeMap = examPlanMap.values().stream().flatMap(Collection::stream).filter(nodeBo -> rightNodeIdList.contains(nodeBo.getId())).collect(Collectors.groupingBy(NodeBo::getParentId));
        }
        entryData.put("entryparentid", parentIdList);
        entryData.put("entryitemmap", rightTreeNodeMap);
        return entryData;
    }

    private void cacheEntryData() {
        DynamicObjectCollection groupEntry = this.getModel().getEntryEntity("groupentry");
        if (CollectionUtils.isEmpty((Collection)groupEntry)) {
            return;
        }
        Map<String, Object> groupAndItemEntryData = this.getGroupAndItemEntryData();
        List parentIdList = (List)groupAndItemEntryData.get("entryparentid");
        Map rightTreeNodeMap = (Map)groupAndItemEntryData.get("entryitemmap");
        IPageCache pageCache = this.getPageCache();
        pageCache.put("entryparentid", SerializationUtils.serializeToBase64((Object)parentIdList));
        pageCache.put("entryitemmap", SerializationUtils.serializeToBase64((Object)rightTreeNodeMap));
    }

    private Map<String, Object> getGroupAndItemEntryData() {
        HashMap<String, Object> entryData = new HashMap<String, Object>(16);
        DynamicObjectCollection groupEntry = this.getModel().getEntryEntity("groupentry");
        if (CollectionUtils.isEmpty((Collection)groupEntry)) {
            return entryData;
        }
        IPageCache pageCache = this.getPageCache();
        String leftTreeMapBase64 = pageCache.get("LeftTreeMapRelation");
        Map examPlanMap = (Map)SerializationUtils.deSerializeFromBase64((String)leftTreeMapBase64);
        List parentIdList = groupEntry.stream().map(entryRow -> String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("group")))).collect(Collectors.toList());
        HashMap rightTreeNodeMap = new HashMap(16);
        EntryGrid groupEntryGrid = (EntryGrid)this.getControl("groupentry");
        for (int i = 0; i < parentIdList.size(); ++i) {
            groupEntryGrid.selectRows(i);
            DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
            List<String> nodeIds = itemEntry.stream().map(entryRow -> String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("examitem")))).collect(Collectors.toList());
            List<NodeBo> examItemNodes = this.getExamItemNodeByNodeId(examPlanMap, nodeIds);
            rightTreeNodeMap.put(parentIdList.get(i), examItemNodes);
        }
        entryData.put("entryparentid", parentIdList);
        entryData.put("entryitemmap", rightTreeNodeMap);
        return entryData;
    }

    private void loadEntryData(List<String> parentIdList, Map<String, List<NodeBo>> rightTreeNodeMap) {
        if (CollectionUtils.isEmpty(parentIdList)) {
            return;
        }
        this.getModel().deleteEntryData("groupentry");
        this.getModel().deleteEntryData("itementry");
        int[] groupEntryRows = this.getModel().batchCreateNewEntryRow("groupentry", parentIdList.size());
        EntryGrid groupEntry = (EntryGrid)this.getControl("groupentry");
        for (int groupEntryRow : groupEntryRows) {
            this.getModel().setValue("group", (Object)Long.valueOf(parentIdList.get(groupEntryRow)), groupEntryRow);
            groupEntry.selectRows(groupEntryRow);
            List<NodeBo> nodeBos = rightTreeNodeMap.get(parentIdList.get(groupEntryRow));
            int[] itemEntryRows = this.getModel().batchCreateNewEntryRow("itementry", nodeBos.size());
            for (int i = 0; i < itemEntryRows.length; ++i) {
                this.getModel().setValue("examitem", (Object)Long.valueOf(nodeBos.get(i).getId()), itemEntryRows[i]);
            }
        }
        groupEntry.selectRows(0);
        this.getModel().updateCache();
    }

    private List<NodeBo> getExamItemNodeByNodeId(Map<String, List<NodeBo>> examPlanMap, List<String> itemIds) {
        Map<String, NodeBo> nodeBoMap = examPlanMap.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(NodeBo::getId, nodeBo -> nodeBo, (v1, v2) -> v2));
        List<NodeBo> list = itemIds.stream().distinct().map(nodeBoMap::get).collect(Collectors.toList());
        return list;
    }
}

