/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.common.bo.NodeBo;

public class ExamPlanEdit
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(ExamPlanEdit.class);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String action = (String)customParams.get("his_action");
        if (HRStringUtils.equals((String)action, (String)"open_insert_new_data_page")) {
            DynamicObjectCollection entryRows = this.getModel().getEntryEntity("examplanentry");
            for (DynamicObject entryRow : entryRows) {
                entryRow.getDataEntityState().setBizChanged(true);
                entryRow.getDataEntityState().setDirty(true);
                entryRow.getDataEntityState().setPushChanged(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSubEntry();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"remarkoperation")) {
            args.setCancel(true);
            this.showExamItemRemarkForm();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "donothing_addentry".equals(operateKey)) {
            List<String> examItemIds = this.getEntryExamItemId();
            this.showExamItemList(examItemIds);
        }
    }

    private void showExamItemRemarkForm() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("examplanentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("examplanentry", currentRowIndex);
        DynamicObject itemGroup = entryRowEntity.getDynamicObject("itemgroup");
        String itemGroupName = itemGroup.getString("name");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("itemgroup", itemGroupName);
        customParams.put("currentRowIndex", currentRowIndex);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cadm_examitemremark");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cadm_examitemremark"));
        formShowParameter.setCustomParams(customParams);
        String billStatus = (String)this.getModel().getValue("status");
        OperationStatus status = billStatus.equals("A") || billStatus.equals("G") ? OperationStatus.EDIT : OperationStatus.VIEW;
        formShowParameter.setStatus(status);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("donothing_addentry".equals(actionId)) {
            returnData = CastUtils.castMap((Object)closedCallBackEvent.getReturnData(), String.class);
            if (CollectionUtils.isEmpty((Map)returnData)) {
                LOG.info("ExamPlanEdit.closedCallBack: returnData is empty.");
                return;
            }
            List parentIdList = (List)returnData.get("entryparentid");
            LOG.info(MessageFormat.format("ExamPlanEdit.closedCallBack: groupIds return are {0}", parentIdList.toArray()));
            Map examItemTreeNodeMap = (Map)returnData.get("entryitemmap");
            Map<Long, Map<String, Object>> entryDataMap = this.getExamPlanEntryRowValue();
            Map<Long, Map<Long, String>> itemRemarkEntryValue = this.getItemRemarkEntryValue();
            this.insertExamPlanEntry(parentIdList, examItemTreeNodeMap, entryDataMap);
            this.insertSubEntry(itemRemarkEntryValue);
        }
        if ("cadm_examitemremark".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            this.updateSubEntry((Map)returnData);
        }
    }

    private void updateSubEntry(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        int currentRowIndex = (Integer)returnData.get("currentRowIndex");
        DynamicObjectCollection itemRemarkEntry = (DynamicObjectCollection)returnData.get("itemremarkentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("examplanentry", currentRowIndex);
        DynamicObjectCollection subCollection = entryRowEntity.getDynamicObjectCollection("itemremarkentry");
        subCollection.clear();
        DynamicObjectType dynamicObjectType = subCollection.getDynamicObjectType();
        for (DynamicObject examItem : itemRemarkEntry) {
            DynamicObject planExamItem = examItem.getDynamicObject("planexamitem");
            String itemRemark = examItem.getString("itemremark");
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("examitem", (Object)planExamItem);
            dynamicObject.set("itemremark", (Object)itemRemark);
            subCollection.add((Object)dynamicObject);
        }
        this.getView().updateView("itemremarkentry");
    }

    private Map<Long, Map<Long, String>> getItemRemarkEntryValue() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("examplanentry");
        HashMap<Long, Map<Long, String>> entryDataMap = new HashMap<Long, Map<Long, String>>(16);
        for (DynamicObject entryRow : itemEntry) {
            long itemGroupId = entryRow.getLong("itemgroup.id");
            HashMap<Long, String> rowDataMap = new HashMap<Long, String>(16);
            DynamicObjectCollection itemRemarkEntry = entryRow.getDynamicObjectCollection("itemremarkentry");
            for (DynamicObject object : itemRemarkEntry) {
                long examItemId = object.getLong("examitem.id");
                String itemRemark = object.getString("itemremark");
                rowDataMap.put(examItemId, itemRemark);
            }
            entryDataMap.put(itemGroupId, rowDataMap);
        }
        return entryDataMap;
    }

    private void initSubEntry() {
        DynamicObjectCollection itemRemarkEntry = this.getModel().getEntryEntity("itemremarkentry");
        if (CollectionUtils.isEmpty((Collection)itemRemarkEntry)) {
            this.insertSubEntry(new HashMap<Long, Map<Long, String>>(0));
        }
    }

    private void insertSubEntry(Map<Long, Map<Long, String>> itemRemarkEntryValue) {
        DynamicObjectCollection examPlanEntry = this.getModel().getEntryEntity("examplanentry");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("itemremarkentry");
        if (entryEntity != null) {
            this.getModel().deleteEntryData("itemremarkentry");
        }
        SubEntryProp subEntryProp = (SubEntryProp)examPlanEntry.getDynamicObjectType().getProperty("itemremarkentry");
        DynamicObjectType subEntryType = subEntryProp.getDynamicCollectionItemPropertyType();
        for (int i = 0; i < examPlanEntry.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)examPlanEntry.get(i);
            DynamicObjectCollection planExamItem = entryRow.getDynamicObjectCollection("planexamitem");
            DynamicObjectCollection subEntryRows = new DynamicObjectCollection(subEntryType, (Object)subEntryProp);
            long itemGroupId = entryRow.getLong("itemgroup.id");
            Map<Long, String> map = itemRemarkEntryValue.get(itemGroupId);
            for (DynamicObject examItem : planExamItem) {
                DynamicObject subEntryRow = subEntryRows.addNew();
                DynamicObject dynamicObject = examItem.getDynamicObject("fbasedataid");
                long examItemId = dynamicObject.getLong("id");
                subEntryRow.set("examitem", (Object)dynamicObject);
                if (map != null && map.containsKey(examItemId)) {
                    String name = map.get(examItemId);
                    subEntryRow.set("itemremark", (Object)name);
                    continue;
                }
                subEntryRow.set("itemremark", (Object)ResManager.getLocaleString((String)"\u62531\u661f\u4ee3\u8868\u8f83\u5dee\uff0c\u62535\u661f\u4ee3\u8868\u975e\u5e38\u4f18\u79c0\u3002", (String)"ExamPlanEdit_1", (String)"tdc-cadm-formplugin"));
            }
            entryRow.set("itemremarkentry", (Object)subEntryRows);
        }
    }

    private List<String> getEntryExamItemId() {
        DynamicObjectCollection examPlanEntry = this.getModel().getEntryEntity("examplanentry");
        List<String> examItemIds = examPlanEntry.stream().flatMap(entry -> entry.getDynamicObjectCollection("planexamitem").stream()).map(examItem -> String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)examItem.getDynamicObject("fbasedataid")))).collect(Collectors.toList());
        return examItemIds;
    }

    private void showExamItemList(List<String> examItemIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("selectitemid", examItemIds);
        showParameter.setFormId("cadm_examplanadditem");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_addentry"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u8003\u5bdf\u9879", (String)"ExamPlanEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void insertExamPlanEntry(List<String> parentIdList, Map<String, List<NodeBo>> examItemTreeNodeMap, Map<Long, Map<String, Object>> entryDataMap) {
        if (CollectionUtils.isEmpty(parentIdList)) {
            return;
        }
        this.getModel().deleteEntryData("examplanentry");
        int[] newEntryRow = this.getModel().batchCreateNewEntryRow("examplanentry", parentIdList.size());
        this.getModel().beginInit();
        for (int i = 0; i < newEntryRow.length; ++i) {
            Long groupId = Long.valueOf(parentIdList.get(i));
            Object[] itemIds = examItemTreeNodeMap.get(parentIdList.get(i)).stream().map(nodeBo -> Long.valueOf(nodeBo.getId())).toArray();
            this.getModel().setValue("itemgroup", (Object)groupId, newEntryRow[i]);
            this.getModel().setValue("planexamitem", (Object)itemIds, newEntryRow[i]);
            Map<String, Object> oldDataMap = entryDataMap.get(groupId);
            if (CollectionUtils.isEmpty(oldDataMap)) continue;
            Object planExamWayId = oldDataMap.get("planexamway");
            Object handlerPolicyId = oldDataMap.get("handlerpolicy");
            Object handlerSceneId = oldDataMap.get("handlerscene");
            Object examSla = oldDataMap.get("examsla");
            Object addMode = oldDataMap.get("addmode");
            Object groupMember = oldDataMap.get("groupmember");
            this.getModel().setValue("planexamway", planExamWayId, newEntryRow[i]);
            this.getModel().setValue("handlerpolicy", handlerPolicyId, newEntryRow[i]);
            this.getModel().setValue("handlerscene", handlerSceneId, newEntryRow[i]);
            this.getModel().setValue("examsla", examSla, newEntryRow[i]);
            this.getModel().setValue("addmode", addMode, newEntryRow[i]);
            this.getModel().setValue("groupmember", groupMember, newEntryRow[i]);
        }
        this.getModel().endInit();
        this.getModel().updateCache();
        this.getView().updateView("examplanentry");
    }

    private Map<Long, Map<String, Object>> getExamPlanEntryRowValue() {
        DynamicObjectCollection examPlanEntry = this.getModel().getEntryEntity("examplanentry");
        HashMap<Long, Map<String, Object>> entryDataMap = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject entryRow : examPlanEntry) {
            HashMap<String, Object> rowDataMap = new HashMap<String, Object>(16);
            Long itemGroupId = HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("itemgroup"));
            DynamicObjectCollection planExamItem = entryRow.getDynamicObjectCollection("planexamitem");
            rowDataMap.put("planexamitem", planExamItem);
            String planExamWay = entryRow.getString("planexamway");
            rowDataMap.put("planexamway", planExamWay);
            Long handlerPolicyId = HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("handlerpolicy"));
            rowDataMap.put("handlerpolicy", handlerPolicyId);
            Long handlerSceneId = HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("handlerscene"));
            rowDataMap.put("handlerscene", handlerSceneId);
            BigDecimal examSla = entryRow.getBigDecimal("examsla");
            rowDataMap.put("examsla", examSla);
            String addMode = entryRow.getString("addmode");
            rowDataMap.put("addmode", addMode);
            DynamicObjectCollection groupMember = entryRow.getDynamicObjectCollection("groupmember");
            rowDataMap.put("groupmember", groupMember);
            entryDataMap.put(itemGroupId, rowDataMap);
        }
        return entryDataMap;
    }
}

