/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.entity.ExamCoopBo;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamPlanTypeEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.cadm.common.constants.AppointCommonConstants;
import kd.tdc.cadm.formplugin.web.formservice.ExamineFormService;
import org.apache.commons.lang3.StringUtils;

public class ExamineBillEdit
extends HRCoreBaseBillEdit {
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ExamineFormService examineFormService = (ExamineFormService)ServiceFactory.getService(ExamineFormService.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);

    public void initialize() {
        super.initialize();
        this.setColItemVisible();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("before_submit".equals(operateKey)) {
            long examineId = this.getModel().getDataEntity().getLong("id");
            DynamicObject[] coops = examineBillApplicationService.queryExamineCoopById("coopstatus", Long.valueOf(examineId));
            boolean existUnHandledCoop = Arrays.stream(coops).anyMatch(coop -> ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coop.getString("coopstatus")));
            if (existUnHandledCoop) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u672a\u5904\u7406\u7684\u8003\u5bdf\u534f\u4f5c\u5355\u5c06\u5173\u95ed\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"ExamineBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("before_submit", (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            this.getView().invokeOperation("submit");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("before_submit".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getView().invokeOperation("submit");
        }
        if ("donothing_restart_coop".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.startCoopByType("restart_coop");
        }
    }

    private void startCoopByType(String type) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        DynamicObjectCollection coopHandler = entryentity.getDynamicObjectCollection("examinecoop.coophandler");
        if (coopHandler.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u4f4d\u8003\u5bdf\u7ec4\u6210\u5458\u3002", (String)"ExamineBillEdit_18", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        long coopId = entryentity.getLong("examinecoop.id");
        DynamicObject examCoop = examCoopBillApplicationService.queryExamCoopBillById("coopStatus", Long.valueOf(coopId));
        String coopStatus = examCoop.getString("coopStatus");
        DynamicObject examine = examineBillApplicationService.queryOne("examinestatus", this.getModel().getDataEntity().getPkValue());
        String examineStatus = examine.getString("examinestatus");
        if ("start_coop".equals(type) && (!ExamCoopStatusEnum.NOT_START.getNumber().equals(coopStatus) || ExamineStatusEnum.COMPLETE.getNumber().equals(examineStatus) || ExamineStatusEnum.TERMINATED.getNumber().equals(examineStatus))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("restart_coop".equals(type) && (ExamCoopStatusEnum.NOT_START.getNumber().equals(coopStatus) || ExamCoopStatusEnum.DISCARD.getNumber().equals(coopStatus) || ExamCoopStatusEnum.TERMINATED.getNumber().equals(coopStatus) || ExamineStatusEnum.COMPLETE.getNumber().equals(examineStatus) || ExamineStatusEnum.TERMINATED.getNumber().equals(examineStatus))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u8003\u5bdf\u534f\u4f5c\u5355\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("coop_type", type);
        operateOption.setVariableValue("coopId", String.valueOf(coopId));
        if ("restart_coop".equals(type)) {
            this.getView().invokeOperation("restart_coop", operateOption);
        } else if ("start_coop".equals(type)) {
            this.getView().invokeOperation("start_coop", operateOption);
        }
    }

    private void showExamHistory() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("id", (Object)dataEntity.getLong("id"));
        parameter.setFormId("cadm_examinehisdynamic");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "examHisCloseCallback"));
        this.getView().showForm(parameter);
    }

    private void adjustPerson() {
        boolean isAllow;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        long coopId = entryentity.getLong("examinecoop.id");
        DynamicObject examCoop = examCoopBillApplicationService.queryExamCoopBillById("coopStatus", Long.valueOf(coopId));
        String coopStatus = examCoop.getString("coopStatus");
        DynamicObject examine = examineBillApplicationService.queryOne("examinestatus", this.getModel().getDataEntity().getPkValue());
        String examineStatus = examine.getString("examinestatus");
        boolean bl = isAllow = (ExamCoopStatusEnum.NOT_START.getNumber().equals(coopStatus) || ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) && ExamineStatusEnum.IN_EXAMINE.getNumber().equals(examineStatus);
        if (!isAllow) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("currentRowIndex", (Object)currentRowIndex);
        parameter.setFormId("cadm_examadjustperson");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "examAdjustPersonCloseCallBack"));
        this.getView().showForm(parameter);
    }

    private void urge() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRow = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        long examCoopId = entryRow.getDynamicObject("examinecoop").getLong("id");
        DynamicObject examCoop = examCoopBillApplicationService.queryExamCoopById(Long.valueOf(examCoopId));
        String coopStatus = examCoop.getString("coopStatus");
        if (!ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("id", String.valueOf(examCoopId));
        this.getView().invokeOperation("urge", operateOption);
        Long id = (Long)this.getModel().getValue("id");
        DynamicObject[] examCoopArr = this.getExamCoopDataByExamineId(id);
        List<ExamCoopBo> examCoopBos = this.parseCoopBills(examCoopArr);
        this.loadExamCoopEntry(examCoopBos);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.loadPageCoopData();
        this.initHeadFlex();
        this.initPersonCardFlex();
        this.initAppointInfoTab();
        this.getModel().setDataChanged(false);
    }

    private void loadPageCoopData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long id = dataEntity.getLong("id");
        DynamicObject[] coopBills = this.getExamCoopDataByExamineId(id);
        if (coopBills.length > 0) {
            List<ExamCoopBo> examCoopBos = this.parseCoopBills(coopBills);
            this.setExamCoopEntryVisible(true);
            this.loadExamCoopEntry(examCoopBos);
            this.loadHisData(examCoopBos);
            FlexPanelAp flexPanelAp = this.createAp(examCoopBos);
            Container flexPanel = (Container)this.getView().getControl("examdetailsflex");
            flexPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
            this.getView().updateControlMetadata("examdetailsflex", flexPanelAp.createControl());
            this.getView().updateView("examdetailsflex");
            this.refreshValue(id);
            this.setResultStatistics(examCoopBos);
            Tab tab = (Tab)this.getControl("examdetailstabap");
            for (ExamCoopBo examCoopBo : examCoopBos) {
                String key = "examdetailstabpageap-" + examCoopBo.getCoopId();
                this.showExamCoopLayout(key);
                tab.activeTab(key);
            }
            String firstKey = "examdetailstabpageap-" + examCoopBos.get(0).getCoopId();
            tab.activeTab(firstKey);
        } else {
            this.setExamCoopEntryVisible(false);
        }
    }

    private void loadHisData(List<ExamCoopBo> examCoopBos) {
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        if (arrangeRecordId != null) {
            long handlerNum = examCoopBos.stream().filter(p -> p.getHandlerId() != 0L).count() * 100L;
            BigDecimal ratio = BigDecimal.ZERO;
            if (handlerNum != 0L) {
                ratio = new BigDecimal(handlerNum).divide(new BigDecimal(examCoopBos.size()), 1, 4);
            }
            String ratioStr = ratio.toString() + "%";
            this.getModel().setValue("examcoopratio", (Object)ratioStr);
            DynamicObject examArrange = examineBillApplicationService.getExamArrangeHisById("examplanid.id", Long.parseLong(arrangeRecordId.toString()));
            long examplanid = examArrange.getLong("examplanid.id");
            this.getModel().setValue("examplan", (Object)examplanid);
        }
    }

    private DynamicObject[] getExamCoopDataByExamineId(Long id) {
        String selectProperties = "coopstatus,examplan,examplan.examplanentry,coopresult,coopcomment,examsla,isurge,createtime,cooptaketime,itemgroup,entryentity.examitem,entryentity.score,entryentity.itemremark,examarrrecordid,startTime,handler,handletime";
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        DynamicObject[] coops = arrangeRecordId != null ? examineBillApplicationService.queryExamineCoopByArrangeRecordId(selectProperties, Long.valueOf(Long.parseLong(arrangeRecordId.toString()))) : examineBillApplicationService.queryExamineCoopById(selectProperties, id);
        if (arrangeRecordId == null) {
            Arrays.stream(coops).forEach(coop -> {
                if (!ExamCoopStatusEnum.COMPLETED.getNumber().equals(coop.getString("coopstatus"))) {
                    coop.set("coopresult", (Object)"");
                    coop.set("coopcomment", (Object)"");
                    DynamicObjectCollection entryEntity = coop.getDynamicObjectCollection("entryentity");
                    entryEntity.forEach(element -> element.set("score", (Object)0));
                }
            });
        }
        if (coops.length > 0) {
            coops = examCoopBillApplicationService.adjustCoopsBySeq(coops);
        }
        return coops;
    }

    private void setExamCoopEntryVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"entryentity", "flexpanelap1", "flexpanelap2", "examdetailsflex"});
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"examcoopisemptyflex"});
        String examineStatus = (String)this.getModel().getValue("examinestatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        if (!visible && (ExamineStatusEnum.COMPLETE.getNumber().equals(examineStatus) || ExamineStatusEnum.TERMINATED.getNumber().equals(examineStatus))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodataflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nonstartexamflex"});
        }
    }

    private void refreshValue(Long id) {
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        if (arrangeRecordId != null) {
            return;
        }
        DynamicObject examine = examineBillApplicationService.queryOne("examplan,examcoopratio", (Object)id);
        String examcoopratio = examine.getString("examcoopratio");
        long examplanId = examine.getLong("examplan_id");
        this.getModel().setValue("examplan", (Object)examplanId);
        if (StringUtils.isBlank((CharSequence)examcoopratio)) {
            this.getModel().setValue("examcoopratio", (Object)"-");
        } else {
            this.getModel().setValue("examcoopratio", (Object)examcoopratio);
        }
        this.getView().updateView("examcoopratio");
    }

    private void setResultStatistics(List<ExamCoopBo> examCoopBos) {
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        Map resultStatisticsMap = arrangeRecordId != null ? examCoopBos.stream().filter(p -> p.getHandlerId() != null && p.getHandlerId() != 0L).map(ExamCoopBo::getCoopResult).filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())) : examCoopBos.stream().map(ExamCoopBo::getCoopResult).filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        String resultStatisticsStr = resultStatisticsMap.entrySet().stream().map(entry -> MessageFormat.format("{0} {1}", entry.getKey(), entry.getValue())).collect(Collectors.joining("     "));
        Label resultStatisticsLabel = (Label)this.getControl("resultstatistics");
        if (StringUtils.isBlank((CharSequence)resultStatisticsStr)) {
            resultStatisticsStr = "-";
        }
        resultStatisticsLabel.setText(resultStatisticsStr);
    }

    private void loadExamCoopEntry(List<ExamCoopBo> examCoopBos) {
        this.getModel().deleteEntryData("entryentity");
        int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", examCoopBos.size());
        for (int i = 0; i < indexArr.length; ++i) {
            ExamCoopBo examCoopBo = examCoopBos.get(i);
            this.getModel().setValue("examinecoop", (Object)examCoopBo.getCoopId(), indexArr[i]);
            this.getModel().setValue("timeused", (Object)examCoopBo.getTimeUsed(), indexArr[i]);
            if (ExamCoopStatusEnum.COMPLETED.getNumber().equals(examCoopBo.getCoopStatus())) {
                this.getModel().setValue("coopresultvalue", (Object)examCoopBo.getCoopResult(), indexArr[i]);
                this.getModel().setValue("coopcomment", (Object)examCoopBo.getCoopComment(), indexArr[i]);
            }
            Boolean canUrge = examCoopBo.getCanUrge();
            String urge = ResManager.loadKDString((String)"\u50ac\u529e", (String)"ExamineBillEdit_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("urge", (Object)(canUrge != false ? urge : ""), indexArr[i]);
            List examItemBoList = examCoopBo.getExamItemBoList();
            Object[] examItemIdArr = examItemBoList.stream().map(item -> Long.valueOf(item.getExamItemId())).toArray();
            this.getModel().setValue("planexamitem", (Object)examItemIdArr, indexArr[i]);
        }
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    private void initPersonCardFlex() {
        cadmFormService.showPersonInfoCard(this.getView(), "personcardflex");
    }

    private void initHeadFlex() {
        cadmFormService.showBillHead(this.getView(), "headbillinfo");
    }

    private void initAppointInfoTab() {
        cadmFormService.showAppointInfoFlex(this.getView(), "tabpageap");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("start_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.loadPageCoopData();
        }
        if ("restart_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.loadPageCoopData();
        }
        if ("donothing_startexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long id = dataEntity.getLong("id");
            DynamicObject bill = examineBillApplicationService.queryOne("examinestatus", (Object)id);
            String examineStatus = bill.getString("examinestatus");
            if (!ExamineStatusEnum.TO_BE_EXAMINE.getNumber().equals(examineStatus) && !ExamineStatusEnum.IN_EXAMINE.getNumber().equals(examineStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_15", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject nominateBill = dataEntity.getDynamicObject("nominatebill");
            List planIds = examineBillApplicationService.queryExamPlanIds(Long.valueOf(dataEntity.getLong("id")));
            List<Long> ids = examineFormService.getControlledExamPlanData(planIds, this.getModel().getDataEntity().getLong("org.id"), ExamPlanTypeEnum.APPOINT_EXAM);
            if (CollectionUtils.isEmpty(ids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u53ef\u7528\u7684\u8003\u5bdf\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u8003\u5bdf\u65b9\u6848\u6216\u89c4\u5219\u7b56\u7565\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"ExamineBillEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("nominatebill", (Object)SerializationUtils.serializeToBase64((Object)nominateBill));
            DynamicObjectCollection entryentityList = dataEntity.getDynamicObjectCollection("entryentity");
            boolean isRestartExamCoop = false;
            boolean isAdjustExamPlan = false;
            if (!entryentityList.isEmpty()) {
                long count = entryentityList.stream().filter(p -> p.get("examinecoop.coopstatus").equals(ExamCoopStatusEnum.TO_BE_HANDLED.getNumber()) || p.get("examinecoop.coopstatus").equals(ExamCoopStatusEnum.COMPLETED.getNumber())).count();
                if (count > 0L) {
                    isRestartExamCoop = true;
                } else {
                    isAdjustExamPlan = true;
                }
            }
            parameter.setCustomParam("isRestartExamCoop", (Object)isRestartExamCoop);
            parameter.setCustomParam("adjustexamplan", (Object)isAdjustExamPlan);
            parameter.setCustomParam("examplan", ids);
            parameter.setCustomParam("org", (Object)this.getModel().getDataEntity().getLong("org.id"));
            parameter.setCustomParam("id", (Object)dataEntity.getLong("id"));
            parameter.setFormId("cadm_startexam");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "startExamCloseCallBack"));
            this.getView().showForm(parameter);
        }
        if ("showexamhistory".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.showExamHistory();
        }
        if ("donothing_start_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.startCoopByType("start_coop");
        }
        if ("donothing_restart_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject examine = examineBillApplicationService.queryOne("examinestatus", this.getModel().getDataEntity().getPkValue());
            String examineStatus = examine.getString("examinestatus");
            if (!ExamineStatusEnum.TO_BE_EXAMINE.getNumber().equals(examineStatus) && !ExamineStatusEnum.IN_EXAMINE.getNumber().equals(examineStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_15", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u5e9f\u5f03\u4e4b\u524d\u5df2\u542f\u52a8\u7684\u8003\u5bdf\u534f\u4f5c\u4efb\u52a1\uff0c\u5e76\u751f\u6210\u65b0\u7684\u4efb\u52a1\uff0c\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"ExamineBillList_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_restart_coop", (IFormPlugin)this));
        }
        if ("adjust_person".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.adjustPerson();
        }
        if ("save_startexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.loadPageCoopData();
        }
        if ("donothing_urge".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.urge();
        }
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess() && ("save".equals(operateKey) || "submit".equals(operateKey))) {
            this.loadPageCoopData();
            this.setColItemVisible();
            this.getView().updateView("entryentity");
        }
    }

    private void setColItemVisible() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            String coopstatus = pkEvent.getRowData().getString("examinecoop.coopstatus");
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String operationKey = operationColItem.getOperationKey();
                    boolean isHide = "donothing_urge".equals(operationKey) && !ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopstatus) || "donothing_start_coop".equals(operationKey) && !ExamCoopStatusEnum.NOT_START.getNumber().equals(coopstatus) || "donothing_restart_coop".equals(operationKey) && !ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopstatus) && !ExamCoopStatusEnum.COMPLETED.getNumber().equals(coopstatus) || "adjust_person".equals(operationKey) && !ExamCoopStatusEnum.NOT_START.getNumber().equals(coopstatus) && !ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopstatus);
                    if (!isHide) continue;
                    operationColItem.setVisible(false);
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("startExamCloseCallBack".equals(actionId)) {
            examineFormService.examStartOpAfterCloseCallBack(this.getView(), evt);
        }
        if ("examAdjustPersonCloseCallBack".equals(actionId) && !(returnData = CastUtils.castMap((Object)evt.getReturnData(), String.class)).isEmpty()) {
            int currentRowIndex = (Integer)returnData.get("currentRowIndex");
            DynamicObjectCollection coophandler = (DynamicObjectCollection)returnData.get("coophandler");
            DynamicObjectCollection interviewee = (DynamicObjectCollection)returnData.get("interviewee");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
            long coopId = entryRowEntity.getLong("examinecoop.id");
            DynamicObject examCoop = examCoopBillApplicationService.queryExamCoopById(Long.valueOf(coopId));
            String coopStatus = examCoop.getString("coopStatus");
            if (!ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) && !ExamCoopStatusEnum.NOT_START.getNumber().equals(coopStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection beforeCoopHandler = entryRowEntity.getDynamicObjectCollection("examinecoop.coophandler");
            Set before = beforeCoopHandler.stream().map(p -> p.getLong("fbasedataid_id")).collect(Collectors.toSet());
            Set after = coophandler.stream().map(p -> p.getLong("fbasedataid_id")).collect(Collectors.toSet());
            HashSet addHandler = new HashSet(16);
            addHandler.addAll(after);
            addHandler.removeAll(before);
            entryRowEntity.set("examinecoop.coophandler", (Object)coophandler);
            entryRowEntity.set("examinecoop.interviewee", (Object)interviewee);
            examCoop.set("coophandler", (Object)coophandler);
            examCoop.set("interviewee", (Object)interviewee);
            examCoopBillApplicationService.updateExamCoop(examCoop);
            if (!CollectionUtils.isEmpty(addHandler) && !ExamCoopStatusEnum.NOT_START.getNumber().equals(coopStatus)) {
                Long billId = examCoop.getLong("id");
                Long nominateId = examCoop.getLong("nominatebill.id");
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_examinecooperate").setParameter("formPkId", String.valueOf(billId)).builder();
                BosMessageService.sendTemplateMessage((String)contentUrl, new ArrayList(addHandler), (Long)nominateId, (String)"cadm_examinecooperate", (String)"cadm_startexam", (Long)billId);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ExamineBillList_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().updateView("entryentity");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"examcoopratio"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String pkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            billShowParameter.setPkId((Object)Long.valueOf(pkId));
        }
        DynamicObject bill = examineBillApplicationService.queryOne("examinestatus,handler,person.name", billShowParameter.getPkId());
        String examineStatus = bill.getString("examinestatus");
        if (ExamineStatusEnum.NOT_TRIGGER.getNumber().equals(examineStatus)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u60a8\u7684\u8bbf\u95ee\u94fe\u63a5\u5df2\u5931\u6548\u3002", (String)"ExamineBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List userIds = bill.getDynamicObjectCollection("handler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        Object checkPerm = billShowParameter.getCustomParam("checkPerm");
        if (!(checkPerm != null && "0".equals(checkPerm) || userIds.contains(currUserId))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExamineBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String personName = bill.getString("person.name");
        String customCaption = (String)billShowParameter.getCustomParam("caption");
        String caption = ResManager.loadKDString((String)"\u8003\u5bdf\u8bb0\u5f55-{0}", (String)"ExamineBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        if (HRStringUtils.isNotEmpty((String)customCaption)) {
            caption = customCaption;
        }
        billShowParameter.setCaption(caption);
    }

    private FlexPanelAp createAp(List<ExamCoopBo> examCoopBos) {
        FlexPanelAp containerAp = cadmFormService.createFlexPanelAp("examdetailsflex");
        TabAp tabAp = new TabAp();
        tabAp.setKey("examdetailstabap");
        tabAp.setTabStyle(3);
        tabAp.setCanSlide(true);
        tabAp.setShowDropdownIcon(true);
        for (ExamCoopBo examCoopBo : examCoopBos) {
            String itemGroupName = examCoopBo.getItemGroupName();
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("examdetailstabpageap-" + examCoopBo.getCoopId());
            tabPageAp.setName(new LocaleString(itemGroupName));
            tabAp.getItems().add(tabPageAp);
        }
        containerAp.getItems().add(tabAp);
        return containerAp;
    }

    private List<ExamCoopBo> parseCoopBills(DynamicObject[] coopBills) {
        ArrayList<ExamCoopBo> examCoopBos = new ArrayList<ExamCoopBo>(coopBills.length);
        for (DynamicObject coopBill : coopBills) {
            Long coopBillId = coopBill.getLong("id");
            String itemGroupName = coopBill.getDynamicObject("itemgroup").getString("name");
            String coopResult = coopBill.getString("coopresult");
            String coopStatus = coopBill.getString("coopstatus");
            String coopComment = coopBill.getString("coopcomment");
            long handlerId = coopBill.getLong("handler.id");
            Date handleTime = coopBill.getDate("handletime");
            Date startTime = coopBill.getDate("starttime");
            BigDecimal timeUsed = ExamCoopStatusEnum.COMPLETED.getNumber().equals(coopStatus) ? coopBill.getBigDecimal("cooptaketime") : this.calculateProcessedTime(coopStatus, startTime);
            Boolean showUrgeBtn = Boolean.FALSE;
            if (ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) {
                showUrgeBtn = Boolean.TRUE;
            }
            List examItemBoList = cadmFormService.convertCoopBillToExamItemBos(coopBill);
            ExamCoopBo examCoopBo = new ExamCoopBo(coopBillId, itemGroupName, coopResult, timeUsed, showUrgeBtn, examItemBoList);
            examCoopBo.setCoopComment(coopComment);
            examCoopBo.setCoopStatus(coopStatus);
            examCoopBo.setHandlerId(Long.valueOf(handlerId));
            examCoopBo.setHandleTime(handleTime);
            examCoopBos.add(examCoopBo);
        }
        return examCoopBos;
    }

    private BigDecimal calculateProcessedTime(String coopStatus, Date startTime) {
        if (ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) && startTime != null) {
            Date currentDate = new Date();
            long num = currentDate.getTime() - startTime.getTime();
            BigDecimal costTimeMills = BigDecimal.valueOf(num);
            BigDecimal costDay = costTimeMills.divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
            return costDay;
        }
        return BigDecimal.ZERO;
    }

    private void showExamCoopLayout(String tabKey) {
        String[] split = tabKey.split("-");
        Long coopId = Long.valueOf(split[1]);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)coopId);
        HashMap customMap = Maps.newHashMap();
        customMap.put("showFromExamBill", true);
        billShowParameter.setCustomParams((Map)customMap);
        billShowParameter.setFormId("cadm_examcoop_embed");
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.getOpenStyle().setTargetKey(tabKey);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

