/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamPlanTypeEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchRejectFormService;
import kd.tdc.cadm.formplugin.web.formservice.DismissPositionCommonService;
import kd.tdc.cadm.formplugin.web.formservice.ExamineFormService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class ExamineBillList
extends HRCoreBaseList {
    private static final ExamineBillApplicationService EXAMINE_BILL_APPLICATION_SERVICE = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final AppointBatchRejectFormService REJECT_FORM_SERVICE = (AppointBatchRejectFormService)ServiceFactory.getService(AppointBatchRejectFormService.class);
    private static final CadmFormService CADM_FORM_SERVICE = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final List<String> STATUS_LIST = Arrays.asList(ExamineStatusEnum.NOT_TRIGGER.getNumber(), ExamineStatusEnum.DEL.getNumber());
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);
    private static final ExamineFormService EXAMINE_FORM_SERVICE = (ExamineFormService)ServiceFactory.getService(ExamineFormService.class);
    private static final DismissPositionCommonService DISMISS_POSITION_COMMON_SERVICE = (DismissPositionCommonService)ServiceFactory.getService(DismissPositionCommonService.class);
    private static final String WILL_DISMISS_POSITION = "nominatebill.dposition.name";

    public void setFilter(SetFilterEvent e) {
        QFilter idLikeFilter = new QFilter("handler.fbasedataid", "in", (Object)RequestContext.get().getCurrUserId());
        QFilter statusFilter = new QFilter("examinestatus", "not in", STATUS_LIST);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        e.getQFilters().add(appointStatusQFilter);
        e.getQFilters().add(idLikeFilter);
        e.getQFilters().add(statusFilter);
        e.setOrderBy("examinestatus asc,createtime desc");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Map returnMap = CastUtils.castMap((Object)evt.getReturnData(), String.class);
        if ("reject_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_part".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("startExamCloseCallBack".equals(actionId)) {
            EXAMINE_FORM_SERVICE.examStartOpAfterCloseCallBack(this.getView(), evt);
        }
    }

    public void packageData(PackageDataEvent eve) {
        ColumnDesc source = (ColumnDesc)eve.getSource();
        String fieldKey = source.getFieldKey();
        if ("handler.number".equals(fieldKey)) {
            CADM_FORM_SERVICE.billListShowHandler(eve);
        }
        if (WILL_DISMISS_POSITION.equals(fieldKey)) {
            DISMISS_POSITION_COMMON_SERVICE.packageDismissPositionData(eve, WILL_DISMISS_POSITION, "nominatebill.djob.name", "nominatebill.dstandardposition.name");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("donothing_startexam".equals(operateKey) && (selectedRows = this.getSelectedRows()).size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u884c\u6570\u636e\u3002", (String)"ExamineBillList_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("reject".equals(operateKey)) {
            REJECT_FORM_SERVICE.setExportBills(this.getExamineBills());
            REJECT_FORM_SERVICE.callValidatorBeforeDoOperation(args, "reject", (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing_startexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Object primaryKeyValue = this.getSelectedRows().get(0).getPrimaryKeyValue();
            DynamicObject dataEntity = EXAMINE_BILL_APPLICATION_SERVICE.queryOne("nominatebill,org.id", primaryKeyValue);
            DynamicObject nominateBill = dataEntity.getDynamicObject("nominatebill");
            List planIds = EXAMINE_BILL_APPLICATION_SERVICE.queryExamPlanIds((Long)primaryKeyValue);
            List<Long> ids = EXAMINE_FORM_SERVICE.getControlledExamPlanData(planIds, dataEntity.getLong("org.id"), ExamPlanTypeEnum.APPOINT_EXAM);
            if (CollectionUtils.isEmpty(ids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u53ef\u7528\u7684\u8003\u5bdf\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u8003\u5bdf\u65b9\u6848\u6216\u89c4\u5219\u7b56\u7565\u662f\u5426\u914d\u7f6e\u6b63\u786e", (String)"ExamineBillList_11", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object pkValue = dataEntity.getPkValue();
            String selectProperties = "coopstatus,examplan,examplan.examplanentry,coopresult,coopcomment,examsla,isurge,createtime,cooptaketime,itemgroup,entryentity.examitem,entryentity.score,entryentity.itemremark,examarrrecordid,startTime,handler,handletime";
            DynamicObject[] coops = EXAMINE_BILL_APPLICATION_SERVICE.queryExamineCoopById(selectProperties, Long.valueOf(Long.parseLong(pkValue.toString())));
            boolean isRestartExamCoop = false;
            boolean isAdjustExamPlan = false;
            if (coops != null && coops.length > 0) {
                long count = Arrays.stream(coops).filter(p -> p.get("coopstatus").equals(ExamCoopStatusEnum.TO_BE_HANDLED.getNumber()) || p.get("coopstatus").equals(ExamCoopStatusEnum.COMPLETED.getNumber())).count();
                if (count > 0L) {
                    isRestartExamCoop = true;
                } else {
                    isAdjustExamPlan = true;
                }
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("nominatebill", (Object)SerializationUtils.serializeToBase64((Object)nominateBill));
            parameter.setCustomParam("isRestartExamCoop", (Object)isRestartExamCoop);
            parameter.setCustomParam("adjustexamplan", (Object)isAdjustExamPlan);
            parameter.setCustomParam("examplan", ids);
            parameter.setCustomParam("id", primaryKeyValue);
            parameter.setCustomParam("org", (Object)dataEntity.getLong("org.id"));
            parameter.setFormId("cadm_startexam");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "startExamCloseCallBack"));
            this.getView().showForm(parameter);
        }
        if ("reject".equals(operateKey) || "save_startexam".equals(operateKey)) {
            REJECT_FORM_SERVICE.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_COMMON_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    private DynamicObject[] getExamineBills() {
        List pkIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        return EXAMINE_BILL_APPLICATION_SERVICE.queryExamineBillById("id,person.name,person.number,billno,nominatebill.aposition.name,nominatebill.appointstatus,nominatebill.dposition.name,examinestatus,nominatebill.positiontype,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name", pkIds);
    }
}

