/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.RateAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.entity.ExamItemBo;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyTypeEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.constants.AppointCommonConstants;

public class ExamineCoopBillEdit
extends HRCoreBaseBillEdit
implements RateListener {
    private static final Log logger = LogFactory.getLog(ExamineCoopBillEdit.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long id = dataEntity.getLong("id");
        String coopStatus = dataEntity.getString("coopstatus");
        long handlerId = dataEntity.getLong("handler_id");
        Object showFromExamBill = this.getView().getFormShowParameter().getCustomParam("showFromExamBill");
        String lock = "view,submit,audit";
        if (!ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) || showFromExamBill != null) {
            lock = "new,edit,view,submit,audit";
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
        }
        DynamicObject examCoop = examCoopBillApplicationService.queryExamCoopBillById("entryentity.examitem,entryentity.itemremark,entryentity.score", id);
        List examItemBoList = cadmFormService.convertCoopBillToExamItemBos(examCoop);
        if (showFromExamBill != null) {
            this.setValueFromParent(coopStatus, examItemBoList, handlerId);
        }
        FlexPanelAp flexPanelAp = this.createAp(examItemBoList, lock);
        Container flexPanel = (Container)this.getView().getControl("rateflex");
        flexPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        for (ExamItemBo examItemBo : examItemBoList) {
            String examItemId = examItemBo.getExamItemId();
            BigDecimal score = examItemBo.getScore();
            String key = "rateap-" + examItemId;
            this.getView().getPageCache().put(key, score.toString());
            Rate rate = (Rate)this.getView().getControl(key);
            rate.setRateScore((Number)score);
        }
        this.getView().updateControlMetadata("rateflex", flexPanelAp.createControl());
        DynamicObjectCollection interviewee = this.getModel().getDataEntity().getDynamicObjectCollection("interviewee");
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isEmpty((Collection)interviewee)), new String[]{"defaultinterviewee"});
        Map<String, Object> customParams = this.buildCustomParams();
        cadmFormService.showBillHead(this.getView(), "headbillinfo", customParams);
        cadmFormService.showPersonInfoCard(this.getView(), "personcardflex");
        cadmFormService.showAppointInfoFlex(this.getView(), "tabpageap");
        this.calculateRemainingDays(dataEntity);
        this.setCoopResultCombo();
        this.getModel().setValue("coopstatuslab", (Object)ExamCoopStatusEnum.getEnumByVal((String)coopStatus).getName());
        this.getModel().setDataChanged(false);
    }

    private void setValueFromParent(String coopStatus, List<ExamItemBo> examItemBoList, long handlerId) {
        boolean isDiscard;
        boolean isCompleted = ExamCoopStatusEnum.COMPLETED.getNumber().equals(coopStatus);
        boolean bl = isDiscard = ExamCoopStatusEnum.DISCARD.getNumber().equals(coopStatus) && handlerId != 0L;
        if (!isCompleted && !isDiscard) {
            this.getModel().setValue("coopresult", (Object)"");
            this.getModel().setValue("coopcomment", (Object)"");
            this.getModel().setValue("score", (Object)0);
            examItemBoList.forEach(p -> p.setScore(BigDecimal.ZERO));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadAttachments();
        Object showFromExamBill = this.getView().getFormShowParameter().getCustomParam("showFromExamBill");
        if (showFromExamBill != null) {
            long id = (Long)this.getModel().getValue("id");
            List attachments = AttachmentServiceHelper.getAttachments((String)"cadm_examinecooperate", (Object)id, (String)"attachmentpanelap");
            if (!CollectionUtils.isEmpty((Collection)attachments) && ExamCoopStatusEnum.COMPLETED.getNumber().equals(this.getModel().getDataEntity().getString("coopstatus"))) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                attachmentPanel.bindData(attachments);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap", "attachlap"});
            }
        }
    }

    private void loadAttachments() {
        Object showFromExamBill = this.getView().getFormShowParameter().getCustomParam("showFromExamBill");
        if (showFromExamBill == null) {
            DynamicObject examPlan = (DynamicObject)this.getModel().getValue("examplan");
            long examPlanId = examPlan.getLong("id");
            List attachments = AttachmentServiceHelper.getAttachments((String)"cadm_examplan", (Object)examPlanId, (String)"attachmentpanelap");
            logger.info("attachments:{}", (Object)attachments);
            if (CollectionUtils.isEmpty((Collection)attachments)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"examplanpanel", "attachlab"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"examplanpanel", "attachlab"});
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("examplanpanel");
                attachmentPanel.bindData(attachments);
            }
        }
    }

    private Map<String, Object> buildCustomParams() {
        DynamicObject bill = this.getModel().getDataEntity();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("billno", bill.getString("billno"));
        DynamicObject nominateBill = bill.getDynamicObject("nominatebill");
        customParams.put("appointtype", nominateBill.getString("appointtype.name"));
        customParams.put("orgname", nominateBill.getString("org.name"));
        customParams.put("billtypename", ResManager.loadKDString((String)"\u8003\u5bdf\u534f\u4f5c", (String)"ExamineCoopBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ExamCoopStatusEnum coopStatusEnum = ExamCoopStatusEnum.getEnumByVal((String)bill.getString("coopstatus"));
        customParams.put("statusname", coopStatusEnum.getName());
        customParams.put("statustype", coopStatusEnum.getStatusType());
        DynamicObject handler = bill.getDynamicObject("handler");
        if (!Objects.isNull(handler)) {
            String handlerName = handler.getString("name");
            String handlerNumber = handler.getString("number");
            customParams.put("handlername", handlerName);
            customParams.put("handlernumber", handlerNumber);
        }
        customParams.put("handletime", bill.getDate("handletime"));
        String applyType = bill.getString("nominatebill.applytype");
        customParams.put("isfastapply", ApplyTypeEnum.FAST.getVal().equals(applyType));
        return customParams;
    }

    private void setCoopResultCombo() {
        DynamicObject examResultPlan = (DynamicObject)this.getModel().getValue("examresultplan");
        if (examResultPlan == null) {
            DynamicObject examPlan = (DynamicObject)this.getModel().getValue("examplan");
            Long examResultPlanId = examPlan.getDynamicObject("examresultplan").getLong("id");
            examResultPlan = examCoopBillApplicationService.queryExamResultPlanByExamResultPlanId(examResultPlanId);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("coopresult");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        DynamicObjectCollection resultPlanEntry = examResultPlan.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : resultPlanEntry) {
            String result = entryRow.getString("result");
            data.add(new ComboItem(new LocaleString(result), result));
        }
        comboEdit.setComboItems(data);
    }

    private void calculateRemainingDays(DynamicObject dataEntity) {
        String coopStatus = dataEntity.getString("coopstatus");
        if (ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) {
            long dateTime = this.calculateLatestCompletionTimeMills(dataEntity);
            long remainingTimeMillis = dateTime - System.currentTimeMillis();
            BigDecimal remainingDays = BigDecimal.valueOf(remainingTimeMillis).divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
            this.getModel().setValue("remainingdays", (Object)remainingDays.toString());
        } else {
            this.getModel().setValue("remainingdays", (Object)"-");
        }
    }

    private long calculateLatestCompletionTimeMills(DynamicObject dataEntity) {
        Date createTime = dataEntity.getDate("createtime");
        BigDecimal examSla = dataEntity.getBigDecimal("examsla");
        return createTime.getTime() + examSla.multiply(AppointCommonConstants.MILLISECONDS_IN_A_DAY).longValue();
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("rateap-")) {
            Rate rate = new Rate();
            rate.setKey(key);
            rate.setView(this.getView());
            rate.addRateListener((RateListener)this);
            args.setControl((Control)rate);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            boolean hasZero = false;
            Map rateScoreMap = this.getView().getPageCache().getAll();
            DynamicObjectCollection examItemScoreRows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < examItemScoreRows.size(); ++i) {
                DynamicObject row = (DynamicObject)examItemScoreRows.get(i);
                String examItemId = row.getDynamicObject("examitem").getString("id");
                String key = "rateap-" + examItemId;
                BigDecimal score = new BigDecimal((String)rateScoreMap.get(key));
                this.getModel().setValue("score", (Object)score, i);
                if (BigDecimal.ZERO.compareTo(score) != 0) continue;
                hasZero = true;
            }
            if (hasZero) {
                // empty if block
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.loadAttachments();
        }
    }

    private FlexPanelAp createAp(List<ExamItemBo> examItemBoList, String lock) {
        FlexPanelAp containerAp = cadmFormService.createFlexPanelAp("rateflex");
        int index = 1;
        for (ExamItemBo examItemBo : examItemBoList) {
            String examItemId = examItemBo.getExamItemId();
            LabelAp labelAp = cadmFormService.createLabelAp(index, examItemBo);
            containerAp.getItems().add(labelAp);
            if (HRStringUtils.isNotEmpty((String)examItemBo.getItemRemark())) {
                LabelAp remarkLabelAp = cadmFormService.createRemarkLabelAp(examItemBo);
                containerAp.getItems().add(remarkLabelAp);
            }
            RateAp rateAp = cadmFormService.createRateAp(examItemId, lock);
            containerAp.getItems().add(rateAp);
            ++index;
        }
        return containerAp;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean opStatus;
        super.preOpenForm(e);
        BillShowParameter baseShowParameter = (BillShowParameter)e.getSource();
        String pkId = (String)baseShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            baseShowParameter.setPkId((Object)pkId);
        }
        Long id = Long.valueOf(baseShowParameter.getPkId().toString());
        DynamicObject bill = examCoopBillApplicationService.queryExamCoopBillById("coopstatus,coophandler,person", id);
        String examineCoopStatus = bill.getString("coopstatus");
        List userIds = bill.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        Object showFromExamBill = baseShowParameter.getCustomParam("showFromExamBill");
        if (showFromExamBill == null && !userIds.contains(currUserId)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExamineCoopBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        baseShowParameter.setStatus((opStatus = ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(examineCoopStatus)) ? OperationStatus.EDIT : OperationStatus.VIEW);
        String personName = bill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u8003\u5bdf\u534f\u4f5c-{0}", (String)"ExamineCoopBillEdit_3", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        baseShowParameter.setCaption(caption);
    }

    public void update(RateEvent rateEvent) {
        Control rate = (Control)rateEvent.getSource();
        String key = rate.getKey();
        Number rateScore = rateEvent.getRateScore();
        this.getView().getPageCache().put(key, rateScore.toString());
    }
}

