/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.examine;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;

public class StartExamEdit
extends HRCoreBaseBillEdit {
    private static final Log LOG = LogFactory.getLog(StartExamEdit.class);
    private static final String REPEAT_START_FLEX = "repeatstartexplore";
    private static final String ADJUST_HANDLER_FLEX = "adjusthandler";
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void beforeBindData(EventObject e) {
        Boolean isAdjustExamPlan;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("org", formShowParameter.getCustomParam("org"));
        Boolean isRestartExamCoop = formShowParameter.getCustomParam("isRestartExamCoop") == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam("isRestartExamCoop");
        Boolean bl = isAdjustExamPlan = formShowParameter.getCustomParam("adjustexamplan") == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam("adjustexamplan");
        if (!isRestartExamCoop.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REPEAT_START_FLEX});
        }
        if (!isAdjustExamPlan.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADJUST_HANDLER_FLEX});
        }
        this.setExamPlanFilterAndDefaultVal();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showExamPlanEntryByExamPlanId();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        if ("examplan".equals(key)) {
            this.showExamPlanEntryByExamPlanId();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing_ok".equals(operateKey) && args.getOperationResult().isSuccess()) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            Long examPlanSourceVid = this.getModel().getDataEntity().getDynamicObject("examplan").getLong("sourcevid");
            returnData.put("examplan", examPlanSourceVid);
            Map<String, List<Long>> intervieweeMap = this.getInterviewee();
            returnData.put("interviewee", intervieweeMap);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private Map<String, List<Long>> getInterviewee() {
        HashMap<String, List<Long>> rltMap = new HashMap<String, List<Long>>(16);
        DynamicObjectCollection examPlanEntry = this.getModel().getDataEntity().getDynamicObjectCollection("examplanentry");
        for (DynamicObject row : examPlanEntry) {
            String itemGroupName = row.getString("itemgroup.name");
            DynamicObjectCollection interviewee = row.getDynamicObjectCollection("interviewee");
            List list = interviewee.stream().map(p -> p.getLong("fbasedataid.masterid")).collect(Collectors.toList());
            rltMap.put(itemGroupName, list);
        }
        return rltMap;
    }

    private void setExamPlanFilterAndDefaultVal() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("examplan");
        BasedataEdit examPlanEdit = (BasedataEdit)this.getView().getControl("examplan");
        examPlanEdit.setQFilter(new QFilter("id", "in", (Object)ids));
        Object examPlan = this.getModel().getValue("examplan");
        if (examPlan == null) {
            this.getModel().setValue("examplan", ids.get(0));
        }
    }

    private void showExamPlanEntryByExamPlanId() {
        DynamicObject examPlan = this.getModel().getDataEntity().getDynamicObject("examplan");
        if (examPlan != null) {
            Long examPlanId = examPlan.getLong("id");
            DynamicObject examPlanQ = examineBillApplicationService.queryExamPlanByExamPlanId(examPlanId);
            this.loadExamPlanEntry(examPlanQ);
            this.loadAttachments(examPlanId);
        }
    }

    private void loadAttachments(Long examPlanId) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"cadm_examplan", (Object)examPlanId, (String)"attachmentpanelap");
        if (CollectionUtils.isEmpty((Collection)attachments)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap", "labelap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanelap", "labelap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.bindData(attachments);
    }

    private void loadExamPlanEntry(DynamicObject examPlan) {
        String nominateStr = (String)this.getView().getFormShowParameter().getCustomParam("nominatebill");
        DynamicObject nominateBill = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)nominateStr);
        Map handlerMap = examineBillApplicationService.getExamCoopHandlerMap(examPlan, nominateBill);
        this.getModel().deleteEntryData("examplanentry");
        DynamicObjectCollection examPlanEntryRows = examPlan.getDynamicObjectCollection("examplanentry");
        if (examPlanEntryRows != null && examPlanEntryRows.size() > 0) {
            int[] indexArr = this.getModel().batchCreateNewEntryRow("examplanentry", examPlanEntryRows.size());
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_ok", "btn_cancel"});
            for (int i = 0; i < indexArr.length; ++i) {
                DynamicObject row = (DynamicObject)examPlanEntryRows.get(i);
                String id = row.getString("id");
                Long itemGroupId = row.getDynamicObject("itemgroup").getLong("id");
                DynamicObjectCollection examItems = row.getDynamicObjectCollection("planexamitem");
                this.getModel().setValue("itemgroup", (Object)itemGroupId, indexArr[i]);
                this.getModel().setValue("planexamitem", (Object)examItems.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).toArray(), indexArr[i]);
                List coopHandlerIds = (List)handlerMap.get(id);
                LOG.info("examplanentry-id:{},coopHandlerIds\uff1a{}", (Object)id, (Object)coopHandlerIds);
                if (CollectionUtils.isEmpty((Collection)coopHandlerIds)) continue;
                this.getModel().setValue("coophandler", (Object)coopHandlerIds.toArray(), indexArr[i]);
            }
        }
        this.getView().updateView("examplanentry");
    }
}

