/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.formplugin.web.formservice.batchopbase.BatchOpBaseFormService;
import kd.tdc.cadm.formplugin.web.resume.CadreResumeListPlugin;
import kd.tdc.tdcs.formplugin.web.batchconfirm.ConfirmPageUtil;

public class AppointBatchPrintFormService
extends BatchOpBaseFormService {
    private DynamicObject[] exportBills;
    private static final String EXCEL_IS_OPERABLE = "isoperable";
    private static final String EXCEL_CANNOT_OPERATE_REASON = "cannotoperatereason";
    private static final int MAX_SELECT_ROWS = 10;

    public void printPartCloseCallBack(CadreResumeListPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String failPkIdString = listView.getPageCache().get("failpkid");
        List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
        List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        selectedRows.removeAll(failRows);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isopcancel", "0");
        listView.invokeOperation("listprint", option);
    }

    @Override
    public void callValidatorBeforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs, String operateKey, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        int size = selectedRows.size();
        if (size > 10) {
            listView.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e00\u6b21\u6700\u591a\u53ef\u6253\u537010\u4efd\u5c65\u5386\u3002", (String)"CadreResumeListPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            beforeDoOperationEventArgs.setCancel(true);
            return;
        }
        super.callValidatorBeforeDoOperation(beforeDoOperationEventArgs, operateKey, formPlugin);
    }

    @Override
    protected boolean handleValidateResultForSomeFail(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"AppointBatchPrintFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = "" + (allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u6761\u53ef\u76f4\u63a5\u6253\u5370", (String)"AppointBatchPrintFormService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String noFitNumLbl = "" + failSize;
        String noFitLbl = ResManager.loadKDString((String)"\u6761\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u5c06\u4e3a\u60a8\u5ffd\u7565", (String)"AppointBatchPrintFormService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u6253\u5370\u64cd\u4f5c\u786e\u8ba4\u6570\u636e", (String)"AppointBatchPrintFormService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String finalLbl = ResManager.loadKDString((String)"\u7ee7\u7eed\u6253\u5370\uff1f", (String)"AppointBatchPrintFormService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getBatchConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)finalLbl, (String)excelName, exportDataList, headDataList);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "listprintok"));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"AppointBatchPrintFormService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        listView.showForm(confirmPage);
        return true;
    }

    @Override
    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(16);
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"AppointBatchPrintFormService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AppointBatchPrintFormService_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("gender", ResManager.loadKDString((String)"\u6027\u522b", (String)"AppointBatchPrintFormService_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("workunit", ResManager.loadKDString((String)"\u5355\u4f4d", (String)"AppointBatchPrintFormService_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("position", ResManager.loadKDString((String)"\u804c\u52a1", (String)"AppointBatchPrintFormService_11", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u4ee5\u6253\u5370", (String)"AppointBatchPrintFormService_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u6253\u5370\u7684\u539f\u56e0", (String)"AppointBatchPrintFormService_15", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    @Override
    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        DynamicObject[] actBills;
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject actBill : actBills = this.getExportBills()) {
            long billId = actBill.getLong("id");
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            excelRowData.put("name", actBill.getString("person.name"));
            excelRowData.put("number", actBill.getString("person.number"));
            excelRowData.put("gender", actBill.getString("gender.name"));
            excelRowData.put("workunit", actBill.getString("workunit"));
            excelRowData.put("position", actBill.getString("position"));
            String errorMessage = errorInfo.get(billId);
            excelRowData.put(EXCEL_IS_OPERABLE, HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"AppointBatchPrintFormService_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AppointBatchPrintFormService_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            excelRowData.put(EXCEL_CANNOT_OPERATE_REASON, errorMessage);
            exportData.add(excelRowData);
        }
        return exportData;
    }

    public DynamicObject[] getExportBills() {
        return this.exportBills;
    }

    public void setExportBills(DynamicObject[] exportBills) {
        this.exportBills = exportBills;
    }
}

