/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.batchopbase.BatchOpBaseFormService;
import kd.tdc.tdcs.formplugin.web.batchconfirm.ConfirmPageUtil;

public class AppointBatchRejectFormService
extends BatchOpBaseFormService {
    private static final String EXCEL_IS_OPERABLE = "isoperable";
    private static final String EXCEL_CANNOT_OPERATE_REASON = "cannotoperatereason";
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private DynamicObject[] exportBills;

    private void showRejectWindowForm(AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_reject");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "reject_all"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void rejectAllCloseCallBack(Map<String, Object> returnData, AbstractFormPlugin formPlugin) {
        OperateOption option = OperateOption.create();
        String reason = (String)returnData.get("details");
        option.setVariableValue("textedittitle", reason);
        option.setVariableValue("isopcancel", "0");
        formPlugin.getView().invokeOperation("reject", option);
    }

    public void rejectPartCloseCallBack(Map<String, Object> returnData, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String failPkIdString = listView.getPageCache().get("failpkid");
        List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
        List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        selectedRows.removeAll(failRows);
        String reason = (String)returnData.get("details");
        OperateOption option = OperateOption.create();
        option.setVariableValue("textedittitle", reason);
        option.setVariableValue("isopcancel", "0");
        listView.invokeOperation("reject", option);
    }

    @Override
    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        this.showRejectWindowForm(formPlugin);
        return true;
    }

    @Override
    protected boolean handleValidateResultForSomeFail(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"AppointBatchRejectFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = "" + (allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u64cd\u4f5c\u9a73\u56de", (String)"AppointBatchRejectFormService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String noFitNumLbl = "" + failSize;
        String noFitLbl = ResManager.loadKDString((String)"\u6761\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u8df3\u8fc7", (String)"AppointBatchRejectFormService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u9a73\u56de\u64cd\u4f5c\u786e\u8ba4\u6570\u636e", (String)"AppointBatchRejectFormService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String reasonName = ResManager.loadKDString((String)"\u9a73\u56de\u539f\u56e0", (String)"AppointBatchRejectFormService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String finalLbl = ResManager.loadKDString((String)"\u6d41\u7a0b\u5c06\u88ab\u9a73\u56de\u81f3\u4e0a\u4e00\u6d3b\u52a8\u73af\u8282\u5904\u7406\u4eba\uff0c\u4e14\u5bf9\u5e94\u5355\u636e\u5728\u5f53\u524d\u6d3b\u52a8\u73af\u8282\u5c06\u88ab\u9690\u85cf\uff0c\u786e\u5b9a\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff1a", (String)"AppointBatchRejectFormService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getSigReasonConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)excelName, exportDataList, headDataList, (String)reasonName, (String)finalLbl);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "reject_part"));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"AppointBatchRejectFormService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        listView.showForm(confirmPage);
        return true;
    }

    @Override
    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        IListView listView = (IListView)operate.getView();
        String formId = listView.getBillFormId();
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(16);
        headDataList.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AppointBatchRejectFormService_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"AppointBatchRejectFormService_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AppointBatchRejectFormService_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("nominatebill.aposition.name", ResManager.loadKDString((String)"\u62df\u4efb\u5c97\u4f4d", (String)"AppointBatchRejectFormService_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("nominatebill.ajob.name", ResManager.loadKDString((String)"\u62df\u4efb\u804c\u4f4d", (String)"AppointBatchRejectFormService_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("nominatebill.astandardposition.name", ResManager.loadKDString((String)"\u62df\u4efb\u6807\u51c6\u5c97\u4f4d", (String)"AppointBatchRejectFormService_18", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("nominatebill.dposition.name", ResManager.loadKDString((String)"\u62df\u514d\u4efb\u5c97", (String)"AppointBatchRejectFormService_11", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("nominatebill.appointstatus", ResManager.loadKDString((String)"\u4efb\u514d\u72b6\u6001", (String)"AppointBatchRejectFormService_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("actstatus", cadmFormService.getActBillStatusDesc(formId)));
        headDataList.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u9a73\u56de", (String)"AppointBatchRejectFormService_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u9a73\u56de\u7684\u539f\u56e0", (String)"AppointBatchRejectFormService_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    @Override
    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        DynamicObject[] actBills;
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject actBill : actBills = this.getExportBills()) {
            HashMap<String, Object> excelRowData = new HashMap<String, Object>(16);
            excelRowData.put("billno", actBill.get("billno"));
            excelRowData.put("name", actBill.getString("person.name"));
            excelRowData.put("number", actBill.getString("person.name"));
            excelRowData.put("nominatebill.aposition.name", actBill.getString("nominatebill.aposition.name"));
            excelRowData.put("nominatebill.ajob.name", actBill.getString("nominatebill.ajob.name"));
            excelRowData.put("nominatebill.astandardposition.name", actBill.getString("nominatebill.astandardposition.name"));
            String positionType = actBill.getString("nominatebill.positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                excelRowData.put("nominatebill.dposition.name", actBill.getString("nominatebill.dposition.name"));
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                excelRowData.put("nominatebill.dposition.name", actBill.getString("nominatebill.djob.name"));
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                excelRowData.put("nominatebill.dposition.name", actBill.getString("nominatebill.dstandardposition.name"));
            }
            String appointStatus = actBill.getString("nominatebill.appointstatus");
            excelRowData.put("nominatebill.appointstatus", AppointStatusEnum.getEnumByVal((String)appointStatus).getName());
            excelRowData.put("actstatus", cadmFormService.getStatusName(actBill));
            long billId = actBill.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put(EXCEL_IS_OPERABLE, HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"AppointBatchRejectFormService_15", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AppointBatchRejectFormService_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            excelRowData.put(EXCEL_CANNOT_OPERATE_REASON, errorMessage);
            exportData.add(excelRowData);
        }
        return exportData;
    }

    public DynamicObject[] getExportBills() {
        return this.exportBills;
    }

    public void setExportBills(DynamicObject[] exportBills) {
        this.exportBills = exportBills;
    }
}

