/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointOpExcelExportService;
import kd.tdc.cadm.formplugin.web.formservice.batchopbase.BatchOpBaseFormService;
import kd.tdc.tdcs.formplugin.web.batchconfirm.ConfirmPageUtil;

public class AppointBatchTerminateFormService
extends BatchOpBaseFormService {
    private static final Log logger = LogFactory.getLog(AppointBatchTerminateFormService.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final String CACHE_FAILPKID = "failpkid";

    public void callSingleBillTerminateValidatorBeforeDoOp(BeforeDoOperationEventArgs args, AbstractFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            IFormView view = formPlugin.getView();
            args.setCancel(true);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isopcancel", "1");
            BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
            String fromId = billShowParameter.getFormId();
            Object pkId = billShowParameter.getPkId();
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)operate.getOperateKey(), (String)fromId, (Object[])new Object[]{pkId}, (OperateOption)operateOption);
            List failPkId = preOpResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
            int failSize = failPkId.size();
            if (failSize == 0) {
                this.showTerminateForm(formPlugin);
            } else {
                view.showOperationResult(preOpResult);
            }
        }
    }

    public void doTerminateAllCloseCallBack(Object returnData, AbstractFormPlugin formPlugin) {
        Map terminateReasonMap = (Map)returnData;
        String reason = (String)terminateReasonMap.get("terminatereason");
        OperateOption option = OperateOption.create();
        option.setVariableValue("terminationidea", reason);
        option.setVariableValue("isopcancel", "0");
        formPlugin.getView().invokeOperation("terminate", option);
    }

    public void doTerminatePartCloseCallBack(Object returnData, AbstractFormPlugin formPlugin) {
        Map result = (Map)returnData;
        IListView listView = (IListView)formPlugin.getView();
        if (!CollectionUtils.isEmpty((Map)result) && ((Boolean)result.get("iscofirm")).booleanValue()) {
            String failPkIdString = listView.getPageCache().get(CACHE_FAILPKID);
            List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
            List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            selectedRows.removeAll(failRows);
            String reason = (String)result.get("details");
            OperateOption option = OperateOption.create();
            option.setVariableValue("terminationidea", reason);
            option.setVariableValue("isopcancel", "0");
            listView.invokeOperation("terminate", option);
        }
    }

    @Override
    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        this.showTerminateForm(formPlugin);
        return true;
    }

    private void showTerminateForm(AbstractFormPlugin formPlugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_termination");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "cadm_termination"));
        Map customParams = formPlugin.getView().getFormShowParameter().getCustomParams();
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        formPlugin.getView().showForm(showParameter);
    }

    @Override
    protected boolean handleValidateResultForSomeFail(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"AppointBatchTerminateFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = "" + (allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u64cd\u4f5c\u7ec8\u6b62\u4efb\u514d", (String)"AppointBatchTerminateFormService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String noFitNumLbl = "" + failSize;
        String noFitLbl = ResManager.loadKDString((String)"\u6761\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u8df3\u8fc7", (String)"AppointBatchTerminateFormService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u7ec8\u6b62\u4efb\u514d\u64cd\u4f5c\u786e\u8ba4\u6570\u636e", (String)"AppointBatchTerminateFormService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String reasonName = ResManager.loadKDString((String)"\u7ec8\u6b62\u539f\u56e0", (String)"AppointBatchTerminateFormService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String finalLbl = ResManager.loadKDString((String)"\u7ec8\u6b62\u4efb\u514d\u540e\uff0c\u6240\u9009\u4eba\u5458\u7684\u4efb\u514d\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e0d\u53ef\u64a4\u9500\u3002\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\u8bf7\u586b\u5199\u7ec8\u6b62\u539f\u56e0\uff1a", (String)"AppointBatchTerminateFormService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getSigReasonConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)excelName, exportDataList, headDataList, (String)reasonName, (String)finalLbl);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "terminate"));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"AppointBatchTerminateFormService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        this.setTerminationReasonParam(operationResult, formPlugin, confirmPage);
        listView.showForm(confirmPage);
        return true;
    }

    private void setTerminationReasonParam(OperationResult operationResult, AbstractFormPlugin formPlugin, FormShowParameter confirmPage) {
        try {
            IListView listView = (IListView)formPlugin.getView();
            String billFormId = listView.getBillFormId();
            if ("cadm_nominatebill".equals(billFormId)) {
                DynamicObject[] nominateBills;
                List personIdList;
                String reason;
                Set failPkId = operationResult.getAllErrorOrValidateInfo().stream().map(p -> (Long)p.getPkValue()).collect(Collectors.toSet());
                Set allPkId = operationResult.getBillNos().keySet().stream().map(p -> Long.parseLong(String.valueOf(p))).collect(Collectors.toSet());
                allPkId.removeAll(failPkId);
                if (!CollectionUtils.isEmpty(allPkId) && HRStringUtils.isNotEmpty((String)(reason = cadmFormService.setTerminationReasonParam(formPlugin, personIdList = Arrays.stream(nominateBills = nominateApplicationService.queryNominateBillsByIds("id,person", allPkId.stream().collect(Collectors.toList()))).map(p -> p.getLong("person_id")).collect(Collectors.toList()))))) {
                    confirmPage.setCustomParam("customReason", (Object)reason);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }

    @Override
    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        String opKey = operate.getOperateKey();
        IListView listView = (IListView)operate.getView();
        String formId = listView.getBillFormId();
        AppointOpExcelExportService excelExportService = new AppointOpExcelExportService();
        return excelExportService.createExcelHeadData(opKey, formId);
    }

    @Override
    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        List pkIds = listView.getSelectedRows().stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        DynamicObject[] appointBills = nominateApplicationService.queryNominateBillsByIds("person,employee,billno,aposition,dposition,ajob,djob,dstandardposition,astandardposition,appointstatus,nominatestatus,dismisstenure", pkIds);
        AppointOpExcelExportService excelExportService = new AppointOpExcelExportService();
        return excelExportService.createExcelExportData(operationResult, appointBills);
    }
}

