/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class AppointOpExcelExportService {
    private static final String EXCEL_IS_OPERABLE = "isoperable";
    private static final String EXCEL_CANNOT_OPERATE_REASON = "cannotoperatereason";

    public List<HRExportHeadObject> createExcelHeadData(String opKey, String formId) {
        ArrayList<HRExportHeadObject> headDatalist = new ArrayList<HRExportHeadObject>(16);
        headDatalist.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AppointOpExcelExportService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"AppointOpExcelExportService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AppointOpExcelExportService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        if (formId.equals("cadm_nominatebill")) {
            headDatalist.add(new HRExportHeadObject("aposition", ResManager.loadKDString((String)"\u62df\u4efb\u5c97\u4f4d", (String)"AppointOpExcelExportService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject("ajob", ResManager.loadKDString((String)"\u62df\u4efb\u804c\u4f4d", (String)"AppointOpExcelExportService_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject("astandardposition", ResManager.loadKDString((String)"\u62df\u4efb\u6807\u51c6\u5c97\u4f4d", (String)"AppointOpExcelExportService_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        headDatalist.add(new HRExportHeadObject("dposition", ResManager.loadKDString((String)"\u62df\u514d\u4efb\u5c97", (String)"AppointOpExcelExportService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("appointstatus", ResManager.loadKDString((String)"\u4efb\u514d\u72b6\u6001", (String)"AppointOpExcelExportService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        if (formId.equals("cadm_dismissbill")) {
            headDatalist.add(new HRExportHeadObject("nominatestatus", ResManager.loadKDString((String)"\u514d\u804c\u7533\u8bf7\u72b6\u6001", (String)"AppointOpExcelExportService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        } else if (formId.equals("cadm_nominatebill")) {
            headDatalist.add(new HRExportHeadObject("nominatestatus", ResManager.loadKDString((String)"\u4efb\u547d\u63d0\u540d\u72b6\u6001", (String)"AppointOpExcelExportService_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        if (opKey.equals("terminate")) {
            headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u7ec8\u6b62\u4efb\u514d", (String)"AppointOpExcelExportService_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u7ec8\u6b62\u7684\u539f\u56e0", (String)"AppointOpExcelExportService_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        if (opKey.equals("unsubmit")) {
            headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u64a4\u9500", (String)"AppointOpExcelExportService_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u64a4\u9500\u7684\u539f\u56e0", (String)"BrewOpExcelExportService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        if (opKey.equals("listdelete")) {
            headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5220\u9664", (String)"AppointOpExcelExportService_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u7684\u539f\u56e0", (String)"AppointOpExcelExportService_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        return headDatalist;
    }

    public List<Map<String, Object>> createExcelExportData(OperationResult operationResult, DynamicObject[] appointBills) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject appointBill : appointBills) {
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            String billNo = appointBill.getString("billno");
            excelRowData.put("billno", billNo);
            DynamicObject person = appointBill.getDynamicObject("person");
            if (HRObjectUtils.isEmpty((Object)person)) {
                excelRowData.put("name", "");
                excelRowData.put("number", "");
            } else {
                excelRowData.put("name", person.getString("name"));
                excelRowData.put("number", person.getString("number"));
            }
            String appointPosition = HRDyObjectPropUtil.getName((DynamicObject)appointBill.getDynamicObject("aposition"));
            excelRowData.put("aposition", appointPosition);
            String jobName = HRDyObjectPropUtil.getName((DynamicObject)appointBill.getDynamicObject("ajob"));
            excelRowData.put("ajob", jobName);
            String standardPositionName = HRDyObjectPropUtil.getName((DynamicObject)appointBill.getDynamicObject("astandardposition"));
            excelRowData.put("astandardposition", standardPositionName);
            DynamicObject dTenure = appointBill.getDynamicObject("dismisstenure");
            if (null != dTenure) {
                String positionType = dTenure.getString("apositiontype");
                if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                    String dismissPosition = HRDyObjectPropUtil.getName((DynamicObject)appointBill.getDynamicObject("dposition"));
                    excelRowData.put("dposition", dismissPosition);
                } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                    String dJobName = HRDyObjectPropUtil.getName((DynamicObject)appointBill.getDynamicObject("djob"));
                    excelRowData.put("dposition", dJobName);
                } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                    String dStandardPosition = HRDyObjectPropUtil.getName((DynamicObject)appointBill.getDynamicObject("dstandardposition"));
                    excelRowData.put("dposition", dStandardPosition);
                }
            }
            String appointStatus = appointBill.getString("appointstatus");
            excelRowData.put("appointstatus", AppointStatusEnum.getEnumByVal((String)appointStatus).getName());
            String nominateStatus = appointBill.getString("nominatestatus");
            excelRowData.put("nominatestatus", NominateStatusEnum.getEnumByVal((String)nominateStatus).getName());
            long billId = appointBill.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put(EXCEL_IS_OPERABLE, HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"AppointOpExcelExportService_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AppointOpExcelExportService_15", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            excelRowData.put(EXCEL_CANNOT_OPERATE_REASON, errorMessage);
            exportData.add(excelRowData);
        }
        return exportData;
    }
}

