/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.batchopbase.BatchOpBaseFormService;
import kd.tdc.tdcs.formplugin.web.batchconfirm.ConfirmPageUtil;

public class AppointPublicityWithdrawFormService
extends BatchOpBaseFormService {
    private static final PublicityBillApplicationService SERVICE = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final AppointBatchWithdrawFormService APPOINT_BATCH_WITHDRAW_FORM_SERVICE = (AppointBatchWithdrawFormService)ServiceFactory.getService(AppointBatchWithdrawFormService.class);
    private static final CadmFormService CADM_FORM_SERVICE = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final String EXCEL_IS_OPERABLE = "isoperable";
    private static final String EXCEL_CANNOT_OPERATE_REASON = "cannotoperatereason";
    private DynamicObject[] exportBills;

    @Override
    protected boolean handleValidateResultForSomeFail(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        this.showBatchConfirmPageDefault(operationResult, operate, allRowsSize, failSize, formPlugin);
        return true;
    }

    @Override
    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        return APPOINT_BATCH_WITHDRAW_FORM_SERVICE.createExcelHeadData(operate);
    }

    @Override
    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        DynamicObject[] actBills = this.getExportBills();
        IListView listView = (IListView)formPlugin.getView();
        for (DynamicObject actBill : actBills) {
            String errorMessage;
            HashMap publicityExcelRowData = Maps.newHashMap();
            publicityExcelRowData.put("billno", actBill.get("billno"));
            publicityExcelRowData.put("name", actBill.getString("person.name"));
            publicityExcelRowData.put("number", actBill.getString("person.name"));
            publicityExcelRowData.put("nominatebill.aposition.name", actBill.getString("nominatebill.aposition.name"));
            publicityExcelRowData.put("nominatebill.ajob.name", actBill.getString("nominatebill.ajob.name"));
            publicityExcelRowData.put("nominatebill.astandardposition.name", actBill.getString("nominatebill.astandardposition.name"));
            String positionType = actBill.getString("nominatebill.positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                publicityExcelRowData.put("nominatebill.dposition.name", actBill.getString("nominatebill.dposition.name"));
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                publicityExcelRowData.put("nominatebill.dposition.name", actBill.getString("nominatebill.djob.name"));
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                publicityExcelRowData.put("nominatebill.dposition.name", actBill.getString("nominatebill.dstandardposition.name"));
            }
            String appointStatus = actBill.getString("nominatebill.appointstatus");
            publicityExcelRowData.put("nominatebill.appointstatus", AppointStatusEnum.getEnumByVal((String)appointStatus) == null ? "" : AppointStatusEnum.getEnumByVal((String)appointStatus).getName());
            publicityExcelRowData.put("actstatus", CADM_FORM_SERVICE.getStatusName(actBill));
            String batchNum = actBill.getString("pubbatchnum");
            long pk = actBill.getLong("id");
            if (HRStringUtils.isBlank((CharSequence)batchNum)) {
                String errorInfoBase64 = listView.getPageCache().get("errorInfo");
                Map errorInfo = (Map)SerializationUtils.deSerializeFromBase64((String)errorInfoBase64);
                errorMessage = (String)errorInfo.get(pk);
            } else {
                String batchNumMappingErrorBase64 = listView.getPageCache().get("batchNumMappingError");
                Map batchNumMappingErrorMap = (Map)SerializationUtils.deSerializeFromBase64((String)batchNumMappingErrorBase64);
                errorMessage = (String)batchNumMappingErrorMap.get(batchNum);
            }
            publicityExcelRowData.put(EXCEL_IS_OPERABLE, HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"AppointBatchWithdrawFormService_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AppointBatchWithdrawFormService_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            publicityExcelRowData.put(EXCEL_CANNOT_OPERATE_REASON, errorMessage);
            exportData.add(publicityExcelRowData);
        }
        return exportData;
    }

    public void beforeWithdrawOperationWithSingle(BeforeDoOperationEventArgs args, AbstractFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            args.setCancel(true);
            IFormView view = formPlugin.getView();
            OperateOption operateOption = OperateOption.create();
            BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
            String fromId = billShowParameter.getFormId();
            Object pkId = billShowParameter.getPkId();
            operateOption.setVariableValue("isopcancel", "1");
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)operate.getOperateKey(), (String)fromId, (Object[])new Object[]{pkId}, (OperateOption)operateOption);
            List failPkId = preOpResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
            int failSize = failPkId.size();
            if (failSize == 0) {
                String batchNum = formPlugin.getView().getModel().getDataEntity().getString("pubbatchnum");
                DynamicObject[] byPubBatchNum = SERVICE.getByPubBatchNum("pubbatchnum,pubstatus", batchNum);
                this.showWithdraw(byPubBatchNum.length > 1, formPlugin, Lists.newArrayList((Object[])new String[]{batchNum}));
            } else {
                view.showOperationResult(preOpResult);
            }
        }
    }

    @Override
    public void callValidatorBeforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs, String operateKey, AbstractFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String opKey = operate.getOperateKey();
        if (!operateKey.equals(opKey)) {
            return;
        }
        String isOpCancel = operate.getOption().getVariableValue("isopcancel", null);
        IListView listView = (IListView)formPlugin.getView();
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            beforeDoOperationEventArgs.setCancel(true);
            OperateOption operateOption = OperateOption.create();
            String fromId = ((ListShowParameter)listView.getFormShowParameter()).getBillFormId();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            operateOption.setVariableValue("isopcancel", "1");
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)operate.getOperateKey(), (String)fromId, (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)operateOption);
            List failPkId = preOpResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
            int failSize = failPkId.size();
            if (failSize == 0) {
                Object[] primaryKeyValues = selectedRows.getBillListSelectedRowCollection().getPrimaryKeyValues();
                boolean ifShowTips = true;
                DynamicObject[] dynamicObjects = SERVICE.queryPublicityBillById("pubbatchnum", Arrays.asList(primaryKeyValues));
                if (primaryKeyValues.length == 1) {
                    String batchNum = dynamicObjects[0].getString("pubbatchnum");
                    DynamicObject[] byPubBatchNum = SERVICE.getByPubBatchNum("id", batchNum);
                    ifShowTips = byPubBatchNum.length != 1;
                }
                List<String> batchNumList = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getString("pubbatchnum")).distinct().collect(Collectors.toList());
                this.showWithdraw(ifShowTips, formPlugin, batchNumList);
                return;
            }
            this.handleValidateResult(preOpResult, operate, formPlugin);
        }
    }

    private void handleValidateResult(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        listView.getPageCache().remove("failpkid");
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        List failPkId = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
        int failSize = failPkId.size();
        if (failSize == 0) {
            if (!this.handleValidateResultForAllSuccess(operationResult, operate, formPlugin)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isopcancel", "0");
                listView.invokeOperation(operate.getOperateKey(), option);
            }
            return;
        }
        DynamicObject[] allSelectRowDynamic = SERVICE.queryPublicityBillById("pubbatchnum", Arrays.asList(selectedRows.getPrimaryKeyValues()));
        List allSelectBatchNumList = Arrays.stream(allSelectRowDynamic).map(dynamicObject -> dynamicObject.getString("pubbatchnum")).distinct().collect(Collectors.toList());
        int allRowsSize = CollectionUtils.isEmpty(allSelectBatchNumList) ? 0 : allSelectBatchNumList.size();
        DynamicObject[] notPassValidateDynamic = SERVICE.queryPublicityBillById("pubbatchnum", failPkId);
        List notPassBatchNumList = Arrays.stream(notPassValidateDynamic).map(dynamicObject -> dynamicObject.getString("pubbatchnum")).distinct().collect(Collectors.toList());
        int n = failSize = CollectionUtils.isEmpty(notPassBatchNumList) ? 0 : notPassBatchNumList.size();
        if (failSize == allRowsSize) {
            if (!this.handleValidateResultForAllFail(operationResult, operate, formPlugin)) {
                this.showValidateErrorMessage(operationResult, operate);
            }
            return;
        }
        allSelectBatchNumList.removeAll(notPassBatchNumList);
        String failPkIdString = SerializationUtils.serializeToBase64(failPkId);
        listView.getPageCache().put("failpkid", failPkIdString);
        listView.getPageCache().put("batchNumList", SerializationUtils.toJsonString(allSelectBatchNumList));
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        Map<String, String> batchNumMappingError = Arrays.stream(notPassValidateDynamic).collect(Collectors.toMap(dynamic -> dynamic.getString("pubbatchnum"), dynamicObject -> (String)errorInfo.get(dynamicObject.getLong("id")), (v1, v2) -> v1 + System.lineSeparator() + v2));
        listView.getPageCache().put("batchNumMappingError", SerializationUtils.serializeToBase64(batchNumMappingError));
        listView.getPageCache().put("errorInfo", SerializationUtils.serializeToBase64(errorInfo));
        this.handleValidateResultForSomeFail(operationResult, operate, allRowsSize, failSize, formPlugin);
    }

    private void showBatchConfirmPageDefault(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String fitNumLbl = "" + (allRowsSize - failSize);
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u4e2a\u6279\u6b21\u7684\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"AppointBatchWithdrawFormService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[]{allRowsSize});
        String noFitNumLbl = "" + failSize;
        String fitLbl = ResManager.loadKDString((String)"\u4e2a\u6279\u6b21\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u64cd\u4f5c\u64a4\u56de", (String)"AppointBatchWithdrawFormService_23", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u64a4\u56de\u64cd\u4f5c\u786e\u8ba4\u6570\u636e", (String)"AppointBatchWithdrawFormService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String noFitLbl = ResManager.loadKDString((String)"\u4e2a\u6279\u6b21\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u8df3\u8fc7", (String)"AppointBatchWithdrawFormService_24", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String reasonName = ResManager.loadKDString((String)"\u64a4\u56de\u539f\u56e0", (String)"AppointBatchWithdrawFormService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getSigReasonConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)excelName, exportDataList, headDataList, (String)reasonName, (String)"");
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "withdraw_part"));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"AppointBatchWithdrawFormService_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        confirmPage.setCustomParam("batchNumList", (Object)listView.getPageCache().get("batchNumList"));
        listView.showForm(confirmPage);
    }

    private void showWithdraw(boolean ifShowTips, AbstractFormPlugin formPlugin, List<String> batchNumList) {
        IFormView view = formPlugin.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("ifShowTips", (Object)ifShowTips);
        showParameter.setCustomParam("batchNumList", (Object)SerializationUtils.toJsonString(batchNumList));
        showParameter.setFormId("cadm_pubwithdraw");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "withdraw_all"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public DynamicObject[] getExportBills() {
        return this.exportBills;
    }

    public void setExportBills(DynamicObject[] exportBills) {
        this.exportBills = exportBills;
    }
}

