/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.entity.BrewMatchBo;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewPersonPositionMatchEnum;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewBillCandidateFormService {
    private static final Log LOG = LogFactory.getLog(BrewBillCandidateFormService.class);
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final String PROPERTY_PERSON = "person";
    private static final String FIELD_ADDCANDF7 = "addcandf7";
    private static final String CACHEKEY_ISADDCANDIDATE = "isaddcandidate";
    private static final String CACHE_BREWMATCHDETAIL = "brewmatchdetail";
    private static final String LBL_CANDIDATENUM = "lblcandidatenum";
    private static final String LBL_PASSNUM = "lblpassnum";
    private static final String LBL_NOTPASSNUM = "lblnotpassnum";
    private static final String LBL_CONCLUSIONNUM = "lblconclusionnum";

    public void showSelectCandidateF7(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        DynamicObjectCollection candidateEntry = model.getEntryEntity("candidateentry");
        model.beginInit();
        Object[] employeeIds = candidateEntry.stream().map(entryRow -> HRDyObjectPropUtil.getId((DynamicObject)entryRow.getDynamicObject("candcardemployee"))).toArray();
        model.setValue(FIELD_ADDCANDF7, (Object)employeeIds);
        model.endInit();
        BasedataEdit addCandidateF7 = (BasedataEdit)plugin.getControl(FIELD_ADDCANDF7);
        addCandidateF7.click();
        plugin.getPageCache().put(CACHEKEY_ISADDCANDIDATE, "1");
    }

    public void candidateF7Changed(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        DynamicObjectCollection candidateCollection = model.getDataEntity().getDynamicObjectCollection(FIELD_ADDCANDF7);
        if (candidateCollection.isEmpty()) {
            return;
        }
        List<Object> candidatePersonIds = new ArrayList();
        String isAddCandidate = plugin.getPageCache().get(CACHEKEY_ISADDCANDIDATE);
        if ("1".equals(isAddCandidate)) {
            DynamicObjectCollection candidateEntry = model.getEntryEntity("candidateentry");
            candidatePersonIds = candidateEntry.stream().map(entry -> HRDyObjectPropUtil.getId((DynamicObject)entry.getDynamicObject("candcardperson"))).collect(Collectors.toList());
        }
        ArrayList finalCandidatePersonIds = candidatePersonIds;
        Map<Long, Long> personEmployeeIdMap = candidateCollection.stream().filter(candidateObj -> !finalCandidatePersonIds.contains(HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("fbasedataid").getDynamicObject(PROPERTY_PERSON)))).collect(Collectors.toMap(candidateObj -> HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("fbasedataid").getDynamicObject(PROPERTY_PERSON)), candidateObj -> HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("fbasedataid")), (v1, v2) -> v2));
        this.loadCandidateCardInfo(isAddCandidate, personEmployeeIdMap, plugin);
    }

    public void loadCandidateCardEntry(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        String candidateBase64String = plugin.getPageCache().get("candidateentry");
        if (!HRStringUtils.isEmpty((String)candidateBase64String)) {
            model.deleteEntryData("candidateentry");
            DynamicObjectCollection candidateEntry = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)candidateBase64String);
            model.getDataEntity(true).getDynamicObjectCollection("candidateentry").addAll((Collection)candidateEntry);
            this.setCandidateCardVisible(plugin);
            plugin.getPageCache().remove("candidateentry");
            return;
        }
        Map<Long, Long> personEmployeeIdMap = entryEntity.stream().collect(Collectors.toMap(entry -> HRDyObjectPropUtil.getId((DynamicObject)entry.getDynamicObject(PROPERTY_PERSON)), entry -> HRDyObjectPropUtil.getId((DynamicObject)entry.getDynamicObject("candidate")), (v1, v2) -> v2));
        String isAddCandidate = "0";
        this.loadCandidateCardInfo(isAddCandidate, personEmployeeIdMap, plugin);
    }

    public void loadCandidateCardInfo(String isAddCandidate, Map<Long, Long> personEmployeeIdMap, AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        List<Map<String, Object>> personInfos = this.queryCandidatePersonInfo(personEmployeeIdMap);
        if (!"1".equals(isAddCandidate)) {
            DynamicObjectCollection candidateDBEntry = model.getEntryEntity("entryentity");
            List candPersonIds = candidateDBEntry.stream().map(entry -> HRDyObjectPropUtil.getId((DynamicObject)entry.getDynamicObject(PROPERTY_PERSON))).collect(Collectors.toList());
            personInfos.sort(Comparator.comparingInt(personInfo -> {
                Long personId = (Long)personInfo.get("card_person");
                return candPersonIds.indexOf(personId);
            }));
        }
        Map<Long, List<BrewMatchBo>> brewMatchData = new HashMap<Long, List<BrewMatchBo>>(16);
        if (!plugin.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            brewMatchData = this.queryBrewMatchData(plugin);
        }
        this.setCandidateCardInfo(personInfos, brewMatchData, plugin);
        this.calculateCandidateEntryData(plugin);
    }

    public void calculateCandidateEntryData(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        int passNum = 0;
        int notPassNum = 0;
        DynamicObjectCollection candidateEntry = model.getEntryEntity("candidateentry");
        if (CollectionUtils.isEmpty((Collection)candidateEntry)) {
            return;
        }
        int candidateNum = candidateEntry.size();
        for (DynamicObject entryRow : candidateEntry) {
            String isBrewPass = entryRow.getString("isbrewpass");
            passNum = this.calculateBrewPass(isBrewPass, passNum);
            notPassNum = this.calculateBrewNotPass(isBrewPass, notPassNum);
        }
        int conclusionNum = candidateNum - passNum - notPassNum;
        this.setCandidateCountData(candidateNum, passNum, notPassNum, conclusionNum, plugin);
        this.setCandidateNumValue(candidateNum, passNum, plugin);
    }

    private int calculateBrewPass(String isBrewPass, int passCount) {
        if (HRStringUtils.equals((String)isBrewPass, (String)"1")) {
            ++passCount;
        }
        return passCount;
    }

    private int calculateBrewNotPass(String isBrewPass, int notPassNum) {
        if (HRStringUtils.equals((String)isBrewPass, (String)"0")) {
            ++notPassNum;
        }
        return notPassNum;
    }

    private void setCandidateCountData(int candidateCount, int passCount, int notPassCount, int conclusionCount, AbstractFormPlugin plugin) {
        Label candidateCountLabel = (Label)plugin.getControl(LBL_CANDIDATENUM);
        Label passCountLabel = (Label)plugin.getControl(LBL_PASSNUM);
        Label notPassCountLabel = (Label)plugin.getControl(LBL_NOTPASSNUM);
        Label conclusionCountLabel = (Label)plugin.getControl(LBL_CONCLUSIONNUM);
        candidateCountLabel.setText(String.valueOf(candidateCount));
        passCountLabel.setText(String.valueOf(passCount));
        notPassCountLabel.setText(String.valueOf(notPassCount));
        conclusionCountLabel.setText(String.valueOf(conclusionCount));
    }

    private void setCandidateNumValue(int candidateNum, int passNum, AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        OperationStatus status = plugin.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) || status.equals((Object)OperationStatus.EDIT)) {
            model.setValue("candidatenum", (Object)candidateNum);
            model.setValue("brewpassnum", (Object)passNum);
        }
    }

    private void setCandidateCardInfo(List<Map<String, Object>> personInfos, Map<Long, List<BrewMatchBo>> brewMatchData, AbstractFormPlugin plugin) {
        int size = personInfos.size();
        if (size <= 0) {
            return;
        }
        IDataModel model = plugin.getView().getModel();
        DynamicObjectCollection candidateEntry = model.getEntryEntity("candidateentry");
        DynamicObjectCollection candidateEntryClone = (DynamicObjectCollection)candidateEntry.clone();
        model.deleteEntryData("candidateentry");
        String isAddCandidate = plugin.getPageCache().get(CACHEKEY_ISADDCANDIDATE);
        if ("1".equals(isAddCandidate) && !CollectionUtils.isEmpty((Collection)candidateEntryClone)) {
            model.getDataEntity(true).getDynamicObjectCollection("candidateentry").addAll((Collection)candidateEntryClone);
            plugin.getPageCache().put(CACHEKEY_ISADDCANDIDATE, "0");
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        Map<Long, DynamicObject> candidateEntryMap = entryEntity.stream().collect(Collectors.toMap(entry -> HRDyObjectPropUtil.getId((DynamicObject)entry.getDynamicObject(PROPERTY_PERSON)), entry -> entry, (v1, v2) -> v2));
        int[] entryIndex = model.batchCreateNewEntryRow("candidateentry", size);
        for (int i = 0; i < size; ++i) {
            DynamicObject candidateObj;
            Map<String, Object> personInfo = personInfos.get(i);
            if (personInfo == null || personInfo.isEmpty()) continue;
            Long personId = (Long)personInfo.get("card_person");
            String ageValue = (String)personInfo.get("card_age");
            Long genderId = (Long)personInfo.get("card_gender");
            genderId = genderId == 0L ? Long.valueOf(1030L) : genderId;
            Long adminorgId = (Long)personInfo.get("card_adminorg");
            String positionType = (String)personInfo.get("card_positionType");
            Long positionId = (Long)personInfo.get("card_position");
            Long jobId = (Long)personInfo.get("card_job");
            Long stdPositionId = (Long)personInfo.get("card_stdPosition");
            Long employeeId = (Long)personInfo.get("card_employee");
            Long companyId = (Long)personInfo.get("card_company");
            Long cmpEmpId = (Long)personInfo.get("card_cmpemp");
            Long depEmpId = (Long)personInfo.get("card_depemp");
            int positionNum = (Integer)personInfo.get("card_positionnum");
            int managePositionNum = (Integer)personInfo.get("card_managepositionnum");
            String serviceLenValue = (String)personInfo.get("card_servicelen");
            String entServiceLenValue = (String)personInfo.get("card_entservicelen");
            StringBuilder jobLevelInfo = (StringBuilder)personInfo.get("card_joblevel");
            boolean isManagePos = (Boolean)personInfo.get("card_ismanageposition");
            model.setValue("candcardperson", (Object)personId, entryIndex[i]);
            model.setValue("candcardemployee", (Object)employeeId, entryIndex[i]);
            model.setValue("candcardadminorg", (Object)adminorgId, entryIndex[i]);
            model.setValue("candcardpositiontype", (Object)positionType, entryIndex[i]);
            model.setValue("candcardposition", (Object)positionId, entryIndex[i]);
            model.setValue("candcardstdposition", (Object)stdPositionId, entryIndex[i]);
            model.setValue("candcardjob", (Object)jobId, entryIndex[i]);
            model.setValue("candcardcompany", (Object)companyId, entryIndex[i]);
            model.setValue("candcardcmpemp", (Object)cmpEmpId, entryIndex[i]);
            model.setValue("candcarddepemp", (Object)depEmpId, entryIndex[i]);
            model.setValue("candcardage", (Object)ageValue, entryIndex[i]);
            model.setValue("candcardgender", (Object)genderId, entryIndex[i]);
            model.setValue("candcardservicelen", (Object)serviceLenValue, entryIndex[i]);
            model.setValue("candcardentservicelen", (Object)entServiceLenValue, entryIndex[i]);
            model.setValue("candcardjoblevel", (Object)jobLevelInfo.toString(), entryIndex[i]);
            model.setValue("candcardposnum", (Object)String.valueOf(positionNum), entryIndex[i]);
            model.setValue("candcardmanageposnum", (Object)String.valueOf(managePositionNum), entryIndex[i]);
            model.setValue("candcardismanagepos", (Object)(isManagePos ? "1" : "0"), entryIndex[i]);
            List<BrewMatchBo> brewMatchBoList = brewMatchData.get(employeeId);
            if (!CollectionUtils.isEmpty(brewMatchBoList)) {
                Map<String, String> propertyMapping = this.getCardMatchFieldMapping();
                for (BrewMatchBo brewMatchBo : brewMatchBoList) {
                    String matchFieldName = propertyMapping.get(brewMatchBo.getMatchItemNumber());
                    model.setValue(matchFieldName, (Object)brewMatchBo.getMatchResult(), entryIndex[i]);
                }
            }
            if ((candidateObj = candidateEntryMap.get(personId)) == null) continue;
            String isBrewPass = candidateObj.getString("brewconclusion");
            String brewComment = candidateObj.getString("brewcomment");
            long nominateHandlerId = HRDyObjectPropUtil.getId((DynamicObject)candidateObj.getDynamicObject("nomhandler"));
            model.setValue("isbrewpass", (Object)isBrewPass, entryIndex[i]);
            model.setValue("candbrewcomment", (Object)brewComment, entryIndex[i]);
            model.setValue("nominatehandler", (Object)nominateHandlerId, entryIndex[i]);
        }
        model.updateCache();
        this.setCandidateCardVisible(plugin);
        plugin.getView().updateView("candidateentry");
    }

    public Map<String, String> getCardMatchFieldMapping() {
        HashMap<String, String> propertyMapping = new HashMap<String, String>(16);
        propertyMapping.put(BrewPersonPositionMatchEnum.DIPLOMA.getNumber(), "diplomaismatch");
        propertyMapping.put(BrewPersonPositionMatchEnum.AGE.getNumber(), "ageismatch");
        propertyMapping.put(BrewPersonPositionMatchEnum.KNOWLEDGE.getNumber(), "knowledgeismatch");
        propertyMapping.put(BrewPersonPositionMatchEnum.SKILL.getNumber(), "skillismatch");
        propertyMapping.put(BrewPersonPositionMatchEnum.ABILITY.getNumber(), "abilityismatch");
        propertyMapping.put(BrewPersonPositionMatchEnum.EXPERIENCE.getNumber(), "expismatch");
        return propertyMapping;
    }

    private Map<Long, List<BrewMatchBo>> queryBrewMatchData(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        String allMatchDataBase64String = plugin.getPageCache().get(CACHE_BREWMATCHDETAIL);
        if (!HRStringUtils.isEmpty((String)allMatchDataBase64String)) {
            Map allMatchData = (Map)SerializationUtils.deSerializeFromBase64((String)allMatchDataBase64String);
            return allMatchData;
        }
        long billId = model.getDataEntity().getLong("id");
        DynamicObject[] brewMatchResult = brewBillApplicationService.queryBrewMatchResult(Long.valueOf(billId));
        Map<Long, List<BrewMatchBo>> brewMatchData = Arrays.stream(brewMatchResult).map(matchResultDy -> {
            BrewMatchBo brewMatchBo = new BrewMatchBo();
            brewMatchBo.setBrewBillId(Long.valueOf(billId));
            brewMatchBo.setCandEmployeeId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)matchResultDy.getDynamicObject("candemployee"))));
            brewMatchBo.setPersonPositionId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)matchResultDy.getDynamicObject("personposition"))));
            brewMatchBo.setMatchPositionId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)matchResultDy.getDynamicObject("matchposition"))));
            brewMatchBo.setMatchResult(matchResultDy.getString("matchresult"));
            brewMatchBo.setMatchItemNumber(matchResultDy.getString("matchitemnumber"));
            brewMatchBo.setPersonInfo(matchResultDy.getLocaleString("personinfo"));
            brewMatchBo.setPositionReq(matchResultDy.getLocaleString("positionreq"));
            return brewMatchBo;
        }).collect(Collectors.groupingBy(BrewMatchBo::getCandEmployeeId));
        return brewMatchData;
    }

    private List<Map<String, Object>> queryCandidatePersonInfo(Map<Long, Long> personEmployeeIdMap) {
        ArrayList<Long> candidatePersonIds = new ArrayList<Long>(personEmployeeIdMap.keySet());
        ArrayList<Long> candidateEmployeeIds = new ArrayList<Long>(personEmployeeIdMap.values());
        List<Map<String, Object>> personInfos = this.queryPersonBaseInfo(candidatePersonIds, candidateEmployeeIds);
        Map personEmpposorgrelMap = brewBillApplicationService.queryEmpposorgrels(candidatePersonIds);
        HashMap primaryEmpposorgrelMap = new HashMap(16);
        for (Map.Entry entry : personEmpposorgrelMap.entrySet()) {
            Optional<Map> optionalObject = ((List)entry.getValue()).stream().filter(objMap -> objMap.get("isprimary").equals(Boolean.TRUE)).findFirst();
            if (!optionalObject.isPresent()) continue;
            Map primaryEmpposorgrel = optionalObject.get();
            primaryEmpposorgrelMap.put(entry.getKey(), primaryEmpposorgrel);
        }
        HashSet positionIds = new HashSet();
        HashSet stdPositionIds = new HashSet();
        HashSet jobIds = new HashSet();
        for (Map map : personInfos) {
            Long personId = (Long)map.get("card_person");
            List empposorgrelList = (List)personEmpposorgrelMap.get(personId);
            if (CollectionUtils.isEmpty((Collection)empposorgrelList)) continue;
            positionIds.addAll(empposorgrelList.stream().map(empposorgrelMap -> empposorgrelMap.get("position_id")).filter(id -> !id.equals(0L)).collect(Collectors.toSet()));
            stdPositionIds.addAll(empposorgrelList.stream().map(empposorgrelMap -> empposorgrelMap.get("stdposition_id")).filter(id -> !id.equals(0L)).collect(Collectors.toSet()));
            jobIds.addAll(empposorgrelList.stream().map(empposorgrelMap -> empposorgrelMap.get("job_id")).filter(id -> !id.equals(0L)).collect(Collectors.toSet()));
        }
        List managePositionIds = brewBillApplicationService.queryManagePosition(Arrays.asList(positionIds.toArray()));
        List list = brewBillApplicationService.queryManageStandardPosition(Arrays.asList(stdPositionIds.toArray()));
        List manageJobIds = brewBillApplicationService.queryManageJob(Arrays.asList(jobIds.toArray()));
        for (Map<String, Object> personInfo : personInfos) {
            Long personId = (Long)personInfo.get("card_person");
            HashMap primaryEmpposorgrelInfo = (HashMap)primaryEmpposorgrelMap.get(personId);
            if (primaryEmpposorgrelInfo == null) {
                primaryEmpposorgrelInfo = new HashMap(16);
            }
            Long adminorgId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("adminorg_id"), Long.class);
            String positionType = (String)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("apositiontype"), String.class);
            Long positionId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("position_id"), Long.class);
            Long jobId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("job_id"), Long.class);
            Long stdPositionId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("stdposition_id"), Long.class);
            Long depEmpId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("depemp_id"), Long.class);
            Long companyId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("company_id"), Long.class);
            Long cmpEmpId = (Long)CastUtils.setDefaultValueIfNullObject(primaryEmpposorgrelInfo.get("cmpemp_id"), Long.class);
            Long employeeId = personEmployeeIdMap.get(personId);
            List curEmpPosOrgRelList = (List)personEmpposorgrelMap.get(personId);
            int positionNum = 0;
            boolean isExists = false;
            int managePositionNum = 0;
            if (!CollectionUtils.isEmpty((Collection)curEmpPosOrgRelList)) {
                positionNum = curEmpPosOrgRelList.size();
                Map<String, Object> manageResult = this.getManageResult(curEmpPosOrgRelList, managePositionIds, list, manageJobIds);
                managePositionNum = (Integer)manageResult.get("manageNum");
                isExists = (Boolean)manageResult.get("isExists");
            }
            personInfo.put("card_adminorg", adminorgId);
            personInfo.put("card_positionType", positionType);
            personInfo.put("card_position", positionId);
            personInfo.put("card_job", jobId);
            personInfo.put("card_stdPosition", stdPositionId);
            personInfo.put("card_employee", employeeId);
            personInfo.put("card_depemp", depEmpId);
            personInfo.put("card_company", companyId);
            personInfo.put("card_cmpemp", cmpEmpId);
            personInfo.put("card_positionnum", positionNum);
            personInfo.put("card_managepositionnum", managePositionNum);
            personInfo.put("card_ismanageposition", isExists);
        }
        return personInfos;
    }

    private Map<String, Object> getManageResult(List<Map<String, Object>> curEmpPosOrgRelList, List<Long> managePositionIds, List<Long> manageStdPositionIds, List<Long> manageJobIds) {
        int managePositionNum = 0;
        boolean isExists = false;
        for (Map<String, Object> map : curEmpPosOrgRelList) {
            String positionType = (String)CastUtils.setDefaultValueIfNullObject((Object)map.get("apositiontype"), String.class);
            Long positionId = (Long)CastUtils.setDefaultValueIfNullObject((Object)map.get("position_id"), Long.class);
            Long jobId = (Long)CastUtils.setDefaultValueIfNullObject((Object)map.get("job_id"), Long.class);
            Long stdPositionId = (Long)CastUtils.setDefaultValueIfNullObject((Object)map.get("stdposition_id"), Long.class);
            Boolean isPrimary = (Boolean)CastUtils.setDefaultValueIfNullObject((Object)map.get("isprimary"), Boolean.class);
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType) && managePositionIds.contains(positionId)) {
                ++managePositionNum;
                if (isPrimary.booleanValue()) {
                    isExists = true;
                }
            }
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) && manageStdPositionIds.contains(stdPositionId)) {
                ++managePositionNum;
                if (isPrimary.booleanValue()) {
                    isExists = true;
                }
            }
            if (!PositionTypeEnum.JOB.getNumber().equals(positionType) || !manageJobIds.contains(jobId)) continue;
            ++managePositionNum;
            if (!isPrimary.booleanValue()) continue;
            isExists = true;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("manageNum", managePositionNum);
        result.put("isExists", isExists);
        return result;
    }

    private List<Map<String, Object>> queryPersonBaseInfo(List<Long> personIds, List<Long> candidateEmployeeIds) {
        Map empJobRelObjMap = brewBillApplicationService.getEmpJobRelGroupByPersonId(candidateEmployeeIds);
        List personInfos = ExternalDataService.listPersonInfos(personIds);
        ArrayList<Map<String, Object>> personInfoList = new ArrayList<Map<String, Object>>(personIds.size());
        for (Map perInfoMap : personInfos) {
            Long personId = (Long)perInfoMap.get("id");
            HashMap<String, Object> personInfoMap = new HashMap<String, Object>(16);
            Map empJobRel = (Map)empJobRelObjMap.get(personId);
            Integer age = (Integer)CastUtils.setDefaultValueIfNullObject(perInfoMap.get("age"), Integer.class);
            Long genderId = (Long)CastUtils.setDefaultValueIfNullObject(perInfoMap.get("gender_id"), Long.class);
            BigDecimal serviceLength = (BigDecimal)CastUtils.setDefaultValueIfNullObject(perInfoMap.get("servicelen"), BigDecimal.class);
            BigDecimal serviceLengthValue = serviceLength.setScale(1, RoundingMode.HALF_UP);
            BigDecimal entServiceLen = (BigDecimal)CastUtils.setDefaultValueIfNullObject(perInfoMap.get("entservicelen"), BigDecimal.class);
            BigDecimal entServiceLenValue = entServiceLen.setScale(1, RoundingMode.HALF_UP);
            StringBuilder jobLevelInfo = new StringBuilder();
            if (empJobRel != null) {
                String jobSeq = (String)CastUtils.setDefaultValueIfNullObject(empJobRel.get("jobseq.name"), String.class);
                String jobLevel = (String)CastUtils.setDefaultValueIfNullObject(empJobRel.get("joblevel.name"), String.class);
                jobLevelInfo.append(jobSeq).append(jobLevel);
                String jobGrade = (String)CastUtils.setDefaultValueIfNullObject(empJobRel.get("jobgrade.name"), String.class);
                if (HRStringUtils.isNotEmpty((String)jobLevelInfo.toString()) && HRStringUtils.isNotEmpty((String)jobGrade)) {
                    jobLevelInfo.append("-").append(jobGrade);
                } else {
                    jobLevelInfo.append(jobGrade);
                }
            } else {
                LOG.error("BrewBillEdit.queryCardPersonInfo: PersonId is {}, query empjobrel is empty", (Object)personId);
            }
            personInfoMap.put("card_person", personId);
            personInfoMap.put("card_age", String.valueOf(age));
            personInfoMap.put("card_gender", genderId);
            personInfoMap.put("card_servicelen", String.valueOf(serviceLengthValue.stripTrailingZeros()));
            personInfoMap.put("card_entservicelen", String.valueOf(entServiceLenValue.stripTrailingZeros()));
            personInfoMap.put("card_joblevel", jobLevelInfo);
            personInfoList.add(personInfoMap);
        }
        return personInfoList;
    }

    private void setCandidateCardVisible(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        CardEntry cardEntry = (CardEntry)plugin.getControl("candidateentry");
        DynamicObjectCollection candidateEntry = model.getEntryEntity("candidateentry");
        for (int i = 0; i < candidateEntry.size(); ++i) {
            String jobLevelInfo;
            String entServiceLenValue;
            String serviceLenValue;
            String managePositionNum;
            String positionNum;
            String ageValue = ((DynamicObject)candidateEntry.get(i)).getString("candcardage");
            if (HRStringUtils.isEmpty((String)ageValue) || HRStringUtils.equals((String)ageValue, (String)"0")) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardflexage"});
            }
            if (HRStringUtils.isEmpty((String)(positionNum = ((DynamicObject)candidateEntry.get(i)).getString("candcardposnum"))) || HRStringUtils.equals((String)positionNum, (String)"0")) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardpos"});
            }
            if (HRStringUtils.isEmpty((String)(managePositionNum = ((DynamicObject)candidateEntry.get(i)).getString("candcardmanageposnum"))) || HRStringUtils.equals((String)managePositionNum, (String)"0")) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardmanagepos"});
            }
            if (HRStringUtils.isEmpty((String)(serviceLenValue = ((DynamicObject)candidateEntry.get(i)).getString("candcardservicelen"))) || HRStringUtils.equals((String)serviceLenValue, (String)"0")) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardflexservicelen"});
            }
            if (HRStringUtils.isEmpty((String)(entServiceLenValue = ((DynamicObject)candidateEntry.get(i)).getString("candcardentservicelen"))) || HRStringUtils.equals((String)entServiceLenValue, (String)"0")) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardflexentservicelen"});
            }
            if (!HRStringUtils.isEmpty((String)(jobLevelInfo = ((DynamicObject)candidateEntry.get(i)).getString("candcardjoblevel"))) && !HRStringUtils.equals((String)jobLevelInfo, (String)"-")) continue;
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardflexjoblevel"});
        }
    }
}

