/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.BrewBillCandidateFormService;

public class BrewBillPositionPersonFormService {
    private static final Log logger = LogFactory.getLog(BrewBillPositionPersonFormService.class);
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);
    private static final BrewBillCandidateFormService candidateFormService = (BrewBillCandidateFormService)ServiceFactory.getService(BrewBillCandidateFormService.class);
    private static final int PAGE_SIZE = 10;
    private static final String KEY_SIGN_POS_ID = "signPosId";
    private static final String KEY_PER_POS_ORG_REL_MAP = "perPosOrgRelMap";
    private static final String KEY_ALL_PERSON_IDS = "allPersonIds";

    public void loadPositionPersonCardEntry(AbstractFormPlugin plugin, int page) {
        ArrayList allPersonIds;
        page = page < 1 ? 1 : page;
        IFormView formView = plugin.getView();
        formView.setEnable(Boolean.valueOf(page != 1), new String[]{"prepage"});
        formView.getModel().setValue("currentpage", (Object)page);
        IPageCache pageCache = formView.getPageCache();
        String cachedTotalPageStr = pageCache.get("totalpage");
        if (HRStringUtils.isNotEmpty((String)cachedTotalPageStr)) {
            int cachedTotalPage = Integer.parseInt(cachedTotalPageStr);
            formView.getModel().setValue("totalpage", (Object)cachedTotalPage);
        }
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        DynamicObject posDynObj = null;
        String positionType = dataEntity.getString("positiontype") == null ? "" : dataEntity.getString("positiontype");
        String sign = "";
        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            posDynObj = dataEntity.getDynamicObject("brewstandardposition");
            sign = "stdposition";
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            posDynObj = dataEntity.getDynamicObject("brewposition");
            sign = "position";
        }
        if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            posDynObj = dataEntity.getDynamicObject("brewjob");
            sign = "job";
        }
        if (posDynObj == null) {
            formView.setVisible(Boolean.FALSE, new String[]{"totalcadres", "pagingflex"});
            return;
        }
        Long posId = posDynObj.getLong("id");
        String signPosId = String.format("%s-%d", sign, posId);
        String cachedSignPosId = pageCache.get(KEY_SIGN_POS_ID);
        Map perPosOrgRelMap = new HashMap();
        if (signPosId.equals(cachedSignPosId)) {
            String perPosOrgRelMapStr = pageCache.get(KEY_PER_POS_ORG_REL_MAP);
            perPosOrgRelMap = (Map)SerializationUtils.deSerializeFromBase64((String)perPosOrgRelMapStr);
            allPersonIds = (ArrayList)SerializationUtils.deSerializeFromBase64((String)pageCache.get(KEY_ALL_PERSON_IDS));
        } else {
            pageCache.put(KEY_SIGN_POS_ID, signPosId);
            Map personMap = brewBillApplicationService.queryEmpOrgRelByPos(sign, posId);
            logger.info("listEmpOrgRelByPos return data:{}", (Object)personMap);
            boolean success = (Boolean)personMap.get("success");
            if (!success) {
                return;
            }
            Map data = (Map)personMap.get("data");
            Map finalPerPosOrgRelMap = perPosOrgRelMap;
            data.entrySet().forEach(entry -> {
                List value = (List)entry.getValue();
                value.stream().forEach(map -> {
                    Map person = (Map)map.get("hrpi_person");
                    if (person != null) {
                        Long pId = (Long)person.get("id");
                        finalPerPosOrgRelMap.put(pId, map);
                    }
                });
            });
            perPosOrgRelMap = finalPerPosOrgRelMap;
            pageCache.put(KEY_PER_POS_ORG_REL_MAP, SerializationUtils.serializeToBase64(perPosOrgRelMap));
            allPersonIds = new ArrayList(finalPerPosOrgRelMap.keySet());
            pageCache.put(KEY_ALL_PERSON_IDS, SerializationUtils.serializeToBase64(allPersonIds));
            Label totalNumLabel = (Label)formView.getControl("totalnum");
            String totalNumStr = ResManager.loadKDString((String)"\u5171{0}\u6761", (String)"BrewBillPositionPersonFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{allPersonIds.size()});
            totalNumLabel.setText(totalNumStr);
            int totalPage = (allPersonIds.size() - 1) / 10 + 1;
            formView.getModel().setValue("totalpage", (Object)totalPage);
            pageCache.put("totalpage", String.valueOf(totalPage));
        }
        int totalPage = (Integer)formView.getModel().getValue("totalpage");
        formView.setEnable(Boolean.valueOf(page != totalPage), new String[]{"nextpage"});
        boolean allPersonIdsIsNotEmpty = allPersonIds.size() > 0;
        formView.setVisible(Boolean.valueOf(allPersonIds.size() > 10), new String[]{"pagingflex"});
        formView.setVisible(Boolean.valueOf(allPersonIdsIsNotEmpty), new String[]{"totalcadres"});
        if (allPersonIdsIsNotEmpty) {
            ArrayList<Long> employeeIds = new ArrayList<Long>(10);
            HashMap personInfoList = new HashMap(16);
            int fromIndex = (page - 1) * 10;
            fromIndex = fromIndex < 0 ? 0 : fromIndex;
            int toIndex = page * 10;
            toIndex = toIndex > allPersonIds.size() ? allPersonIds.size() : toIndex;
            List personIds = allPersonIds.subList(fromIndex, toIndex);
            List personInfos = ExternalDataService.listPersonInfos(personIds);
            for (Map personInfoMap : personInfos) {
                Long perId = (Long)personInfoMap.get("id");
                Map value = (Map)perPosOrgRelMap.get(perId);
                Map hrpiEmpposorgrel = (Map)value.get("hrpi_empposorgrel");
                if (hrpiEmpposorgrel == null) continue;
                long employeeId = (Long)hrpiEmpposorgrel.get("employee_id");
                long personId = (Long)hrpiEmpposorgrel.get("person_id");
                employeeIds.add(employeeId);
                Object serviceLength = personInfoMap.get("entservicelen");
                Object socialServiceLen = personInfoMap.get("servicelen");
                HashMap rltMap = new HashMap(16);
                rltMap.put("servicelength", serviceLength);
                rltMap.put("socialServiceLen", socialServiceLen);
                rltMap.put("person.id", personId);
                Object genderId = personInfoMap.get("gender_id");
                Object age = personInfoMap.get("age");
                rltMap.put("gender.id", genderId);
                rltMap.put("age", age);
                personInfoList.put(personId, rltMap);
            }
            Map empJobRelInfo = brewBillApplicationService.getEmpJobRelGroupByPersonId(employeeIds);
            ArrayList<Map<String, Object>> personCardInfoList = new ArrayList<Map<String, Object>>(personInfoList.values());
            List<Map<String, Object>> positionPersonInfo = this.getPositionCardPersonInfo(personCardInfoList, empJobRelInfo);
            this.setPositionPersonCardEntry(positionPersonInfo, plugin);
            return;
        }
        IDataModel model = formView.getModel();
        model.deleteEntryData("pospersonentry");
        formView.updateView("pospersonentry");
    }

    private void setPositionPersonCardEntry(List<Map<String, Object>> positionCardPersonInfo, AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        model.deleteEntryData("pospersonentry");
        model.updateCache();
        int size = positionCardPersonInfo.size();
        if (size <= 0) {
            return;
        }
        CardEntry cardEntry = (CardEntry)plugin.getControl("pospersonentry");
        model.beginInit();
        int[] entryIndex = model.batchCreateNewEntryRow("pospersonentry", size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> personInfo = positionCardPersonInfo.get(i);
            Long personId = (Long)personInfo.get("card_person");
            String age = (String)personInfo.get("card_age");
            Long genderId = (Long)personInfo.get("card_gender");
            String serviceLen = (String)personInfo.get("card_servicelen");
            String entServiceLen = (String)personInfo.get("card_entservicelen");
            String jobLevelInfo = (String)personInfo.get("card_joblevel");
            model.setValue("posperson", (Object)personId, entryIndex[i]);
            model.setValue("posperage", (Object)age, entryIndex[i]);
            model.setValue("pospergender", (Object)genderId, entryIndex[i]);
            model.setValue("posperservicelen", (Object)serviceLen, entryIndex[i]);
            model.setValue("posperentservicelen", (Object)entServiceLen, entryIndex[i]);
            if (!HRStringUtils.isNotEmpty((String)jobLevelInfo)) continue;
            model.setValue("posperjoblevel", (Object)jobLevelInfo, entryIndex[i]);
        }
        plugin.getView().updateView("pospersonentry");
        model.endInit();
    }

    private List<Map<String, Object>> getPositionCardPersonInfo(List<Map<String, Object>> personInfoList, Map<Long, Map<String, Object>> empJobRelInfo) {
        ArrayList<Map<String, Object>> positionPersonInfoList = new ArrayList<Map<String, Object>>(personInfoList.size());
        for (Map<String, Object> personInfo : personInfoList) {
            HashMap<String, Object> personInfoMap = new HashMap<String, Object>(16);
            Long personId = (Long)personInfo.get("person.id");
            personInfoMap.put("card_person", personId);
            Object age = HRObjectUtils.isEmpty((Object)personInfo.get("age")) ? Integer.valueOf(0) : personInfo.get("age");
            personInfoMap.put("card_age", String.valueOf(age));
            personInfoMap.put("card_gender", personInfo.get("gender.id"));
            String socialServiceLen = personInfo.get("socialServiceLen") == null ? "0" : ((BigDecimal)personInfo.get("socialServiceLen")).setScale(1, RoundingMode.UP).stripTrailingZeros().toPlainString();
            personInfoMap.put("card_servicelen", socialServiceLen);
            String serviceLength = personInfo.get("servicelength") == null ? "0" : ((BigDecimal)personInfo.get("servicelength")).setScale(1, RoundingMode.UP).stripTrailingZeros().toPlainString();
            personInfoMap.put("card_entservicelen", serviceLength);
            StringBuilder jobLevelInfo = new StringBuilder();
            Map<String, Object> empJobRel = empJobRelInfo.get(personId);
            if (empJobRel != null) {
                String jobSeq = (String)CastUtils.setDefaultValueIfNullObject((Object)empJobRel.get("jobseq.name"), String.class);
                String jobLevel = (String)CastUtils.setDefaultValueIfNullObject((Object)empJobRel.get("joblevel.name"), String.class);
                jobLevelInfo.append(jobSeq).append(jobLevel);
                String jobGrade = (String)CastUtils.setDefaultValueIfNullObject((Object)empJobRel.get("jobgrade.name"), String.class);
                if (HRStringUtils.isNotEmpty((String)jobLevelInfo.toString()) && HRStringUtils.isNotEmpty((String)jobGrade)) {
                    jobLevelInfo.append("-").append(jobGrade);
                } else {
                    jobLevelInfo.append(jobGrade);
                }
            }
            personInfoMap.put("card_joblevel", jobLevelInfo.toString());
            positionPersonInfoList.add(personInfoMap);
        }
        return positionPersonInfoList;
    }
}

