/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewOpExcelExportService {
    public List<HRExportHeadObject> createExcelHeadData(String opKey) {
        ArrayList<HRExportHeadObject> headDatalist = new ArrayList<HRExportHeadObject>(16);
        headDatalist.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BrewOpExcelExportService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("position", ResManager.loadKDString((String)"\u915d\u917f\u5c97\u4f4d", (String)"BrewOpExcelExportService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("job", ResManager.loadKDString((String)"\u915d\u917f\u804c\u4f4d", (String)"BrewOpExcelExportService_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("standardPosition", ResManager.loadKDString((String)"\u915d\u917f\u6807\u51c6\u5c97\u4f4d", (String)"BrewOpExcelExportService_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("status", ResManager.loadKDString((String)"\u915d\u917f\u72b6\u6001", (String)"BrewOpExcelExportService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        if (opKey.equals("revocation")) {
            headDatalist.add(new HRExportHeadObject("ismatch", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u64a4\u9500", (String)"BrewOpExcelExportService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject("failreason", ResManager.loadKDString((String)"\u4e0d\u53ef\u64a4\u9500\u7684\u539f\u56e0", (String)"BrewOpExcelExportService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        if (opKey.equals("listdelete")) {
            headDatalist.add(new HRExportHeadObject("ismatch", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5220\u9664", (String)"BrewOpExcelExportService_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject("failreason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u7684\u539f\u56e0", (String)"BrewOpExcelExportService_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
        }
        return headDatalist;
    }

    public List<Map<String, Object>> createExcelExportData(OperationResult operationResult, DynamicObject[] brewBills) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject brewBill : brewBills) {
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            String billNo = brewBill.getString("billno");
            excelRowData.put("billno", billNo);
            String billStatus = brewBill.getString("brewstatus");
            excelRowData.put("status", BrewStatusEnum.getName((String)billStatus));
            String positionType = brewBill.getString("positiontype");
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                String brewPosition = brewBill.getDynamicObject("brewposition").getString("name");
                excelRowData.put("position", brewPosition);
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                String brewJob = brewBill.getDynamicObject("brewjob").getString("name");
                excelRowData.put("job", brewJob);
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                String brewStandardPosition = brewBill.getDynamicObject("brewstandardposition").getString("name");
                excelRowData.put("standardPosition", brewStandardPosition);
            }
            long billId = brewBill.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put("ismatch", HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"BrewOpExcelExportService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BrewOpExcelExportService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            excelRowData.put("failreason", errorMessage);
            exportData.add(excelRowData);
        }
        return exportData;
    }
}

